/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CommandListenerMulticaster
implements CommandListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<CommandListener> commandListeners;

    public CommandListenerMulticaster(List<CommandListener> commandListeners) {
        Assertions.notNull("commandListeners", commandListeners);
        for (CommandListener cur : commandListeners) {
            Assertions.notNull("commandListener", cur);
        }
        this.commandListeners = new ArrayList<CommandListener>(commandListeners);
    }

    public List<CommandListener> getCommandListeners() {
        return Collections.unmodifiableList(this.commandListeners);
    }

    @Override
    public void commandStarted(CommandStartedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandStarted(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandSucceeded(CommandSucceededEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandSucceeded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandFailed(CommandFailedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandFailed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", cur), e);
            }
        }
    }
}

