/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.CommandResultBaseCallback;
import com.mongodb.connection.GenericWriteProtocol;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.RequestMessage;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WriteResultCallback
extends CommandResultBaseCallback<BsonDocument> {
    private final SingleResultCallback<WriteConcernResult> callback;
    private final MongoNamespace namespace;
    private final RequestMessage nextMessage;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final InternalConnection connection;

    public WriteResultCallback(SingleResultCallback<WriteConcernResult> callback, Decoder<BsonDocument> decoder, MongoNamespace namespace, RequestMessage nextMessage, boolean ordered, WriteConcern writeConcern, long requestId, InternalConnection connection) {
        super(decoder, requestId, connection.getDescription().getServerAddress());
        this.callback = callback;
        this.namespace = namespace;
        this.nextMessage = nextMessage;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.connection = connection;
    }

    @Override
    protected void callCallback(BsonDocument result, Throwable t) {
        if (t != null) {
            this.callback.onResult(null, t);
        } else {
            try {
                WriteConcernResult writeConcernResult = ProtocolHelper.getWriteResult(result, this.connection.getDescription().getServerAddress());
                if (this.nextMessage != null) {
                    new GenericWriteProtocol(this.namespace, this.nextMessage, this.ordered, this.writeConcern).executeAsync(this.connection, this.callback);
                } else {
                    this.callback.onResult(writeConcernResult, null);
                }
            }
            catch (Throwable t1) {
                this.callback.onResult(null, t1);
            }
        }
    }
}

