/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SocketStreamHelper;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.bson.ByteBuf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SocketChannelStream
implements Stream {
    private final ServerAddress address;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final BufferProvider bufferProvider;
    private volatile SocketChannel socketChannel;
    private volatile boolean isClosed;

    public SocketChannelStream(ServerAddress address, SocketSettings settings, SslSettings sslSettings, BufferProvider bufferProvider) {
        this.address = Assertions.notNull("address", address);
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.bufferProvider = Assertions.notNull("bufferProvider", bufferProvider);
    }

    @Override
    public void open() throws IOException {
        try {
            this.socketChannel = SocketChannel.open();
            SocketStreamHelper.initialize(this.socketChannel.socket(), this.address, this.settings, this.sslSettings);
        }
        catch (IOException e) {
            this.close();
            throw new MongoSocketOpenException("Exception opening socket", this.getAddress(), (Throwable)e);
        }
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.bufferProvider.getBuffer(size);
    }

    @Override
    public void write(List<ByteBuf> buffers) throws IOException {
        Assertions.isTrue("open", !this.isClosed());
        int totalSize = 0;
        ByteBuffer[] byteBufferArray = new ByteBuffer[buffers.size()];
        for (int i = 0; i < buffers.size(); ++i) {
            byteBufferArray[i] = buffers.get(i).asNIO();
            totalSize += byteBufferArray[i].limit();
        }
        for (long bytesRead = 0L; bytesRead < (long)totalSize; bytesRead += this.socketChannel.write(byteBufferArray)) {
        }
    }

    @Override
    public ByteBuf read(int numBytes) throws IOException {
        int bytesRead;
        ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
        Assertions.isTrue("open", !this.isClosed());
        for (int totalBytesRead = 0; totalBytesRead < buffer.limit(); totalBytesRead += bytesRead) {
            bytesRead = this.socketChannel.read(buffer.asNIO());
            if (bytesRead != -1) continue;
            buffer.release();
            throw new MongoSocketReadException("Prematurely reached end of stream", this.getAddress());
        }
        return buffer.flip();
    }

    @Override
    public void openAsync(AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void readAsync(int numBytes, AsyncCompletionHandler<ByteBuf> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    SocketSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        try {
            this.isClosed = true;
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

