/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.Authenticator;
import com.mongodb.connection.CommandHelper;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.InternalConnection;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SaslAuthenticator
extends Authenticator {
    SaslAuthenticator(MongoCredential credential) {
        super(credential);
    }

    @Override
    public void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        SaslClient saslClient = this.createSaslClient(connection.getDescription().getServerAddress());
        try {
            byte[] response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
            BsonDocument res = this.sendSaslStart(response, connection);
            BsonInt32 conversationId = res.getInt32("conversationId");
            while (!res.getBoolean("done").getValue()) {
                response = saslClient.evaluateChallenge(res.getBinary("payload").getData());
                if (response == null) {
                    throw new MongoSecurityException(this.getCredential(), "SASL protocol error: no client response to challenge for credential " + this.getCredential());
                }
                res = this.sendSaslContinue(conversationId, response, connection);
            }
        }
        catch (Exception e) {
            throw new MongoSecurityException(this.getCredential(), "Exception authenticating " + this.getCredential(), (Throwable)e);
        }
        finally {
            this.disposeOfSaslClient(saslClient);
        }
    }

    @Override
    void authenticateAsync(final InternalConnection connection, ConnectionDescription connectionDescription, final SingleResultCallback<Void> callback) {
        try {
            final SaslClient saslClient = this.createSaslClient(connection.getDescription().getServerAddress());
            byte[] response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
            this.sendSaslStartAsync(response, connection, new SingleResultCallback<BsonDocument>(){

                @Override
                public void onResult(BsonDocument result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, SaslAuthenticator.this.translateThrowable(t));
                    } else if (result.getBoolean("done").getValue()) {
                        callback.onResult(null, null);
                    } else {
                        new Continuator(saslClient, result, connection, callback).start();
                    }
                }
            });
        }
        catch (Exception e) {
            callback.onResult(null, this.translateThrowable(e));
        }
    }

    public abstract String getMechanismName();

    protected abstract SaslClient createSaslClient(ServerAddress var1);

    private BsonDocument sendSaslStart(byte[] outToken, InternalConnection connection) {
        return CommandHelper.executeCommand(this.getCredential().getSource(), this.createSaslStartCommandDocument(outToken), connection);
    }

    private BsonDocument sendSaslContinue(BsonInt32 conversationId, byte[] outToken, InternalConnection connection) {
        return CommandHelper.executeCommand(this.getCredential().getSource(), this.createSaslContinueDocument(conversationId, outToken), connection);
    }

    private void sendSaslStartAsync(byte[] outToken, InternalConnection connection, SingleResultCallback<BsonDocument> callback) {
        CommandHelper.executeCommandAsync(this.getCredential().getSource(), this.createSaslStartCommandDocument(outToken), connection, callback);
    }

    private void sendSaslContinueAsync(BsonInt32 conversationId, byte[] outToken, InternalConnection connection, SingleResultCallback<BsonDocument> callback) {
        CommandHelper.executeCommandAsync(this.getCredential().getSource(), this.createSaslContinueDocument(conversationId, outToken), connection, callback);
    }

    private BsonDocument createSaslStartCommandDocument(byte[] outToken) {
        return new BsonDocument("saslStart", new BsonInt32(1)).append("mechanism", new BsonString(this.getMechanismName())).append("payload", new BsonBinary(outToken != null ? outToken : new byte[]{}));
    }

    private BsonDocument createSaslContinueDocument(BsonInt32 conversationId, byte[] outToken) {
        return new BsonDocument("saslContinue", new BsonInt32(1)).append("conversationId", conversationId).append("payload", new BsonBinary(outToken));
    }

    private void disposeOfSaslClient(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    private MongoException translateThrowable(Throwable t) {
        return new MongoSecurityException(this.getCredential(), "Exception authenticating", t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Continuator
    implements SingleResultCallback<BsonDocument> {
        private final SaslClient saslClient;
        private final BsonDocument saslStartDocument;
        private final InternalConnection connection;
        private final SingleResultCallback<Void> callback;

        public Continuator(SaslClient saslClient, BsonDocument saslStartDocument, InternalConnection connection, SingleResultCallback<Void> callback) {
            this.saslClient = saslClient;
            this.saslStartDocument = saslStartDocument;
            this.connection = connection;
            this.callback = callback;
        }

        @Override
        public void onResult(BsonDocument result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, SaslAuthenticator.this.translateThrowable(t));
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            } else if (result.getBoolean("done").getValue()) {
                this.callback.onResult(null, null);
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            } else {
                this.continueConversation(result);
            }
        }

        public void start() {
            this.continueConversation(this.saslStartDocument);
        }

        private void continueConversation(BsonDocument result) {
            try {
                SaslAuthenticator.this.sendSaslContinueAsync(this.saslStartDocument.getInt32("conversationId"), this.saslClient.evaluateChallenge(result.getBinary("payload").getData()), this.connection, this);
            }
            catch (SaslException e) {
                this.callback.onResult(null, SaslAuthenticator.this.translateThrowable(e));
                SaslAuthenticator.this.disposeOfSaslClient(this.saslClient);
            }
        }
    }
}

