/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.connection.BaseQueryMessage;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.bson.BsonDocument;
import org.bson.io.BsonOutput;

class QueryMessage
extends BaseQueryMessage {
    private final BsonDocument queryDocument;
    private final BsonDocument fields;

    public QueryMessage(String collectionName, int skip, int numberToReturn, BsonDocument queryDocument, BsonDocument fields, MessageSettings settings) {
        super(collectionName, skip, numberToReturn, settings);
        this.queryDocument = queryDocument;
        this.fields = fields;
    }

    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        return this.encodeMessageBodyWithMetadata(bsonOutput, messageStartPosition).getNextMessage();
    }

    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition) {
        this.writeQueryPrologue(bsonOutput);
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(this.queryDocument, bsonOutput, new NoOpFieldNameValidator());
        if (this.fields != null) {
            this.addDocument(this.fields, bsonOutput, new NoOpFieldNameValidator());
        }
        return new RequestMessage.EncodingMetadata(null, firstDocumentStartPosition);
    }
}

