/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.bulk.DeleteRequest;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.List;
import org.bson.io.BsonOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeleteMessage
extends RequestMessage {
    private final List<DeleteRequest> deleteRequests;

    public DeleteMessage(String collectionName, List<DeleteRequest> deletes, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_DELETE, settings);
        this.deleteRequests = deletes;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        return this.encodeMessageBodyWithMetadata(bsonOutput, messageStartPosition).getNextMessage();
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition) {
        DeleteRequest deleteRequest = this.deleteRequests.get(0);
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        if (deleteRequest.isMulti()) {
            bsonOutput.writeInt32(0);
        } else {
            bsonOutput.writeInt32(1);
        }
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(deleteRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
        if (this.deleteRequests.size() == 1) {
            return new RequestMessage.EncodingMetadata(null, firstDocumentStartPosition);
        }
        return new RequestMessage.EncodingMetadata(new DeleteMessage(this.getCollectionName(), this.deleteRequests.subList(1, this.deleteRequests.size()), this.getSettings()), firstDocumentStartPosition);
    }
}

