/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ChangeListener;
import com.mongodb.connection.ConnectionPool;
import com.mongodb.connection.DefaultServerMonitor;
import com.mongodb.connection.InternalConnectionFactory;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerMonitor;
import com.mongodb.connection.ServerMonitorFactory;
import com.mongodb.connection.ServerSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultServerMonitorFactory
implements ServerMonitorFactory {
    private final ServerId serverId;
    private final ServerSettings settings;
    private final InternalConnectionFactory internalConnectionFactory;
    private final ConnectionPool connectionPool;

    DefaultServerMonitorFactory(ServerId serverId, ServerSettings settings, InternalConnectionFactory internalConnectionFactory, ConnectionPool connectionPool) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.settings = Assertions.notNull("settings", settings);
        this.internalConnectionFactory = Assertions.notNull("internalConnectionFactory", internalConnectionFactory);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
    }

    @Override
    public ServerMonitor create(ChangeListener<ServerDescription> serverStateListener) {
        return new DefaultServerMonitor(this.serverId, this.settings, serverStateListener, this.internalConnectionFactory, this.connectionPool);
    }
}

