/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.annotations.Beta;
import com.mongodb.assertions.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ChangeEvent<T> {
    private final T oldValue;
    private final T newValue;

    public ChangeEvent(T oldValue, T newValue) {
        this.oldValue = Assertions.notNull("oldValue", oldValue);
        this.newValue = Assertions.notNull("newValue", newValue);
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent that = (ChangeEvent)o;
        if (!this.newValue.equals(that.newValue)) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null);
    }

    public int hashCode() {
        int result = this.oldValue != null ? this.oldValue.hashCode() : 0;
        result = 31 * result + this.newValue.hashCode();
        return result;
    }

    public String toString() {
        return "ChangeEvent{oldValue=" + this.oldValue + ", newValue=" + this.newValue + '}';
    }
}

