/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Function;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.binding.ClusterBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.ReadWriteBinding;
import com.mongodb.binding.SingleServerBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Connection;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandListenerMulticaster;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.management.JMXConnectionPoolListener;
import com.mongodb.operation.ListDatabasesOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.operation.WriteOperation;
import com.mongodb.selector.LatencyMinimizingServerSelector;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class Mongo {
    static final String ADMIN_DATABASE_NAME = "admin";
    private final ConcurrentMap<String, DB> dbCache = new ConcurrentHashMap<String, DB>();
    private volatile WriteConcern writeConcern;
    private volatile ReadPreference readPreference;
    private final MongoClientOptions options;
    private final List<MongoCredential> credentialsList;
    private final Bytes.OptionHolder optionHolder;
    private final Cluster cluster;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final ConcurrentLinkedQueue<ServerCursorAndNamespace> orphanedCursors = new ConcurrentLinkedQueue();
    private final ExecutorService cursorCleaningService;

    @Deprecated
    public Mongo() {
        this(new ServerAddress(), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(String host) {
        this(new ServerAddress(host), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(String host, MongoOptions options) {
        this(new ServerAddress(host), options.toClientOptions());
    }

    @Deprecated
    public Mongo(String host, int port) {
        this(new ServerAddress(host, port), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress address) {
        this(address, Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress address, MongoOptions options) {
        this(address, options.toClientOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right) {
        this(Arrays.asList(left, right), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) {
        this(Arrays.asList(left, right), options.toClientOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds) {
        this(seeds, Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds, MongoOptions options) {
        this(seeds, options.toClientOptions());
    }

    @Deprecated
    public Mongo(MongoURI uri) {
        this(uri.toClientURI());
    }

    Mongo(List<ServerAddress> seedList, MongoClientOptions options) {
        this(seedList, Collections.emptyList(), options);
    }

    Mongo(ServerAddress serverAddress, MongoClientOptions options) {
        this(serverAddress, Collections.emptyList(), options);
    }

    Mongo(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this(Mongo.createCluster(serverAddress, credentialsList, options), options, credentialsList);
    }

    Mongo(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this(Mongo.createCluster(seedList, credentialsList, options), options, credentialsList);
    }

    Mongo(MongoClientURI mongoURI) {
        this(Mongo.createCluster(mongoURI), mongoURI.getOptions(), mongoURI.getCredentials() != null ? Arrays.asList(mongoURI.getCredentials()) : Collections.emptyList());
    }

    Mongo(Cluster cluster, MongoClientOptions options, List<MongoCredential> credentialsList) {
        this.cluster = cluster;
        this.options = options;
        this.readPreference = options.getReadPreference() != null ? options.getReadPreference() : ReadPreference.primary();
        this.writeConcern = options.getWriteConcern() != null ? options.getWriteConcern() : WriteConcern.UNACKNOWLEDGED;
        this.optionHolder = new Bytes.OptionHolder(null);
        this.credentialsList = Collections.unmodifiableList(credentialsList);
        this.cursorCleaningService = options.isCursorFinalizerEnabled() ? this.createCursorCleaningService() : null;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public List<ServerAddress> getAllAddress() {
        return this.getServerAddressList();
    }

    public List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        for (ServerDescription cur : this.getClusterDescription().getAll()) {
            serverAddresses.add(cur.getAddress());
        }
        return serverAddresses;
    }

    private ClusterDescription getClusterDescription() {
        return this.cluster.getDescription();
    }

    public ServerAddress getAddress() {
        ClusterDescription description = this.getClusterDescription();
        if (description.getPrimaries().isEmpty()) {
            return null;
        }
        return description.getPrimaries().get(0).getAddress();
    }

    @Deprecated
    public MongoOptions getMongoOptions() {
        return new MongoOptions(this.getMongoClientOptions());
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        ClusterDescription clusterDescription = this.getClusterDescription();
        return clusterDescription.getType() == ClusterType.REPLICA_SET && clusterDescription.getConnectionMode() == ClusterConnectionMode.MULTIPLE ? new ReplicaSetStatus(this.cluster) : null;
    }

    @Deprecated
    public List<String> getDatabaseNames() {
        return new OperationIterable<DBObject>(new ListDatabasesOperation<DBObject>(MongoClient.getCommandCodec()), ReadPreference.primary(), this.createOperationExecutor()).map(new Function<DBObject, String>(){

            @Override
            public String apply(DBObject result) {
                return (String)result.get("name");
            }
        }).into(new ArrayList());
    }

    @Deprecated
    public DB getDB(String dbName) {
        DB db = (DB)this.dbCache.get(dbName);
        if (db != null) {
            return db;
        }
        db = new DB(this, dbName, this.createOperationExecutor());
        DB temp = this.dbCache.putIfAbsent(dbName, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public Collection<DB> getUsedDatabases() {
        return this.dbCache.values();
    }

    public void dropDatabase(String dbName) {
        this.getDB(dbName).dropDatabase();
    }

    public void close() {
        this.cluster.close();
        if (this.cursorCleaningService != null) {
            this.cursorCleaningService.shutdownNow();
        }
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void setOptions(int options) {
        this.optionHolder.set(options);
    }

    public void resetOptions() {
        this.optionHolder.reset();
    }

    public void addOption(int option) {
        this.optionHolder.add(option);
    }

    public int getOptions() {
        return this.optionHolder.get();
    }

    public CommandResult fsync(boolean async) {
        BasicDBObject command = new BasicDBObject("fsync", (Object)1);
        if (async) {
            command.put("async", (Object)1);
        }
        return this.getDB(ADMIN_DATABASE_NAME).command(command);
    }

    public CommandResult fsyncAndLock() {
        BasicDBObject command = new BasicDBObject("fsync", (Object)1);
        command.put("lock", (Object)1);
        return this.getDB(ADMIN_DATABASE_NAME).command(command);
    }

    public DBObject unlock() {
        return this.getDB(ADMIN_DATABASE_NAME).getCollection("$cmd.sys.unlock").findOne();
    }

    public boolean isLocked() {
        DBCollection inprogCollection = this.getDB(ADMIN_DATABASE_NAME).getCollection("$cmd.sys.inprog");
        BasicDBObject result = (BasicDBObject)inprogCollection.findOne();
        return result.containsField("fsyncLock") && result.getInt("fsyncLock") == 1;
    }

    public String toString() {
        return "Mongo{options=" + this.getMongoClientOptions() + '}';
    }

    public int getMaxBsonObjectSize() {
        List<ServerDescription> primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? ServerDescription.getDefaultMaxDocumentSize() : primaries.get(0).getMaxDocumentSize();
    }

    public String getConnectPoint() {
        ServerAddress master = this.getAddress();
        return master != null ? String.format("%s:%d", master.getHost(), master.getPort()) : null;
    }

    private static MongoClientOptions createLegacyOptions() {
        return MongoClientOptions.builder().legacyDefaults().build();
    }

    private static Cluster createCluster(MongoClientURI mongoURI) {
        List<MongoCredential> credentialList;
        List<MongoCredential> list = credentialList = mongoURI.getCredentials() != null ? Arrays.asList(mongoURI.getCredentials()) : Collections.emptyList();
        if (mongoURI.getHosts().size() == 1) {
            return Mongo.createCluster(new ServerAddress(mongoURI.getHosts().get(0)), credentialList, mongoURI.getOptions());
        }
        ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>(mongoURI.getHosts().size());
        for (String host : mongoURI.getHosts()) {
            seedList.add(new ServerAddress(host));
        }
        return Mongo.createCluster(seedList, credentialList, mongoURI.getOptions());
    }

    private static Cluster createCluster(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options) {
        return Mongo.createCluster(ClusterSettings.builder().hosts(Mongo.createNewSeedList(seedList)).requiredReplicaSetName(options.getRequiredReplicaSetName()).serverSelectionTimeout(options.getServerSelectionTimeout(), TimeUnit.MILLISECONDS).serverSelector(Mongo.createServerSelector(options)).description(options.getDescription()).maxWaitQueueSize(options.getConnectionPoolSettings().getMaxWaitQueueSize()).build(), credentialsList, options);
    }

    private static Cluster createCluster(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options) {
        return Mongo.createCluster(ClusterSettings.builder().mode(Mongo.getSingleServerClusterMode(options)).hosts(Arrays.asList(serverAddress)).requiredReplicaSetName(options.getRequiredReplicaSetName()).serverSelectionTimeout(options.getServerSelectionTimeout(), TimeUnit.MILLISECONDS).serverSelector(Mongo.createServerSelector(options)).description(options.getDescription()).maxWaitQueueSize(options.getConnectionPoolSettings().getMaxWaitQueueSize()).build(), credentialsList, options);
    }

    private static Cluster createCluster(ClusterSettings settings, List<MongoCredential> credentialsList, MongoClientOptions options) {
        return new DefaultClusterFactory().create(settings, options.getServerSettings(), options.getConnectionPoolSettings(), new SocketStreamFactory(options.getSocketSettings(), options.getSslSettings(), options.getSocketFactory()), new SocketStreamFactory(options.getHeartbeatSocketSettings(), options.getSslSettings(), options.getSocketFactory()), credentialsList, null, new JMXConnectionPoolListener(), null, Mongo.createCommandListener(options.getCommandListeners()));
    }

    private static CommandListener createCommandListener(List<CommandListener> commandListeners) {
        switch (commandListeners.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return commandListeners.get(0);
            }
        }
        return new CommandListenerMulticaster(commandListeners);
    }

    private static List<ServerAddress> createNewSeedList(List<ServerAddress> seedList) {
        ArrayList<ServerAddress> retVal = new ArrayList<ServerAddress>(seedList.size());
        for (ServerAddress cur : seedList) {
            retVal.add(cur);
        }
        return retVal;
    }

    private static ServerSelector createServerSelector(MongoClientOptions options) {
        return new LatencyMinimizingServerSelector(options.getLocalThreshold(), TimeUnit.MILLISECONDS);
    }

    Cluster getCluster() {
        return this.cluster;
    }

    Bytes.OptionHolder getOptionHolder() {
        return this.optionHolder;
    }

    BufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    MongoClientOptions getMongoClientOptions() {
        return this.options;
    }

    List<MongoCredential> getCredentialsList() {
        return this.credentialsList;
    }

    WriteBinding getWriteBinding() {
        return this.getReadWriteBinding(ReadPreference.primary());
    }

    ReadBinding getReadBinding(ReadPreference readPreference) {
        return this.getReadWriteBinding(readPreference);
    }

    private ReadWriteBinding getReadWriteBinding(ReadPreference readPreference) {
        return new ClusterBinding(this.getCluster(), readPreference);
    }

    void addOrphanedCursor(ServerCursor serverCursor, MongoNamespace namespace) {
        this.orphanedCursors.add(new ServerCursorAndNamespace(serverCursor, namespace));
    }

    OperationExecutor createOperationExecutor() {
        return new OperationExecutor(){

            @Override
            public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference) {
                return Mongo.this.execute(operation, readPreference);
            }

            @Override
            public <T> T execute(WriteOperation<T> operation) {
                return Mongo.this.execute(operation);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(ReadOperation<T> operation, ReadPreference readPreference) {
        ReadBinding binding = this.getReadBinding(readPreference);
        try {
            T t = operation.execute(binding);
            return t;
        }
        finally {
            binding.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(WriteOperation<T> operation) {
        WriteBinding binding = this.getWriteBinding();
        try {
            T t = operation.execute(binding);
            return t;
        }
        finally {
            binding.release();
        }
    }

    private ExecutorService createCursorCleaningService() {
        ScheduledExecutorService newTimer = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
        newTimer.scheduleAtFixedRate(new Runnable(){

            public void run() {
                Mongo.this.cleanCursors();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        return newTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCursors() {
        ServerCursorAndNamespace cur;
        while ((cur = this.orphanedCursors.poll()) != null) {
            SingleServerBinding binding = new SingleServerBinding(this.cluster, cur.serverCursor.getAddress());
            try {
                ConnectionSource source = binding.getReadConnectionSource();
                try {
                    Connection connection = source.getConnection();
                    try {
                        connection.killCursor(cur.namespace, Collections.singletonList(cur.serverCursor.getId()));
                    }
                    finally {
                        connection.release();
                    }
                }
                finally {
                    source.release();
                }
            }
            finally {
                binding.release();
            }
        }
    }

    private static ClusterConnectionMode getSingleServerClusterMode(MongoClientOptions options) {
        if (options.getRequiredReplicaSetName() == null) {
            return ClusterConnectionMode.SINGLE;
        }
        return ClusterConnectionMode.MULTIPLE;
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";

        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    public static class Holder {
        private static final Holder INSTANCE = new Holder();
        private final ConcurrentMap<String, Mongo> clients = new ConcurrentHashMap<String, Mongo>();

        public static Holder singleton() {
            return INSTANCE;
        }

        @Deprecated
        public Mongo connect(MongoURI uri) {
            return this.connect(uri.toClientURI());
        }

        public Mongo connect(MongoClientURI uri) {
            String key = this.toKey(uri);
            Mongo client = (Mongo)this.clients.get(key);
            if (client == null) {
                MongoClient newbie = new MongoClient(uri);
                client = this.clients.putIfAbsent(key, newbie);
                if (client == null) {
                    client = newbie;
                } else {
                    newbie.close();
                }
            }
            return client;
        }

        private String toKey(MongoClientURI uri) {
            return uri.toString();
        }
    }

    private static class ServerCursorAndNamespace {
        private final ServerCursor serverCursor;
        private final MongoNamespace namespace;

        public ServerCursorAndNamespace(ServerCursor serverCursor, MongoNamespace namespace) {
            this.serverCursor = serverCursor;
            this.namespace = namespace;
        }
    }
}

