/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.operation.GroupOperation;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupCommand {
    private final String collectionName;
    private final DBObject keys;
    private final String keyf;
    private final DBObject condition;
    private final DBObject initial;
    private final String reduce;
    private final String finalize;

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, String finalize) {
        Assertions.notNull("collection", collection);
        this.collectionName = collection.getName();
        this.keys = keys;
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keyf = null;
    }

    public GroupCommand(DBCollection collection, String keyf, DBObject condition, DBObject initial, String reduce, String finalize) {
        Assertions.notNull("collection", collection);
        this.collectionName = collection.getName();
        this.keyf = Assertions.notNull("keyf", keyf);
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keys = null;
    }

    public DBObject toDBObject() {
        BasicDBObject args = new BasicDBObject("ns", this.collectionName).append("cond", this.condition).append("$reduce", this.reduce).append("initial", this.initial);
        if (this.keys != null) {
            args.put("key", this.keys);
        }
        if (this.keyf != null) {
            args.put("$keyf", this.keyf);
        }
        if (this.finalize != null) {
            args.put("finalize", this.finalize);
        }
        return new BasicDBObject("group", args);
    }

    GroupOperation<DBObject> toOperation(MongoNamespace namespace, DBObjectCodec codec) {
        if (this.initial == null) {
            throw new IllegalArgumentException("Group command requires an initial document for the aggregate result");
        }
        if (this.reduce == null) {
            throw new IllegalArgumentException("Group command requires a reduce function for the aggregate result");
        }
        GroupOperation<DBObject> operation = new GroupOperation<DBObject>(namespace, new BsonJavaScript(this.reduce), new BsonDocumentWrapper<DBObject>(this.initial, codec), codec);
        if (this.keys != null) {
            operation.key(new BsonDocumentWrapper<DBObject>(this.keys, codec));
        }
        if (this.keyf != null) {
            operation.keyFunction(new BsonJavaScript(this.keyf));
        }
        if (this.condition != null) {
            operation.filter(new BsonDocumentWrapper<DBObject>(this.condition, codec));
        }
        if (this.finalize != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalize));
        }
        return operation;
    }
}

