/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2pdf;

import com.dhtmlx.xml2pdf.PDFCell;
import com.dhtmlx.xml2pdf.PDFColumn;
import com.dhtmlx.xml2pdf.PDFRow;
import com.dhtmlx.xml2pdf.PDFXMLParser;
import com.dhtmlx.xml2pdf.RGBColor;
import com.pdfjet.Box;
import com.pdfjet.Font;
import com.pdfjet.Image;
import com.pdfjet.Line;
import com.pdfjet.PDF;
import com.pdfjet.Page;
import com.pdfjet.Point;
import com.pdfjet.TextLine;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class PDFWriter {
    private PDFXMLParser parser;
    private PDF pdf;
    private Page page;
    private ArrayList<Page> pages;
    private double[] widths;
    private double widthSum = 0.0;
    private double headerHeight = 0.0;
    private double pageWidth = 0.0;
    private double pageHeight = 0.0;
    public double offsetTop = 30.0;
    public double offsetBottom = 30.0;
    public double offsetLeft = 30.0;
    public double offsetRight = 30.0;
    public double lineHeight = 20.0;
    public double cellOffset = 3.0;
    public String pathToImgs = "";
    public double headerImgHeight = 100.0;
    public double footerImgHeight = 100.0;
    public double fontSize = 5.0;
    private String bgColor;
    private String lineColor;
    private String headerTextColor;
    private String scaleOneColor;
    private String scaleTwoColor;
    private String gridTextColor;
    private String pageTextColor;
    private String chBg1;
    private String chBg2;
    private String chBg3;
    private String chBg4;
    private String chMarker;
    private String raBg;
    private String watermarkTextColor;
    public double headerLineHeight = 30.0;
    public String pageNumTemplate = "\u9875 {pageNum}/{allNum}";
    public String watermark = null;
    private PDFColumn[][] cols = null;
    private Font f1 = null;
    private Font f2 = null;
    private Font f3 = null;
    private Font f4 = null;
    private boolean firstPage = false;
    private double footerHeight = 0.0;
    private int cols_stat;
    private int rows_stat;
    private String m_fontUri;
    private String m_fontName;

    public PDFWriter(String fontUriOrName) {
        if (fontUriOrName != null && fontUriOrName.length() > 0) {
            if (fontUriOrName.charAt(0) == '/') {
                this.m_fontUri = fontUriOrName;
            } else {
                this.m_fontName = fontUriOrName;
            }
        } else {
            this.m_fontName = "STHeitiSC-Light";
        }
    }

    public void generate(String xml, HttpServletResponse resp) {
        this.parser = new PDFXMLParser();
        try {
            this.parser.setXML(xml, resp);
            this.createPDF(resp);
            this.setColorProfile();
            this.headerPrint();
            this.printRows(resp);
            this.printFooter();
            this.printPageNumbers();
            this.outputPDF(resp);
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void createPDF(HttpServletResponse response) throws Exception {
        this.pdf = new PDF((OutputStream)response.getOutputStream());
        this.f1 = this.m_fontUri != null ? new Font(this.pdf, (InputStream)new BufferedInputStream(this.getClass().getResourceAsStream(this.m_fontUri)), -1, true) : new Font(this.pdf, this.m_fontName, -1);
        this.f1.setSize(this.fontSize);
        this.pages = new ArrayList();
        this.page = new Page(this.pdf, this.parser.getOrientation());
        this.pages.add(this.page);
        float[] sizes = this.parser.getOrientation();
        this.pageWidth = (double)sizes[0] - this.offsetLeft - this.offsetRight;
        this.pageHeight = (double)sizes[1] - this.offsetTop - this.offsetBottom;
        this.printHeader();
    }

    private void headerPrint() throws Exception {
        PDFColumn column;
        int j;
        int i;
        this.f1.setSize(this.fontSize);
        if (this.cols == null) {
            this.cols = this.parser.getHeaderInfo();
            this.widths = this.parser.getWidths();
            for (int i2 = 0; i2 < this.cols[0].length; ++i2) {
                this.widthSum += this.cols[0][i2].getWidth();
            }
        }
        this.cols_stat = this.cols.length;
        int bg = RGBColor.getColor(this.bgColor);
        int border = RGBColor.getColor(this.lineColor);
        double x = this.offsetLeft;
        double y = this.offsetTop;
        int lines = 0;
        for (i = 0; i < this.cols.length; ++i) {
            x = this.offsetLeft;
            if (this.cols[i][0].isFooter()) continue;
            for (j = 0; j < this.cols[i].length; ++j) {
                column = this.cols[i][j];
                x += this.printColumn(column, bg, border, x, y);
            }
            y += this.headerLineHeight;
            ++lines;
        }
        this.headerHeight = (double)lines * this.headerLineHeight;
        this.footerHeight = (double)(this.cols.length - lines) * this.headerLineHeight;
        y = this.pageHeight - this.headerHeight - this.footerHeight;
        y = Math.floor(y / this.lineHeight) * this.lineHeight + this.offsetTop + this.headerHeight;
        for (i = 0; i < this.cols.length; ++i) {
            if (!this.cols[i][0].isFooter()) continue;
            x = this.offsetLeft;
            for (j = 0; j < this.cols[i].length; ++j) {
                column = this.cols[i][j];
                x += this.printColumn(column, bg, border, x, y);
            }
            y += this.headerLineHeight;
        }
    }

    private double printColumn(PDFColumn column, int bg, int border, double x, double y) throws Exception {
        double width = column.getWidth() * this.pageWidth / this.widthSum;
        double height = (double)column.getHeight() * this.headerLineHeight;
        if (height > 0.0) {
            Box cell = new Box();
            cell.setPosition(x, y);
            cell.setSize(width, height);
            cell.setColor(border);
            Box cellIn = new Box();
            cellIn.setPosition(0.0f, 0.0f);
            cellIn.setSize(width, height);
            cellIn.placeIn(cell, 0.0f, 0.0f);
            cellIn.setFillShape(true);
            cellIn.setColor(bg);
            cellIn.drawOn(this.page);
            String label = this.textWrap(column.getName(), width - 2.0 * this.cellOffset, this.f1);
            TextLine text = new TextLine(this.f1, label);
            double text_x = (width - (double)this.f1.stringWidth(label)) / 2.0;
            double text_y = (height + (double)this.f1.getSize()) / 2.0;
            text.setPosition(text_x, text_y);
            text.placeIn(cellIn);
            text.setColor(RGBColor.getColor(this.headerTextColor));
            text.drawOn(this.page);
            cell.drawOn(this.page);
        }
        return width;
    }

    private void printRows(HttpServletResponse resp) throws Exception {
        PDFRow[] rows = this.parser.getGridContent(resp);
        this.rows_stat = rows.length;
        int border = RGBColor.getColor(this.lineColor);
        double y = this.offsetTop + this.headerHeight;
        for (int i = 0; i < rows.length; ++i) {
            double x = this.offsetLeft;
            PDFCell[] cells = rows[i].getCells();
            int rowColor = i % 2 == 0 ? RGBColor.getColor(this.scaleOneColor) : RGBColor.getColor(this.scaleTwoColor);
            for (int j = 0; j < cells.length; ++j) {
                double ch_x;
                Font cf;
                double width = this.widths[j] * this.pageWidth / this.widthSum;
                String al = cells[j].getAlign();
                if (al.equalsIgnoreCase("")) {
                    al = this.cols[0][j].getAlign();
                }
                String tp = this.cols[0][j].getType();
                Box cell = new Box();
                cell.setPosition(x, y);
                cell.setSize(width, this.lineHeight);
                cell.setColor(border);
                Box cellIn = new Box();
                cellIn.setPosition(0.0f, 0.0f);
                cellIn.setSize(width, this.lineHeight);
                cellIn.placeIn(cell, 0.0f, 0.0f);
                cellIn.setFillShape(true);
                cellIn.setColor(!cells[j].getBgColor().equals("") && this.parser.getProfile().equals("full_color") ? RGBColor.getColor(cells[j].getBgColor()) : rowColor);
                cellIn.drawOn(this.page);
                if (cells[j].getBold().booleanValue()) {
                    if (cells[j].getItalic().booleanValue()) {
                        if (this.f4 == null) {
                            this.f4 = this.m_fontUri != null ? new Font(this.pdf, (InputStream)new BufferedInputStream(this.getClass().getResourceAsStream(this.m_fontUri)), -1, true) : new Font(this.pdf, this.m_fontName, -1);
                            this.f4.setSize(this.fontSize);
                        }
                        cf = this.f4;
                    } else {
                        if (this.f2 == null) {
                            this.f2 = this.m_fontUri != null ? new Font(this.pdf, (InputStream)new BufferedInputStream(this.getClass().getResourceAsStream(this.m_fontUri)), -1, true) : new Font(this.pdf, this.m_fontName, -1);
                            this.f2.setSize(this.fontSize);
                        }
                        cf = this.f2;
                    }
                } else if (cells[j].getItalic().booleanValue()) {
                    if (this.f3 == null) {
                        this.f3 = this.m_fontUri != null ? new Font(this.pdf, (InputStream)new BufferedInputStream(this.getClass().getResourceAsStream(this.m_fontUri)), -1, true) : new Font(this.pdf, this.m_fontName, -1);
                        this.f3.setSize(this.fontSize);
                    }
                    cf = this.f3;
                } else {
                    cf = this.f1;
                }
                TextLine text = new TextLine(cf, this.textWrap(cells[j].getValue(), width - 2.0 * this.cellOffset, cf));
                double text_x = 0.0;
                text_x = al.equalsIgnoreCase("left") ? this.cellOffset : (al.equalsIgnoreCase("right") ? width - (double)cf.stringWidth(text.getText()) - this.cellOffset : (width - (double)cf.stringWidth(text.getText())) / 2.0);
                cell.drawOn(this.page);
                if (tp.equalsIgnoreCase("ch")) {
                    ch_x = width / 2.0;
                    double ch_y = this.lineHeight / 2.0;
                    if (text.getText().equalsIgnoreCase("1")) {
                        this.drawCheckbox(true, ch_x, ch_y, cellIn);
                    } else {
                        this.drawCheckbox(false, ch_x, ch_y, cellIn);
                    }
                } else if (tp.equalsIgnoreCase("ra")) {
                    ch_x = width / 2.0;
                    double ch_y = this.lineHeight / 2.0;
                    if (text.getText().equalsIgnoreCase("1")) {
                        this.drawRadio(true, ch_x, ch_y, cellIn);
                    } else {
                        this.drawRadio(false, ch_x, ch_y, cellIn);
                    }
                } else {
                    double text_y = (this.lineHeight + (double)this.f1.getSize()) / 2.0;
                    text.setPosition(text_x, text_y);
                    text.placeIn(cellIn);
                    int textColor = !cells[j].getTextColor().equals("") && this.parser.getProfile().equals("full_color") ? RGBColor.getColor(cells[j].getTextColor()) : RGBColor.getColor(this.gridTextColor);
                    text.setColor(textColor);
                    text.drawOn(this.page);
                }
                x += width;
            }
            if ((y += this.lineHeight) + this.lineHeight - this.offsetTop + this.footerHeight >= this.pageHeight) {
                this.page = new Page(this.pdf, this.parser.getOrientation());
                this.pages.add(this.page);
                if (this.firstPage) {
                    this.pageHeight += this.headerImgHeight;
                    this.offsetTop -= this.headerImgHeight;
                    this.firstPage = false;
                }
                this.headerPrint();
                y = this.offsetTop + this.headerHeight;
            }
            x = this.offsetLeft;
        }
        this.f1 = this.m_fontUri != null ? new Font(this.pdf, (InputStream)new BufferedInputStream(this.getClass().getResourceAsStream(this.m_fontUri)), -1, true) : new Font(this.pdf, this.m_fontName, -1);
        this.f1.setSize(this.fontSize);
    }

    private void printPageNumbers() throws Exception {
        Iterator<Page> itr = this.pages.iterator();
        int i = 1;
        while (itr.hasNext()) {
            Page page = itr.next();
            String str = this.pageNumTemplate;
            str = str.replace("{pageNum}", Integer.toString(i));
            str = str.replace("{allNum}", Integer.toString(this.pages.size()));
            TextLine text = new TextLine(this.f1, str);
            text.setColor(RGBColor.getColor(this.pageTextColor));
            double x = this.pageWidth + this.offsetLeft - (double)this.f1.stringWidth(str);
            double y = this.pageHeight + this.offsetTop + (double)this.f1.getSize();
            text.setPosition(x, y);
            text.drawOn(page);
            this.printWatermark(page);
            ++i;
        }
    }

    private void printWatermark(Page currentPage) throws Exception {
        TextLine text = new TextLine(this.f1, this.watermark);
        text.setColor(RGBColor.getColor(this.watermarkTextColor));
        double x = this.offsetLeft;
        double y = this.pageHeight + this.offsetTop + (double)this.f1.getSize();
        text.setPosition(x, y);
        text.drawOn(currentPage);
    }

    private void printHeader() throws Exception {
        Boolean header = this.parser.getHeader();
        if (header.booleanValue()) {
            String fileName = this.pathToImgs + "/header.jpg";
            FileInputStream fis = new FileInputStream(fileName);
            Image im = new Image(this.pdf, (InputStream)fis, 0);
            im.setPosition(this.offsetLeft, this.offsetTop);
            im.scaleBy(1.0f);
            im.drawOn(this.page);
            this.pageHeight -= this.headerImgHeight;
            this.offsetTop += this.headerImgHeight;
            this.firstPage = true;
        }
    }

    private void printFooter() throws Exception {
        Boolean footer = this.parser.getFooter();
        if (footer.booleanValue()) {
            String fileName = this.pathToImgs + "/footer.jpg";
            FileInputStream fis = new FileInputStream(fileName);
            Image im = new Image(this.pdf, (InputStream)fis, 0);
            im.setPosition(this.offsetLeft, this.pageHeight + this.offsetTop - this.footerImgHeight);
            im.scaleBy(1.0f);
            im.drawOn(this.page);
            this.pageHeight -= this.footerImgHeight;
            this.offsetTop += this.footerImgHeight;
            this.firstPage = true;
        }
    }

    private void outputPDF(HttpServletResponse resp) throws Throwable {
        resp.setContentType("application/x-msdownload");
        resp.setHeader("Content-Disposition", "attachment; filename=data.pdf");
        this.pdf.flush();
        this.pdf.close();
    }

    private String textWrap(String text, double width, Font f) {
        if ((double)f.stringWidth(text) <= width || text.length() == 0) {
            return text;
        }
        while (true) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!((double)f.stringWidth(stringBuilder.append(text).append("...").toString()) > width) || text.length() <= 0) break;
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }

    private void drawRadio(boolean value, double x, double y, Box cellIn) throws Exception {
        int bg1 = RGBColor.getColor(this.chMarker);
        Point r1 = new Point(x, y);
        r1.setRadius(3.5);
        r1.setColor(bg1);
        r1.setFillShape(true);
        r1.placeIn(cellIn, 0.0f, 0.0f);
        r1.drawOn(this.page);
        int bg2 = RGBColor.getColor(this.raBg);
        Point r2 = new Point(x, y);
        r2.setRadius(2.8);
        r2.setColor(bg2);
        r2.setFillShape(true);
        r2.placeIn(cellIn, 0.0f, 0.0f);
        r2.drawOn(this.page);
        if (value) {
            int bg3 = RGBColor.getColor(this.chMarker);
            Point r3 = new Point(x, y);
            r3.setRadius(1.5);
            r3.setColor(bg3);
            r3.setFillShape(true);
            r3.placeIn(cellIn, 0.0f, 0.0f);
            r3.drawOn(this.page);
        }
    }

    private void drawCheckbox(boolean value, double x, double y, Box cellIn) throws Exception {
        int bg1 = RGBColor.getColor(this.chBg1);
        Box b1 = new Box();
        b1.setSize(8.0f, 8.0f);
        b1.setPosition(x - 4.0, y - 4.0);
        b1.setColor(bg1);
        b1.setFillShape(true);
        b1.placeIn(cellIn, x - 4.0, y - 4.0);
        b1.drawOn(this.page);
        int bg2 = RGBColor.getColor(this.chBg2);
        Box b2 = new Box();
        b2.setSize(7.0f, 7.0f);
        b2.setPosition(1.0f, 1.0f);
        b2.setColor(bg2);
        b2.setFillShape(true);
        b2.placeIn(b1, 1.0f, 1.0f);
        b2.drawOn(this.page);
        int bg3 = RGBColor.getColor(this.chBg3);
        Box b3 = new Box();
        b3.setSize(6.0f, 6.0f);
        b3.setPosition(0.0f, 0.0f);
        b3.setColor(bg3);
        b3.setFillShape(true);
        b3.placeIn(b2, 0.0f, 0.0f);
        b3.drawOn(this.page);
        int bg4 = RGBColor.getColor(this.chBg4);
        Box b4 = new Box();
        b4.setSize(5.0f, 5.0f);
        b4.setPosition(1.0f, 1.0f);
        b4.setColor(bg4);
        b4.setFillShape(true);
        b4.placeIn(b3, 1.0f, 1.0f);
        b4.drawOn(this.page);
        if (value) {
            int lineColor = RGBColor.getColor(this.chMarker);
            Line l1 = new Line(0.5, 2.0, 2.0, 4.0);
            l1.setColor(lineColor);
            l1.placeIn(b4);
            l1.setWidth(1.0f);
            l1.drawOn(this.page);
            Line l2 = new Line(2.0, 4.5, 4.0, 1.0);
            l2.setColor(lineColor);
            l2.placeIn(b4);
            l2.setWidth(1.0f);
            l2.drawOn(this.page);
        }
    }

    private void setColorProfile() {
        String profile = this.parser.getProfile();
        if (profile.equalsIgnoreCase("color") || profile.equalsIgnoreCase("full_color")) {
            this.bgColor = "D1E5FE";
            this.lineColor = "A4BED4";
            this.headerTextColor = "000000";
            this.scaleOneColor = "FFFFFF";
            this.scaleTwoColor = "E3EFFF";
            this.gridTextColor = "000000";
            this.pageTextColor = "000000";
            this.chBg1 = "1d76e4";
            this.chBg2 = "a8caf5";
            this.chBg3 = "0e3b72";
            this.chBg4 = "ffffff";
            this.chMarker = "245684";
            this.raBg = "fcfefc";
            this.watermarkTextColor = "8b8b8b";
        } else if (profile.equalsIgnoreCase("gray")) {
            this.bgColor = "E3E3E3";
            this.lineColor = "B8B8B8";
            this.headerTextColor = "000000";
            this.scaleOneColor = "FFFFFF";
            this.scaleTwoColor = "EDEDED";
            this.gridTextColor = "000000";
            this.pageTextColor = "000000";
            this.chBg1 = "676767";
            this.chBg2 = "c4c4c4";
            this.chBg3 = "333333";
            this.chBg4 = "ffffff";
            this.chMarker = "222222";
            this.raBg = "fcfefc";
            this.watermarkTextColor = "8b8b8b";
        } else {
            this.bgColor = "FFFFFF";
            this.lineColor = "000000";
            this.headerTextColor = "000000";
            this.scaleOneColor = "FFFFFF";
            this.scaleTwoColor = "FFFFFF";
            this.gridTextColor = "000000";
            this.pageTextColor = "000000";
            this.chBg1 = "000000";
            this.chBg2 = "000000";
            this.chBg3 = "ffffff";
            this.chBg4 = "ffffff";
            this.chMarker = "000000";
            this.raBg = "ffffff";
            this.watermarkTextColor = "000000";
        }
    }

    public int getColsStat() {
        return this.cols_stat;
    }

    public int getRowsStat() {
        return this.rows_stat;
    }

    public void setWatermark(String mark) {
        this.watermark = mark;
    }

    public void setFontSize(Double fontsize) {
        this.fontSize = fontsize;
    }

    public void setFontSize(int fontsize) {
        this.fontSize = fontsize;
    }
}

