/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2excel;

import com.dhtmlx.xml2excel.ExcelColumn;
import com.dhtmlx.xml2excel.ExcelRow;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExcelXmlParser {
    private Element root;
    private ExcelRow[] rows;
    private int[] widths;
    private Boolean header = false;
    private Boolean footer = false;
    private Boolean without_header = false;
    private String profile = "gray";

    public void setXML(String xml) throws IOException, DOMException, ParserConfigurationException, SAXException {
        String w_header;
        String profile_text;
        String footer_text;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = null;
        try {
            dom = db.parse(new InputSource(new StringReader(xml)));
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.root = dom.getDocumentElement();
        String header_text = this.root.getAttribute("header");
        if (header_text != null && header_text.equalsIgnoreCase("true")) {
            this.header = true;
        }
        if ((footer_text = this.root.getAttribute("footer")) != null && footer_text.equalsIgnoreCase("true")) {
            this.footer = true;
        }
        if ((profile_text = this.root.getAttribute("profile")) != null) {
            this.profile = profile_text;
        }
        if ((w_header = this.root.getAttribute("without_header")) != null && w_header.equalsIgnoreCase("true")) {
            this.without_header = true;
        }
    }

    public ExcelColumn[][] getColumnsInfo(String mode) {
        ExcelColumn[][] columns;
        block6: {
            ExcelColumn[] colLine = null;
            columns = null;
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            try {
                String path = "/rows/".concat(mode).concat("/columns");
                NodeList n1 = (NodeList)xpath.evaluate(path, this.root, XPathConstants.NODESET);
                if (n1 != null && n1.getLength() > 0) {
                    columns = new ExcelColumn[n1.getLength()][];
                    for (int i = 0; i < n1.getLength(); ++i) {
                        Element cols = (Element)n1.item(i);
                        NodeList n2 = cols.getElementsByTagName("column");
                        if (n2 != null && n2.getLength() > 0) {
                            colLine = new ExcelColumn[n2.getLength()];
                            for (int j = 0; j < n2.getLength(); ++j) {
                                Element col_xml = (Element)n2.item(j);
                                ExcelColumn col = new ExcelColumn();
                                col.parse(col_xml);
                                colLine[j] = col;
                            }
                        }
                        columns[i] = colLine;
                    }
                    break block6;
                }
                return null;
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
        this.createWidthsArray(columns);
        columns = this.optimizeColumns(columns);
        return columns;
    }

    private void createWidthsArray(ExcelColumn[][] columns) {
        this.widths = new int[columns[0].length];
        for (int i = 0; i < columns[0].length; ++i) {
            this.widths[i] = columns[0][i].getWidth();
        }
    }

    private ExcelColumn[][] optimizeColumns(ExcelColumn[][] columns) {
        int j;
        int i;
        for (i = 1; i < columns.length; ++i) {
            for (j = 0; j < columns[i].length; ++j) {
                columns[i][j].setWidth(columns[0][j].getWidth());
            }
        }
        for (i = 0; i < columns.length; ++i) {
            for (j = 0; j < columns[i].length; ++j) {
                int k;
                if (columns[i][j].getColspan() > 0) {
                    for (k = j + 1; k < j + columns[i][j].getColspan(); ++k) {
                        columns[i][j].setWidth(columns[i][j].getWidth() + columns[i][k].getWidth());
                        columns[i][k].setWidth(0);
                    }
                }
                if (columns[i][j].getRowspan() <= 0) continue;
                for (k = i + 1; k < i + columns[i][j].getRowspan(); ++k) {
                    columns[i][j].setHeight(columns[i][j].getHeight() + 1);
                    columns[k][j].setHeight(0);
                }
            }
        }
        return columns;
    }

    public ExcelRow[] getGridContent() {
        NodeList nodes = this.root.getElementsByTagName("row");
        if (nodes != null && nodes.getLength() > 0) {
            this.rows = new ExcelRow[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.rows[i] = new ExcelRow();
                this.rows[i].parse(nodes.item(i));
            }
        }
        return this.rows;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public boolean getHeader() {
        return this.header;
    }

    public Boolean getFooter() {
        return this.footer;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean getWithoutHeader() {
        return this.without_header;
    }
}

