/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.Filter;
import chrriis.common.UIUtils;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.ClipLayout;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import chrriis.dj.nativeswing.NativeSwing;
import com.sun.jna.examples.WindowUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

class NativeComponentProxyPanel
extends NativeComponentProxy {
    private static final boolean IS_DEBUGGING_SHAPE = Boolean.parseBoolean(NSSystemProperty.COMPONENTS_DEBUG_PRINTSHAPECOMPUTING.get());
    private boolean isProxiedFiliation;
    private AWTEventListener shapeAdjustmentEventListener;
    private boolean isDestructionOnFinalization;
    private boolean isVisibilityConstrained;
    private HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        public void ancestorMoved(HierarchyEvent e) {
            Component component = e.getChanged();
            if (component instanceof Window) {
                return;
            }
            NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
        }

        public void ancestorResized(HierarchyEvent e) {
            NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            this.adjustFocus();
        }

        protected void adjustFocus() {
            Container parent = NativeComponentProxyPanel.this;
            while (parent != null && !(parent instanceof Window)) {
                if (parent instanceof JInternalFrame) {
                    Window windowAncestor = SwingUtilities.getWindowAncestor(NativeComponentProxyPanel.this);
                    if (windowAncestor == null) break;
                    boolean focusableWindowState = windowAncestor.getFocusableWindowState();
                    windowAncestor.setFocusableWindowState(false);
                    try {
                        ((JInternalFrame)parent).setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    windowAncestor.setFocusableWindowState(focusableWindowState);
                    break;
                }
                parent = parent.getParent();
            }
        }
    };
    private volatile boolean isInvoking;
    private Rectangle[] lastArea = new Rectangle[]{new Rectangle(this.getSize())};
    private EmbeddedPanel embeddedPanel;
    private HierarchyListener hierarchyListener;

    NativeComponentProxyPanel(NativeComponentWrapper nativeComponentWrapper, boolean isVisibilityConstrained, boolean isDestructionOnFinalization, boolean isProxiedFiliation) {
        super(nativeComponentWrapper);
        this.isDestructionOnFinalization = isDestructionOnFinalization;
        this.isVisibilityConstrained = isVisibilityConstrained;
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if ((changeFlags & 4L) != 0L) {
                    if (NativeComponentProxyPanel.this.isVisibilityConstrained) {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelShape();
                    } else {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
                    }
                }
            }
        };
        if (isVisibilityConstrained) {
            this.shapeAdjustmentEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent e) {
                    boolean isAdjustingShape = false;
                    switch (e.getID()) {
                        case 100: 
                        case 101: 
                        case 300: 
                        case 301: {
                            isAdjustingShape = true;
                            break;
                        }
                        case 102: 
                        case 103: {
                            if (!(e.getSource() instanceof Window)) break;
                            isAdjustingShape = true;
                        }
                    }
                    if (isAdjustingShape && NativeComponentProxyPanel.this.nativeComponentWrapper.getNativeComponentProxy() == NativeComponentProxyPanel.this) {
                        NativeComponentProxyPanel.this.adjustEmbeddedPanelShape();
                    }
                }
            };
        }
        this.isProxiedFiliation = isProxiedFiliation;
    }

    private void adjustEmbeddedPanelBounds() {
        Container parent;
        boolean isShowing;
        if (this.embeddedPanel == null) {
            return;
        }
        if (!this.isVisibilityConstrained && (isShowing = this.isShowing()) != this.embeddedPanel.isVisible()) {
            this.embeddedPanel.setVisible(isShowing);
        }
        if ((parent = this.embeddedPanel.getParent()) != null) {
            Point location = SwingUtilities.convertPoint(this, new Point(0, 0), parent);
            Dimension size = this.getSize();
            Rectangle bounds = new Rectangle(location.x, location.y, size.width, size.height);
            Rectangle clip = this.embeddedPanel.getRectangularClip();
            if (clip != null) {
                bounds.x += clip.x;
                bounds.y += clip.y;
                bounds.width = clip.width;
                bounds.height = clip.height;
            }
            if (!this.embeddedPanel.getBounds().equals(bounds)) {
                this.embeddedPanel.setBounds(bounds);
                this.embeddedPanel.invalidate();
                this.embeddedPanel.validate();
                this.embeddedPanel.repaint();
                if (this.isVisibilityConstrained) {
                    this.adjustEmbeddedPanelShape();
                }
            }
        }
    }

    private void adjustEmbeddedPanelShape() {
        if (this.isInvoking) {
            return;
        }
        this.isInvoking = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxyPanel.this.isInvoking = false;
                NativeComponentProxyPanel.this.adjustEmbeddedPanelShape_();
            }
        });
    }

    private void adjustEmbeddedPanelShape_() {
        if (this.embeddedPanel == null) {
            return;
        }
        Object[] rectangles = this.computePeerShapeArea();
        if (Arrays.equals(this.lastArea, rectangles)) {
            this.embeddedPanel.nativeComponentWrapper.getNativeComponent().repaint();
            return;
        }
        this.lastArea = rectangles;
        if (rectangles.length == 0) {
            this.embeddedPanel.setVisible(false);
        } else {
            if (!this.embeddedPanel.isVisible()) {
                this.embeddedPanel.setVisible(true);
            }
            this.embeddedPanel.applyShape((Rectangle[])rectangles);
        }
    }

    private Rectangle[] computePeerShapeArea() {
        if (IS_DEBUGGING_SHAPE) {
            System.err.println("Computing shape: [" + this.getWidth() + "x" + this.getHeight() + "] " + this.nativeComponentWrapper.getComponentDescription());
        }
        Rectangle[] shape = UIUtils.getComponentVisibleArea(this, new Filter<Component>(){

            @Override
            public Filter.Acceptance accept(Component c) {
                Rectangle intersectionRectangle;
                if (c instanceof EmbeddedPanel) {
                    return Filter.Acceptance.NO;
                }
                UIUtils.TransparencyType transparency = UIUtils.getComponentTransparency(c);
                switch (transparency) {
                    case TRANSPARENT_WITH_OPAQUE_CHILDREN: {
                        return Filter.Acceptance.TEST_CHILDREN;
                    }
                    case NOT_VISIBLE: {
                        return Filter.Acceptance.NO;
                    }
                }
                if (IS_DEBUGGING_SHAPE && !(intersectionRectangle = SwingUtilities.convertRectangle(c, new Rectangle(c.getSize()), NativeComponentProxyPanel.this).intersection(new Rectangle(NativeComponentProxyPanel.this.getSize()))).isEmpty()) {
                    System.err.println("  -> Subtracting [" + intersectionRectangle.x + "," + intersectionRectangle.y + "," + intersectionRectangle.width + "x" + intersectionRectangle.height + "] " + c);
                }
                return Filter.Acceptance.YES;
            }
        });
        return shape;
    }

    public void paint(Graphics g) {
        super.paint(g);
        NativeComponentWrapper[] nativeComponentWrapperArray = NativeSwing.getNativeComponentWrappers();
        int n = nativeComponentWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeComponentWrapper ncw = nativeComponentWrapperArray[n2];
            NativeComponentProxy nativeComponentProxy = ncw.getNativeComponentProxy();
            if (nativeComponentProxy instanceof NativeComponentProxyPanel && ((NativeComponentProxyPanel)nativeComponentProxy).isVisibilityConstrained) {
                ((NativeComponentProxyPanel)nativeComponentProxy).adjustEmbeddedPanelShape();
            }
            ++n2;
        }
    }

    public void reshape(int x, int y, int w, int h) {
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.reshape(x, y, w, h);
        this.adjustEmbeddedPanelBounds();
    }

    public void addNotify() {
        boolean isEmbeddedPanelCreated;
        super.addNotify();
        if (this.hierarchyListener != null) {
            this.addHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.shapeAdjustmentEventListener, 3L);
        }
        JLayeredPane layeredPane = null;
        if (this.isProxiedFiliation) {
            layeredPane = NativeComponentProxyPanel.findLayeredPane(this);
        }
        boolean bl = isEmbeddedPanelCreated = this.embeddedPanel != null;
        if (isEmbeddedPanelCreated) {
            if (this.isProxiedFiliation) {
                JLayeredPane oldLayeredPane;
                if (this.embeddedPanel.getParent() == null) {
                    layeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                    layeredPane.add(this.embeddedPanel);
                    layeredPane.invalidate();
                    layeredPane.validate();
                }
                if (layeredPane != (oldLayeredPane = NativeComponentProxyPanel.findLayeredPane(this.embeddedPanel))) {
                    this.embeddedPanel.isCrossWindowReparenting = true;
                    this.nativeComponentWrapper.storeInHiddenParent();
                    Container oldParent = this.embeddedPanel.getParent();
                    oldParent.remove(this.embeddedPanel);
                    UIUtils.revalidate(oldParent);
                    oldParent.repaint();
                    layeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                    layeredPane.add(this.embeddedPanel);
                    this.nativeComponentWrapper.restoreFromHiddenParent();
                    this.embeddedPanel.isCrossWindowReparenting = false;
                    UIUtils.revalidate(layeredPane);
                    layeredPane.repaint();
                    this.revalidate();
                    this.repaint();
                }
            }
        } else {
            this.embeddedPanel = new EmbeddedPanel(this.nativeComponentWrapper, this.isDestructionOnFinalization);
            this.embeddedPanel.add(this.nativeComponentWrapper.getNativeComponent(), "Center");
        }
        this.lastArea = null;
        this.adjustEmbeddedPanelBounds();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxyPanel.this.addHierarchyBoundsListener(NativeComponentProxyPanel.this.hierarchyBoundsListener);
                NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
            }
        });
        this.nativeComponentWrapper.getNativeComponent().addMouseListener(this.mouseListener);
        if (!isEmbeddedPanelCreated) {
            if (this.isProxiedFiliation) {
                layeredPane.setLayer(this.embeddedPanel, Integer.MIN_VALUE);
                layeredPane.add(this.embeddedPanel);
                UIUtils.revalidate(layeredPane);
                layeredPane.repaint();
            } else {
                this.add(this.embeddedPanel);
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.hierarchyListener != null) {
            this.removeHierarchyListener(this.hierarchyListener);
        }
        if (this.shapeAdjustmentEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.shapeAdjustmentEventListener);
        }
        if (this.isDestructionOnFinalization) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NativeComponentProxyPanel.this.removeHierarchyBoundsListener(NativeComponentProxyPanel.this.hierarchyBoundsListener);
                    NativeComponentProxyPanel.this.adjustEmbeddedPanelBounds();
                }
            });
            this.nativeComponentWrapper.getNativeComponent().removeMouseListener(this.mouseListener);
            if (this.isVisibilityConstrained) {
                this.adjustEmbeddedPanelShape();
            } else {
                this.adjustEmbeddedPanelBounds();
            }
            return;
        }
        this.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.embeddedPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NativeComponentProxyPanel.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        if (this.embeddedPanel == null) {
            return;
        }
        EmbeddedPanel panel = this.embeddedPanel;
        this.embeddedPanel = null;
        Container parent = panel.getParent();
        if (parent != null) {
            panel.isRemovingFromParent = true;
            parent.remove(panel);
            parent.invalidate();
            parent.validate();
            parent.repaint();
        }
    }

    public Dimension getPreferredSize() {
        if (this.embeddedPanel != null) {
            return this.embeddedPanel.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    private static class EmbeddedPanel
    extends Panel
    implements NativeComponentWrapper.NativeComponentHolder {
        private NativeComponentWrapper nativeComponentWrapper;
        private boolean isDestructionOnFinalization;
        private boolean isCrossWindowReparenting;
        private boolean isHiddenReparenting;
        private boolean isRemovingFromParent;
        private Rectangle clip;
        private static final boolean RESTRICT_SHAPE_TO_SINGLE_RECTANGLE = Boolean.parseBoolean(NSSystemProperty.COMPONENTS_FORCESINGLERECTANGLESHAPES.get());

        public EmbeddedPanel(NativeComponentWrapper nativeComponentWrapper, boolean isDestructionOnFinalization) {
            super(new ClipLayout());
            this.nativeComponentWrapper = nativeComponentWrapper;
            this.isDestructionOnFinalization = isDestructionOnFinalization;
            this.enableEvents(131072L);
        }

        public boolean contains(int x, int y) {
            return false;
        }

        public boolean contains(Point p) {
            return false;
        }

        public void removeNotify() {
            if (this.isRemovingFromParent) {
                super.removeNotify();
                return;
            }
            if (this.isDestructionOnFinalization && !this.isCrossWindowReparenting) {
                try {
                    this.nativeComponentWrapper.storeInHiddenParent();
                    this.isHiddenReparenting = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.removeNotify();
                this.isRemovingFromParent = true;
                Container parent = this.getParent();
                if (parent != null) {
                    parent.remove(this);
                    parent.invalidate();
                    parent.validate();
                }
                this.isRemovingFromParent = false;
            } else {
                super.removeNotify();
            }
        }

        public void addNotify() {
            super.addNotify();
            if (this.isHiddenReparenting) {
                this.isHiddenReparenting = false;
                this.nativeComponentWrapper.restoreFromHiddenParent();
            }
        }

        protected void finalize() throws Throwable {
            if (this.isHiddenReparenting) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EmbeddedPanel.this.nativeComponentWrapper.restoreFromHiddenParent();
                        EmbeddedPanel.this.nativeComponentWrapper.getNativeComponent().removeNotify();
                    }
                });
            }
        }

        public void applyShape(Rectangle[] rectangles) {
            Container parent;
            Rectangle clip;
            if (!Utils.IS_MAC && !RESTRICT_SHAPE_TO_SINGLE_RECTANGLE) {
                WindowUtils.setComponentMask((Component)this, (Rectangle[])rectangles);
                this.nativeComponentWrapper.getNativeComponent().repaint();
                return;
            }
            if (rectangles.length == 0) {
                clip = null;
            } else {
                clip = new Rectangle(rectangles[0]);
                if (rectangles.length > 1) {
                    System.err.println("Non-rectangular clip detected on a system that does not support this feature.");
                    int i = 1;
                    while (i < rectangles.length) {
                        clip = clip.union(rectangles[i]);
                        ++i;
                    }
                }
            }
            if (Utils.equals(this.clip, clip)) {
                return;
            }
            int oldOffsetX = this.clip == null ? 0 : this.clip.x;
            int oldOffsetY = this.clip == null ? 0 : this.clip.y;
            this.clip = clip;
            int offsetX = clip == null ? 0 : clip.x;
            int offsetY = clip == null ? 0 : clip.y;
            NativeComponentProxy nativeComponentProxy = this.nativeComponentWrapper.getNativeComponentProxy();
            if (nativeComponentProxy != null) {
                ((ClipLayout)this.getLayout()).setClip(clip == null ? null : new Rectangle(-clip.x, -clip.y, nativeComponentProxy.getWidth(), nativeComponentProxy.getHeight()));
            }
            if ((parent = this.getParent()) != null) {
                LayoutManager layout = parent.getLayout();
                if (layout instanceof ClipLayout) {
                    ((ClipLayout)layout).setClip(clip);
                } else {
                    int diffX = offsetX - oldOffsetX;
                    int diffY = offsetY - oldOffsetY;
                    this.setBounds(this.getX() + diffX, this.getY() + diffY, this.getWidth() - diffX, this.getHeight() - diffY);
                }
                this.doLayout();
                UIUtils.revalidate(parent);
            }
        }

        public Rectangle getRectangularClip() {
            return this.clip;
        }
    }
}

