/*
 * Decompiled with CFR 0.152.
 */
package com.hymane.expandtextview;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hymane.expandtextview.OnReadMoreClickListener;
import com.hymane.expandtextview.R;
import com.hymane.expandtextview.utils.DensityUtils;

public class ExpandTextView
extends LinearLayout
implements View.OnClickListener {
    public static final String TAG = "ExpandTextView";
    public static final int DEFAULT_TITLE_TEXT_COLOR = -1979711488;
    public static final int DEFAULT_CONTENT_TEXT_COLOR = -570425344;
    public static final int DEFAULT_HINT_TEXT_COLOR = -570425344;
    public static final int DEFAULT_MIN_LINES = 4;
    public static final int DEFAULT_TITLE_TEXT_SIZE = 16;
    public static final int DEFAULT_CONTENT_TEXT_SIZE = 14;
    public static final int DEFAULT_HINT_TEXT_SIZE = 12;
    public static final int DEFAULT_ANIMATION_DURATION = 600;
    private Context mContext;
    private String title;
    private String content;
    private String foldHint;
    private String expandHint;
    private int titleTextColor;
    private int contentTextColor;
    private int hintTextColor;
    private Drawable indicateImage;
    private int minVisibleLines;
    private float titleTextSize;
    private float contentTextSize;
    private float hintTextSize;
    private int animationDuration;
    private TextView mTitleView;
    private TextView mContentView;
    private TextView mHintView;
    private ImageView mIndicateImage;
    private RelativeLayout mShowMore;
    private TextView copy;
    private OnReadMoreClickListener mListener;
    private boolean flag;

    public ExpandTextView(Context context) {
        this(context, null);
    }

    public ExpandTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setOrientation(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExpandTextView);
        this.title = a.getString(R.styleable.ExpandTextView_titleText);
        this.content = a.getString(R.styleable.ExpandTextView_contentText);
        this.foldHint = a.getString(R.styleable.ExpandTextView_foldHint);
        this.expandHint = a.getString(R.styleable.ExpandTextView_expandHint);
        this.titleTextColor = a.getColor(R.styleable.ExpandTextView_textTitleColor, -1979711488);
        this.contentTextColor = a.getColor(R.styleable.ExpandTextView_textContentColor, -570425344);
        this.hintTextColor = a.getColor(R.styleable.ExpandTextView_textHintColor, -570425344);
        this.indicateImage = a.getDrawable(R.styleable.ExpandTextView_indicateImage);
        this.minVisibleLines = a.getInt(R.styleable.ExpandTextView_minVisibleLines, 4);
        this.titleTextSize = a.getDimension(R.styleable.ExpandTextView_titleTextSize, (float)DensityUtils.sp2px(this.mContext, 16.0f));
        this.contentTextSize = a.getDimension(R.styleable.ExpandTextView_contentTextSize, (float)DensityUtils.sp2px(this.mContext, 14.0f));
        this.hintTextSize = a.getDimension(R.styleable.ExpandTextView_hintTextSize, (float)DensityUtils.sp2px(this.mContext, 12.0f));
        this.animationDuration = a.getInt(R.styleable.ExpandTextView_animationDuration, 600);
        a.recycle();
        this.init();
    }

    private void init() {
        View.inflate((Context)this.mContext, (int)R.layout.expand_text_view, (ViewGroup)this);
        this.mTitleView = (TextView)this.findViewById(R.id.tv_title);
        this.mContentView = (TextView)this.findViewById(R.id.tv_content);
        this.mHintView = (TextView)this.findViewById(R.id.tv_more_hint);
        this.mIndicateImage = (ImageView)this.findViewById(R.id.iv_arrow_more);
        this.mShowMore = (RelativeLayout)this.findViewById(R.id.rl_show_more);
        this.mTitleView.setText((CharSequence)this.title);
        this.mTitleView.setTextSize(0, this.titleTextSize);
        this.mTitleView.setTextColor(this.titleTextColor);
        this.mContentView.setText((CharSequence)this.content);
        this.mContentView.setTextSize(0, this.contentTextSize);
        this.mContentView.setTextColor(this.contentTextColor);
        this.mHintView.setText((CharSequence)this.expandHint);
        this.mHintView.setTextSize(0, this.hintTextSize);
        this.mHintView.setTextColor(this.hintTextColor);
        if (this.indicateImage == null) {
            this.indicateImage = this.getResources().getDrawable(R.drawable.ic_arrow_down_light_round);
        }
        this.mIndicateImage.setImageDrawable(this.indicateImage);
        this.mShowMore.setOnClickListener((View.OnClickListener)this);
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        layoutParams.height = this.getMinMeasureHeight();
        this.mContentView.setLayoutParams(layoutParams);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.mTitleView.setText((CharSequence)title);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.mContentView.setText((CharSequence)content);
    }

    public String getFoldHint() {
        return this.foldHint;
    }

    public void setFoldHint(String foldHint) {
        this.foldHint = foldHint;
    }

    public String getExpandHint() {
        return this.expandHint;
    }

    public void setExpandHint(String expandHint) {
        this.expandHint = expandHint;
    }

    public int getTitleTextColor() {
        return this.titleTextColor;
    }

    public void setTitleTextColor(@ColorInt int titleTextColor) {
        this.titleTextColor = titleTextColor;
        this.mTitleView.setTextColor(titleTextColor);
    }

    public int getContentTextColor() {
        return this.contentTextColor;
    }

    public void setContentTextColor(@ColorInt int contentTextColor) {
        this.contentTextColor = contentTextColor;
        this.mContentView.setTextColor(contentTextColor);
    }

    public int getHintTextColor() {
        return this.hintTextColor;
    }

    public void setHintTextColor(@ColorInt int hintTextColor) {
        this.hintTextColor = hintTextColor;
        this.mHintView.setTextColor(hintTextColor);
    }

    public Drawable getIndicateImage() {
        return this.indicateImage;
    }

    public void setIndicateImage(@DrawableRes Drawable indicateImage) {
        this.indicateImage = indicateImage;
        this.mIndicateImage.setImageDrawable(indicateImage);
    }

    public void setIndicateImage(@DrawableRes int indicateImageRes) {
        this.indicateImage = this.getResources().getDrawable(indicateImageRes);
        this.mIndicateImage.setImageDrawable(this.indicateImage);
    }

    public int getMinVisibleLines() {
        return this.minVisibleLines;
    }

    public void setMinVisibleLines(int minVisibleLines) {
        this.minVisibleLines = minVisibleLines;
        this.copy = null;
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        layoutParams.height = this.getMinMeasureHeight();
        this.mContentView.setLayoutParams(layoutParams);
    }

    public float getTitleTextSize() {
        return this.titleTextSize;
    }

    public void setTitleTextSize(float titleTextSize) {
        this.titleTextSize = DensityUtils.sp2px(this.mContext, titleTextSize);
        this.mTitleView.setTextSize(titleTextSize);
    }

    public float getContentTextSize() {
        return this.contentTextSize;
    }

    public void setContentTextSize(float contentTextSize) {
        this.contentTextSize = DensityUtils.sp2px(this.mContext, contentTextSize);
        this.mContentView.setTextSize(contentTextSize);
        this.copy = null;
        ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        layoutParams.height = this.getMinMeasureHeight();
        this.mContentView.setLayoutParams(layoutParams);
    }

    public float getHintTextSize() {
        return this.hintTextSize;
    }

    public void setHintTextSize(float hintTextSize) {
        this.hintTextSize = DensityUtils.sp2px(this.mContext, hintTextSize);
        this.mHintView.setTextSize(hintTextSize);
    }

    public View getTitleView() {
        return this.mTitleView;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
    }

    public OnReadMoreClickListener getReadMoreListener() {
        return this.mListener;
    }

    public void setOnReadMoreListener(OnReadMoreClickListener mListener) {
        this.mListener = mListener;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.rl_show_more) {
            this.expand();
        }
    }

    public int getMaxMeasureHeight() {
        int width = this.mContentView.getMeasuredWidth();
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)3000, (int)Integer.MIN_VALUE);
        this.mContentView.measure(widthMeasureSpec, heightMeasureSpec);
        return this.mContentView.getMeasuredHeight();
    }

    public int getMinMeasureHeight() {
        if (this.copy == null) {
            this.copy = new TextView(this.mContext);
            this.copy.setTextSize(0, this.contentTextSize);
            this.copy.setLineSpacing((float)DensityUtils.dp2px(this.mContext, 6.0f), 1.0f);
            this.copy.setLines(this.minVisibleLines);
        }
        int width = this.mContentView.getMeasuredWidth();
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)1000, (int)Integer.MIN_VALUE);
        this.copy.measure(widthMeasureSpec, heightMeasureSpec);
        return this.copy.getMeasuredHeight();
    }

    private void expand() {
        int targetHeight;
        int startHeight;
        if (!this.flag) {
            this.flag = true;
            startHeight = this.getMinMeasureHeight();
            targetHeight = this.getMaxMeasureHeight();
            if (targetHeight < startHeight) {
                targetHeight = startHeight;
            }
            this.mHintView.setText((CharSequence)this.foldHint);
            ObjectAnimator.ofFloat((Object)this.mIndicateImage, (String)"rotation", (float[])new float[]{0.0f, 180.0f}).start();
            if (this.mListener != null) {
                this.mListener.onExpand();
            }
        } else {
            this.flag = false;
            startHeight = this.getMaxMeasureHeight();
            if (startHeight < (targetHeight = this.getMinMeasureHeight())) {
                startHeight = targetHeight;
            }
            this.mHintView.setText((CharSequence)this.expandHint);
            ObjectAnimator.ofFloat((Object)this.mIndicateImage, (String)"rotation", (float[])new float[]{-180.0f, 0.0f}).start();
            if (this.mListener != null) {
                this.mListener.onFold();
            }
        }
        if (this.animationDuration < 0) {
            this.animationDuration = 600;
        }
        final ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{startHeight, targetHeight});
        animator.setDuration((long)this.animationDuration);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                layoutParams.height = (Integer)animation.getAnimatedValue();
                ExpandTextView.this.mContentView.setLayoutParams(layoutParams);
            }
        });
        animator.start();
    }
}

