/*
 * Decompiled with CFR 0.152.
 */
package com.hxh.component.ui.alertview;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.hxh.component.ui.alertview.AlertAnimateUtil;
import com.hxh.component.ui.alertview.AlertViewAdapter;
import com.hxh.component.ui.alertview.OnDismissListener;
import com.hxh.component.ui.alertview.OnItemClickListener;
import com.hxh.component.ui.alertview.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AlertView {
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    public static final int HORIZONTAL_BUTTONS_MAXCOUNT = 2;
    public static final int CANCELPOSITION = -1;
    public static final int CONFIRMPOSITION = 0;
    private String title;
    private String msg;
    private String confirmTitle;
    private String cancelTitle;
    private int cancelColor;
    private int confirmColor;
    private String[] others;
    private List<String> mOthers;
    private ArrayList<String> mDatas = new ArrayList();
    private WeakReference<Context> contextWeak;
    private ViewGroup contentContainer;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private ViewGroup loAlertHeader;
    private Style style = Style.Alert;
    private OnDismissListener onDismissListener;
    private ArrayList<OnItemClickListener> OnItemClickListenerTest;
    private boolean isShowing;
    private Animation outAnim;
    private Animation inAnim;
    private int gravity = 17;
    private int mOtherColor;
    private int[] mOtherColors;
    private Animation.AnimationListener outAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            AlertView.this.dismissImmediately();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                AlertView.this.dismiss();
            }
            return false;
        }
    };

    public AlertView(Builder builder) {
        this.contextWeak = new WeakReference<Context>(builder.context);
        if (builder.contentView != null) {
            this.initData(builder.context, builder.contentView);
        } else {
            this.initData(builder.title, builder.msgContent, builder.cancelTitle, builder.cancelColor, builder.confirmTitle, builder.confirmColor, builder.others, builder.style, builder.OnItemClickListenerTest);
            this.mOtherColor = builder.othersColor;
            this.mOtherColors = builder.othersColors;
        }
        this.initViews();
        this.init();
    }

    public AlertView(Context context, String title, String msg, String cancel, int cancelColor, String confirm, int confirmColor, String[] others, Style style, OnItemClickListener OnItemClickListenerTest) {
        this.contextWeak = new WeakReference<Context>(context);
        this.OnItemClickListenerTest = new ArrayList();
        this.OnItemClickListenerTest.add(OnItemClickListenerTest);
        this.initData(title, msg, cancel, cancelColor, this.confirmTitle, confirmColor, others, style, this.OnItemClickListenerTest);
        this.initViews();
        this.init();
    }

    public AlertView(View view) {
        this.contextWeak = new WeakReference<Context>(view.getContext());
        this.initData((Context)this.contextWeak.get(), view);
        this.init();
    }

    protected void initData(Context context, View contentView) {
        if (context == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.decorView = (ViewGroup)((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_alertview, this.decorView, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
        int margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_alert_left_right);
        this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, margin_alert_left_right);
        this.params.gravity = 17;
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
        this.contentContainer.addView(contentView);
    }

    protected void initData(String title, String msg, String cancel, int cancelColor, String confirm, int confirmColor, String[] others, Style style, ArrayList<OnItemClickListener> OnItemClickListenerTest) {
        this.OnItemClickListenerTest = OnItemClickListenerTest;
        this.title = title;
        this.msg = msg;
        if (style != null) {
            this.style = style;
        }
        this.cancelTitle = cancel;
        this.confirmTitle = confirm;
        this.cancelColor = cancelColor;
        this.confirmColor = confirmColor;
        this.others = others;
        if (cancel != null) {
            this.others = null;
            if (style == Style.Alert && this.mDatas.size() < 2) {
                this.mDatas.add(0, cancel);
            }
        }
        if (confirm != null) {
            this.others = null;
            if (style == Style.Alert && this.mDatas.size() < 2) {
                if (this.mDatas.size() == 0) {
                    this.mDatas.add(0, confirm);
                } else {
                    this.mDatas.add(1, confirm);
                }
            }
        }
        if (this.style == Style.ActionSheet && others != null) {
            this.mOthers = Arrays.asList(others);
            this.mDatas.addAll(this.mOthers);
        }
    }

    protected void initViews() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.decorView = (ViewGroup)((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_alertview, this.decorView, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
        int margin_alert_left_right = 0;
        if (null == this.confirmTitle && null == this.cancelTitle) {
            this.setCancelable(true);
        }
        switch (this.style) {
            case ActionSheet: {
                this.params.gravity = 80;
                margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_actionsheet_left_right);
                this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, margin_alert_left_right);
                this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
                this.gravity = 80;
                this.initActionSheetViews(layoutInflater);
                break;
            }
            case Alert: {
                this.params.gravity = 17;
                margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_alert_left_right);
                this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, 0);
                this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
                this.gravity = 17;
                this.initAlertViews(layoutInflater);
            }
        }
    }

    protected void initHeaderView(ViewGroup viewGroup) {
        this.loAlertHeader = (ViewGroup)viewGroup.findViewById(R.id.loAlertHeader);
        TextView tvAlertTitle = (TextView)viewGroup.findViewById(R.id.tvAlertTitle);
        TextView tvAlertMsg = (TextView)viewGroup.findViewById(R.id.tvAlertMsg);
        if (this.title != null) {
            tvAlertTitle.setText((CharSequence)this.title);
        } else {
            tvAlertTitle.setVisibility(8);
            tvAlertMsg.setPadding(0, 53, 0, 0);
        }
        if (this.msg != null) {
            tvAlertMsg.setText((CharSequence)this.msg);
        } else {
            tvAlertMsg.setVisibility(8);
        }
    }

    protected void initListView() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        ListView alertButtonListView = (ListView)this.contentContainer.findViewById(R.id.alertButtonListView);
        if (this.cancelTitle != null && this.style == Style.Alert) {
            View itemView = LayoutInflater.from((Context)context).inflate(R.layout.item_alertbutton, null);
            TextView tvAlert = (TextView)itemView.findViewById(R.id.tvAlert);
            tvAlert.setText((CharSequence)this.cancelTitle);
            tvAlert.setClickable(true);
            tvAlert.setTypeface(Typeface.DEFAULT_BOLD);
            tvAlert.setTextColor(this.cancelColor);
            tvAlert.setBackgroundResource(R.drawable.bg_alertbutton_bottom);
            tvAlert.setOnClickListener((View.OnClickListener)new OnTextClickListener(this.cancelTitle, -1));
            alertButtonListView.addFooterView(itemView);
        }
        if (null != this.mOthers) {
            AlertViewAdapter adapter = null;
            adapter = null == this.mOtherColors ? new AlertViewAdapter(this.mDatas, this.mOthers, this.mOtherColor) : new AlertViewAdapter(this.mDatas, this.mOthers, this.mOtherColors);
            alertButtonListView.setAdapter((ListAdapter)adapter);
            alertButtonListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                    if (AlertView.this.OnItemClickListenerTest != null) {
                        for (OnItemClickListener onItemClickListener : AlertView.this.OnItemClickListenerTest) {
                            onItemClickListener.onItemClick((String)AlertView.this.mOthers.get(position), position);
                        }
                    }
                    AlertView.this.dismiss();
                }
            });
        }
    }

    protected void initActionSheetViews(LayoutInflater layoutInflater) {
        ViewGroup viewGroup = (ViewGroup)layoutInflater.inflate(R.layout.layout_alertview_actionsheet, this.contentContainer);
        this.initHeaderView(viewGroup);
        this.initListView();
        TextView tvAlertCancel = (TextView)this.contentContainer.findViewById(R.id.tvAlertCancel);
        if (this.cancelTitle != null) {
            tvAlertCancel.setVisibility(0);
            tvAlertCancel.setText((CharSequence)this.cancelTitle);
        }
        tvAlertCancel.setOnClickListener((View.OnClickListener)new OnTextClickListener(this.cancelTitle, -1));
    }

    protected void initAlertViews(LayoutInflater layoutInflater) {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)layoutInflater.inflate(R.layout.layout_alertview_alert, this.contentContainer);
        this.initHeaderView(viewGroup);
        if (this.mDatas.size() <= 2) {
            ViewStub viewStub = (ViewStub)this.contentContainer.findViewById(R.id.viewStubHorizontal);
            viewStub.inflate();
            LinearLayout loAlertButtons = (LinearLayout)this.contentContainer.findViewById(R.id.loAlertButtons);
            for (int i = 0; i < this.mDatas.size(); ++i) {
                if (i != 0) {
                    View divier = new View(context);
                    divier.setBackgroundColor(context.getResources().getColor(R.color.bgColor_divier));
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.size_divier), -1);
                    loAlertButtons.addView(divier, (ViewGroup.LayoutParams)params);
                }
                View itemView = LayoutInflater.from((Context)context).inflate(R.layout.item_alertbutton, null);
                TextView tvAlert = (TextView)itemView.findViewById(R.id.tvAlert);
                tvAlert.setClickable(true);
                String data = this.mDatas.get(i);
                tvAlert.setText((CharSequence)data);
                if (i == 0) {
                    tvAlert.setBackgroundResource(R.drawable.bg_alertbutton_left);
                } else if (i == 1) {
                    tvAlert.setBackgroundResource(R.drawable.bg_alertbutton_right);
                }
                if (data.equals(this.cancelTitle)) {
                    tvAlert.setTextColor(this.cancelColor);
                    tvAlert.setOnClickListener((View.OnClickListener)new OnTextClickListener(this.cancelTitle, -1));
                }
                if (data.equals(this.confirmTitle)) {
                    tvAlert.setTextColor(this.confirmColor);
                    tvAlert.setOnClickListener((View.OnClickListener)new OnTextClickListener(this.confirmTitle, 0));
                }
                loAlertButtons.addView(itemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
            }
        } else {
            ViewStub viewStub = (ViewStub)this.contentContainer.findViewById(R.id.viewStubVertical);
            viewStub.inflate();
            this.initListView();
        }
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    public AlertView addExtView(View extView) {
        this.loAlertHeader.addView(extView);
        return this;
    }

    private void onAttached(View view) {
        this.isShowing = true;
        this.decorView.addView(view);
        this.contentContainer.startAnimation(this.inAnim);
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.onAttached((View)this.rootView);
    }

    public boolean isShowing() {
        return this.rootView.getParent() != null && this.isShowing;
    }

    public void dismiss() {
        this.outAnim.setAnimationListener(this.outAnimListener);
        this.contentContainer.startAnimation(this.outAnim);
    }

    public void dismissImmediately() {
        this.decorView.removeView((View)this.rootView);
        this.isShowing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this);
        }
    }

    public void addOnItemClickListener(OnItemClickListener lis) {
        if (null != this.OnItemClickListenerTest) {
            this.OnItemClickListenerTest.add(lis);
        }
    }

    public Animation getInAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = AlertAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public Animation getOutAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = AlertAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public AlertView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    public void setMarginBottom(int marginBottom) {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        int margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_alert_left_right);
        this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, marginBottom);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public AlertView setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
        return this;
    }

    public static class Builder {
        private Context context;
        private Style style;
        private String title;
        private String msgContent;
        private String cancelTitle;
        private String confirmTitle;
        private int cancelColor = -1234;
        private int confirmColor = -1234;
        private String[] others;
        private int[] othersColors;
        private int othersColor = -1234;
        private View contentView;
        private ArrayList<OnItemClickListener> OnItemClickListenerTest;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setStyle(Style style) {
            if (style != null) {
                this.style = style;
            }
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMessage(String msg) {
            this.msgContent = msg;
            return this;
        }

        public Builder setCancelText(String cancel) {
            this.others = null;
            this.cancelTitle = cancel;
            return this;
        }

        public Builder setConfirmText(String confirmTitle) {
            this.others = null;
            this.confirmTitle = confirmTitle;
            return this;
        }

        public Builder setCancelTextColor(int cancelcolor) {
            this.cancelColor = cancelcolor;
            return this;
        }

        public Builder seConfirmTextColor(int confirmcolor) {
            this.confirmColor = confirmcolor;
            return this;
        }

        public Builder setOthers(String[] others) {
            this.others = others;
            return this;
        }

        public Builder setOthersColor(int color2) {
            this.othersColor = color2;
            this.othersColors = null;
            return this;
        }

        public Builder setOthersColor(int[] color2) {
            this.othersColor = -1234;
            this.othersColors = color2;
            return this;
        }

        public Builder setView(View contentView) {
            this.contentView = contentView;
            return this;
        }

        public Builder setOnItemClickListenerTest(OnItemClickListener OnItemClickListenerTest) {
            return this.addOnItemClickListenerTest(OnItemClickListenerTest);
        }

        public Builder addOnItemClickListenerTest(OnItemClickListener lis) {
            if (null == this.OnItemClickListenerTest) {
                this.OnItemClickListenerTest = new ArrayList();
            }
            this.OnItemClickListenerTest.add(lis);
            return this;
        }

        public AlertView build() {
            if (-1234 == this.cancelColor) {
                this.cancelColor = Color.parseColor((String)"#666666");
            }
            if (-1234 == this.confirmColor) {
                this.confirmColor = Color.parseColor((String)"#4996FE");
            }
            if (-1234 == this.othersColor && null == this.othersColors) {
                this.othersColor = Color.parseColor((String)"#333333");
            }
            return new AlertView(this);
        }
    }

    class OnTextClickListener
    implements View.OnClickListener {
        private int position;
        private String title;

        public OnTextClickListener(String title, int position) {
            this.title = title;
            this.position = position;
        }

        public void onClick(View view) {
            if (AlertView.this.OnItemClickListenerTest != null) {
                for (OnItemClickListener onItemClickListener : AlertView.this.OnItemClickListenerTest) {
                    onItemClickListener.onItemClick(this.title, this.position);
                }
            }
            AlertView.this.dismiss();
        }
    }

    public static enum Style {
        ActionSheet,
        Alert;

    }
}

