/*
 * Decompiled with CFR 0.152.
 */
package com.hxc.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;

public class Dimen {
    public static int getDpi(Context context) {
        int screenHeight = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, displayMetrics);
            screenHeight = displayMetrics.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return screenHeight;
    }

    public static int getStatusHeight(Context context) {
        int statusHeight = -1;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            statusHeight = context.getResources().getDimensionPixelSize(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusHeight;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    public static int getTitleHeight(Activity activity) {
        return activity.getWindow().findViewById(0x1020002).getTop();
    }

    public static int getBottomStatusHeight(Context context) {
        int totalHeight = Dimen.getDpi(context);
        int contentHeight = Dimen.getScreenHeight(context);
        return totalHeight - contentHeight;
    }
}

