/*
 * Decompiled with CFR 0.152.
 */
package com.hunorkovacs.koauthsync.service;

import com.hunorkovacs.koauthsync.domain.KoauthRequest;
import com.hunorkovacs.koauthsync.domain.OauthParams$;
import com.hunorkovacs.koauthsync.domain.ResponseOk;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;

public final class Arithmetics$ {
    public static final Arithmetics$ MODULE$;
    private final String UTF8;
    private final String HmacSha1Algorithm;
    private final Charset UTF8Charset;
    private final Base64.Encoder Base64Encoder;
    private final String FirstSlash;

    static {
        new Arithmetics$();
    }

    public final String UTF8() {
        return "UTF-8";
    }

    private String HmacSha1Algorithm() {
        return this.HmacSha1Algorithm;
    }

    private Charset UTF8Charset() {
        return this.UTF8Charset;
    }

    private Base64.Encoder Base64Encoder() {
        return this.Base64Encoder;
    }

    private String FirstSlash() {
        return this.FirstSlash;
    }

    public String urlDecode(String s) {
        return URLDecoder.decode(s, "UTF-8");
    }

    public String urlEncode(String s) {
        return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\*", "%2A").replaceAll("%7E", "~");
    }

    public String createAuthorizationHeader(List<Tuple2<String, String>> oauthParamsList) {
        return new StringBuilder().append((Object)"OAuth ").append((Object)((TraversableOnce)((SeqLike)oauthParamsList.map((Function1)new Serializable(){

            public final String apply(Tuple2<String, String> p) {
                String k = Arithmetics$.MODULE$.urlEncode((String)p._1());
                String v = Arithmetics$.MODULE$.urlEncode((String)p._2());
                return new StringBuilder().append((Object)k).append((Object)"=\"").append((Object)v).append((Object)"\"").toString();
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString();
    }

    public String concatItemsForSignature(KoauthRequest request) {
        String method = this.urlEncode(request.method());
        String url = this.urlEncode(this.toLowerCase(request.urlWithoutParams()));
        String params = this.urlEncode(this.normalizeRequestParams(request.urlParams(), request.oauthParamsList(), request.bodyParams()));
        return this.concat((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{method, url, params})));
    }

    public String normalizeRequestParams(List<Tuple2<String, String>> urlParams, List<Tuple2<String, String>> oauthParamsList, List<Tuple2<String, String>> bodyParams) {
        List filtered = (List)oauthParamsList.filterNot((Function1)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<String, String> kv) {
                Object object = kv._1();
                String string = OauthParams$.MODULE$.RealmName();
                if (object == null) {
                    if (string == null) return true;
                } else if (object.equals(string)) return true;
                Object object2 = kv._1();
                String string2 = OauthParams$.MODULE$.SignatureName();
                if (object2 != null) {
                    if (!object2.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        });
        List<Tuple2<String, String>> list = urlParams;
        List list2 = filtered;
        return this.pairSortConcat((List<Tuple2<String, String>>)bodyParams.$colon$colon$colon(list2).$colon$colon$colon(list));
    }

    public String toLowerCase(String url) {
        String[] parts = url.split(this.FirstSlash(), 2);
        return parts.length > 1 ? new StringBuilder().append((Object)parts[0].toLowerCase()).append((Object)"/").append((Object)parts[1]).toString() : parts[0].toLowerCase();
    }

    public String encodePairSortConcat(List<Tuple2<String, String>> keyValueList) {
        return this.concat((List<String>)((List)((SeqLike)keyValueList.map((Function1)new Serializable(){

            public final String apply(Tuple2<String, String> keyValue) {
                Tuple2<String, String> tuple2 = keyValue;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)key, (Object)value);
                    String key2 = (String)tuple23._1();
                    String value2 = (String)tuple23._2();
                    return new StringBuilder().append((Object)Arithmetics$.MODULE$.urlEncode(key2)).append((Object)"=").append((Object)Arithmetics$.MODULE$.urlEncode(value2)).toString();
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)));
    }

    public String pairSortConcat(List<Tuple2<String, String>> keyValueList) {
        return this.concat((List<String>)((List)((SeqLike)keyValueList.map((Function1)new Serializable(){

            public final String apply(Tuple2<String, String> keyValue) {
                Tuple2<String, String> tuple2 = keyValue;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)key, (Object)value);
                    String key2 = (String)tuple23._1();
                    String value2 = (String)tuple23._2();
                    return new StringBuilder().append((Object)key2).append((Object)"=").append((Object)value2).toString();
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)));
    }

    public String encodeConcat(List<String> itemList) {
        return this.concat((List<String>)((List)itemList.map((Function1)new Serializable(){

            public final String apply(String s) {
                return Arithmetics$.MODULE$.urlEncode(s);
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public String concat(List<String> itemList) {
        return itemList.mkString("&");
    }

    public ResponseOk createRequestTokenResponse(String token, String secret, String callback) {
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)OauthParams$.MODULE$.TokenName(), (Object)token), new Tuple2((Object)OauthParams$.MODULE$.TokenSecretName(), (Object)secret), new Tuple2((Object)OauthParams$.MODULE$.CallbackConfirmedName(), (Object)callback)}));
        return new ResponseOk(this.encodePairSortConcat((List<Tuple2<String, String>>)list));
    }

    public ResponseOk createAccesTokenResponse(String token, String secret) {
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)OauthParams$.MODULE$.TokenName(), (Object)token), new Tuple2((Object)OauthParams$.MODULE$.TokenSecretName(), (Object)secret)}));
        return new ResponseOk(this.encodePairSortConcat((List<Tuple2<String, String>>)list));
    }

    public String sign(String base, String consumerSecret, String tokenSecret) {
        String key = this.encodeConcat((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{consumerSecret, tokenSecret})));
        SecretKeySpec secretkeySpec = new SecretKeySpec(key.getBytes(this.UTF8Charset()), this.HmacSha1Algorithm());
        Mac mac = Mac.getInstance(this.HmacSha1Algorithm());
        mac.init(secretkeySpec);
        byte[] bytesToSign = base.getBytes(this.UTF8Charset());
        byte[] digest = mac.doFinal(bytesToSign);
        byte[] digest64 = this.Base64Encoder().encode(digest);
        return new String(digest64, this.UTF8Charset());
    }

    private Arithmetics$() {
        MODULE$ = this;
        this.HmacSha1Algorithm = "HmacSHA1";
        this.UTF8Charset = Charset.forName("UTF-8");
        this.Base64Encoder = Base64.getEncoder();
        this.FirstSlash = "(?<!/)/(?!/)";
    }
}

