/*
 * Decompiled with CFR 0.152.
 */
package com.hulab.gummy.listeners;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;

public abstract class PullClickListener
implements View.OnTouchListener {
    private View mView = null;
    private float mInitialPosition;
    private float mStartPoint;
    private float dY;
    private boolean mTriggerPull = false;
    private float mFactor = 0.6f;
    private int mAmplitude = 100;
    private int mAnimationDuration = 100;
    private int mTriggerAt = 100;
    private int mPullThreshold = 0;
    private GestureDetectorCompat gestureDetector;
    private Interpolator mInterpolator = new AccelerateInterpolator();

    protected abstract void onPull();

    protected abstract void onClick();

    public PullClickListener setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public PullClickListener setResistance(float factor) {
        this.mFactor = 1.0f - factor;
        return this;
    }

    public PullClickListener setAmplitude(int px) {
        this.mAmplitude = px;
        return this;
    }

    public PullClickListener setPullThreshold(int px) {
        this.mPullThreshold = px;
        return this;
    }

    public PullClickListener setAnimationDuration(int duration) {
        this.mAnimationDuration = duration;
        return this;
    }

    public PullClickListener setTriggerAt(int triggerAt) {
        this.mTriggerAt = triggerAt;
        return this;
    }

    public PullClickListener(Context context) {
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                PullClickListener.this.onClick();
                return super.onSingleTapUp(e);
            }
        });
        this.mTriggerAt = this.mAmplitude;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mView == null) {
            this.mView = v;
            this.mInitialPosition = v.getY();
        }
        if (!this.gestureDetector.onTouchEvent(event)) {
            switch (event.getAction()) {
                case 0: {
                    this.mInitialPosition = this.mView.getY();
                    this.mStartPoint = event.getRawY();
                    this.dY = this.mInitialPosition;
                    break;
                }
                case 2: {
                    this.dY = (event.getRawY() - this.mStartPoint) * this.mFactor;
                    boolean bl = this.mTriggerPull = this.dY >= (float)this.mTriggerAt;
                    if (this.dY <= 0.0f || this.dY < (float)this.mPullThreshold || !(this.dY <= (float)this.mAmplitude)) break;
                    v.setY(this.mInitialPosition - (float)this.mPullThreshold + this.dY);
                    break;
                }
                case 1: {
                    if (this.mTriggerPull) {
                        this.onPull();
                        this.mTriggerPull = false;
                    }
                    ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mView.getY(), this.mInitialPosition});
                    valueAnimator.setDuration((long)this.mAnimationDuration);
                    valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float value = ((Float)animation.getAnimatedValue()).floatValue();
                            PullClickListener.this.mView.setY(value);
                            PullClickListener.this.mView.requestLayout();
                        }
                    });
                    valueAnimator.start();
                    valueAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
                    return false;
                }
            }
        }
        return true;
    }
}

