/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.response.views.StateActionValue;
import java.io.IOException;
import java.time.LocalDate;

public class StateActionValueDeserializer
extends StdDeserializer<StateActionValue> {
    private static final String DATE_FIELD = "selected_date";

    protected StateActionValueDeserializer() {
        super(StateActionValue.class);
    }

    public StateActionValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
        StateActionValue.Builder builder = StateActionValue.builder();
        ObjectCodec codec = p.getCodec();
        JsonNode node = (JsonNode)codec.readTree(p);
        if (node.has("type")) {
            builder.setBlockElementType(node.get("type").asText());
        }
        if (node.has("value")) {
            builder.setBlockElementValue(node.get("value").asText());
        } else if (node.has("selected_option")) {
            JsonNode selectedOption = node.get("selected_option");
            Option option = (Option)codec.treeToValue((TreeNode)selectedOption, Option.class);
            if (option != null) {
                builder.setBlockElementValue(option);
            }
        } else if (node.has(DATE_FIELD)) {
            builder.setBlockElementValue(LocalDate.parse(node.get(DATE_FIELD).asText()));
        }
        return builder.build();
    }
}

