/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.objects.Text;
import com.hubspot.slack.client.models.response.views.ModalViewResponseIF;
import com.hubspot.slack.client.models.response.views.StateBlock;
import com.hubspot.slack.client.models.response.views.ViewResponseBase;
import com.hubspot.slack.client.models.response.views.json.StateBlockDeserializer;
import com.hubspot.slack.client.models.response.views.json.StateBlockSerializer;
import com.hubspot.slack.client.models.views.ModalViewPayloadBase;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ModalViewResponse
implements ModalViewResponseIF {
    private final String type;
    private final Text title;
    @Nullable
    private final Text closeButtonText;
    @Nullable
    private final Text submitButtonText;
    @Nullable
    private final Boolean clearOnClose;
    @Nullable
    private final Boolean notifyOnClose;
    private final List<Block> blocks;
    @Nullable
    private final String privateMetadata;
    @Nullable
    private final String callbackId;
    @Nullable
    private final String externalId;
    private final String appId;
    private final String botId;
    private final String currentViewId;
    private final String rootViewId;
    private final String teamId;
    private final StateBlock stateValues;
    private final String hash;
    @Nullable
    private final String previousViewId;

    private ModalViewResponse(Text title, @Nullable Text closeButtonText, @Nullable Text submitButtonText, @Nullable Boolean clearOnClose, @Nullable Boolean notifyOnClose, List<Block> blocks, @Nullable String privateMetadata, @Nullable String callbackId, @Nullable String externalId, String appId, String botId, String currentViewId, String rootViewId, String teamId, StateBlock stateValues, String hash, @Nullable String previousViewId) {
        this.title = title;
        this.closeButtonText = closeButtonText;
        this.submitButtonText = submitButtonText;
        this.clearOnClose = clearOnClose;
        this.notifyOnClose = notifyOnClose;
        this.blocks = blocks;
        this.privateMetadata = privateMetadata;
        this.callbackId = callbackId;
        this.externalId = externalId;
        this.appId = appId;
        this.botId = botId;
        this.currentViewId = currentViewId;
        this.rootViewId = rootViewId;
        this.teamId = teamId;
        this.stateValues = stateValues;
        this.hash = hash;
        this.previousViewId = previousViewId;
        this.type = Objects.requireNonNull(ModalViewResponseIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="close")
    public Optional<Text> getCloseButtonText() {
        return Optional.ofNullable(this.closeButtonText);
    }

    @Override
    @JsonProperty(value="submit")
    public Optional<Text> getSubmitButtonText() {
        return Optional.ofNullable(this.submitButtonText);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getClearOnClose() {
        return Optional.ofNullable(this.clearOnClose);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getNotifyOnClose() {
        return Optional.ofNullable(this.notifyOnClose);
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty
    public Optional<String> getPrivateMetadata() {
        return Optional.ofNullable(this.privateMetadata);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public String getAppId() {
        return this.appId;
    }

    @Override
    @JsonProperty
    public String getBotId() {
        return this.botId;
    }

    @Override
    @JsonProperty(value="id")
    public String getCurrentViewId() {
        return this.currentViewId;
    }

    @Override
    @JsonProperty
    public String getRootViewId() {
        return this.rootViewId;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty(value="state")
    @JsonDeserialize(using=StateBlockDeserializer.class)
    @JsonSerialize(using=StateBlockSerializer.class)
    public StateBlock getStateValues() {
        return this.stateValues;
    }

    @Override
    @JsonProperty
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty
    public Optional<String> getPreviousViewId() {
        return Optional.ofNullable(this.previousViewId);
    }

    public final ModalViewResponse withTitle(Text title) {
        if (this.title == title) {
            return this;
        }
        Text newValue = Objects.requireNonNull(title, "title");
        return new ModalViewResponse(newValue, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withCloseButtonText(@Nullable Text value) {
        Text newValue = value;
        if (this.closeButtonText == newValue) {
            return this;
        }
        return new ModalViewResponse(this.title, newValue, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withCloseButtonText(Optional<Text> optional) {
        Text value = optional.orElse(null);
        if (this.closeButtonText == value) {
            return this;
        }
        return new ModalViewResponse(this.title, value, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withSubmitButtonText(@Nullable Text value) {
        Text newValue = value;
        if (this.submitButtonText == newValue) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, newValue, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withSubmitButtonText(Optional<Text> optional) {
        Text value = optional.orElse(null);
        if (this.submitButtonText == value) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, value, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withClearOnClose(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.clearOnClose, newValue)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, newValue, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withClearOnClose(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.clearOnClose, value)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, value, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withNotifyOnClose(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.notifyOnClose, newValue)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, newValue, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withNotifyOnClose(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.notifyOnClose, value)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, value, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withBlocks(Block ... elements) {
        List<Block> newValue = ModalViewResponse.createUnmodifiableList(false, ModalViewResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, newValue, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ModalViewResponse.createUnmodifiableList(false, ModalViewResponse.createSafeList(elements, true, false));
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, newValue, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withPrivateMetadata(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.privateMetadata, newValue)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, newValue, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withPrivateMetadata(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateMetadata, value)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, value, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, newValue, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, value, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, newValue, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, value, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withAppId(String appId) {
        if (this.appId.equals(appId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(appId, "appId");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, newValue, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withBotId(String botId) {
        if (this.botId.equals(botId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(botId, "botId");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, newValue, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withCurrentViewId(String currentViewId) {
        if (this.currentViewId.equals(currentViewId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(currentViewId, "currentViewId");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, newValue, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withRootViewId(String rootViewId) {
        if (this.rootViewId.equals(rootViewId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(rootViewId, "rootViewId");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, newValue, this.teamId, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withTeamId(String teamId) {
        if (this.teamId.equals(teamId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(teamId, "teamId");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, newValue, this.stateValues, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withStateValues(StateBlock stateValues) {
        if (this.stateValues == stateValues) {
            return this;
        }
        StateBlock newValue = Objects.requireNonNull(stateValues, "stateValues");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, newValue, this.hash, this.previousViewId);
    }

    public final ModalViewResponse withHash(String hash) {
        if (this.hash.equals(hash)) {
            return this;
        }
        String newValue = Objects.requireNonNull(hash, "hash");
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, newValue, this.previousViewId);
    }

    public final ModalViewResponse withPreviousViewId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.previousViewId, newValue)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, newValue);
    }

    public final ModalViewResponse withPreviousViewId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.previousViewId, value)) {
            return this;
        }
        return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ModalViewResponse && this.equalTo((ModalViewResponse)another);
    }

    private boolean equalTo(ModalViewResponse another) {
        return this.type.equals(another.type) && this.title.equals(another.title) && Objects.equals(this.closeButtonText, another.closeButtonText) && Objects.equals(this.submitButtonText, another.submitButtonText) && Objects.equals(this.clearOnClose, another.clearOnClose) && Objects.equals(this.notifyOnClose, another.notifyOnClose) && this.blocks.equals(another.blocks) && Objects.equals(this.privateMetadata, another.privateMetadata) && Objects.equals(this.callbackId, another.callbackId) && Objects.equals(this.externalId, another.externalId) && this.appId.equals(another.appId) && this.botId.equals(another.botId) && this.currentViewId.equals(another.currentViewId) && this.rootViewId.equals(another.rootViewId) && this.teamId.equals(another.teamId) && this.stateValues.equals(another.stateValues) && this.hash.equals(another.hash) && Objects.equals(this.previousViewId, another.previousViewId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + Objects.hashCode(this.closeButtonText);
        h = h * 17 + Objects.hashCode(this.submitButtonText);
        h = h * 17 + Objects.hashCode(this.clearOnClose);
        h = h * 17 + Objects.hashCode(this.notifyOnClose);
        h = h * 17 + this.blocks.hashCode();
        h = h * 17 + Objects.hashCode(this.privateMetadata);
        h = h * 17 + Objects.hashCode(this.callbackId);
        h = h * 17 + Objects.hashCode(this.externalId);
        h = h * 17 + this.appId.hashCode();
        h = h * 17 + this.botId.hashCode();
        h = h * 17 + this.currentViewId.hashCode();
        h = h * 17 + this.rootViewId.hashCode();
        h = h * 17 + this.teamId.hashCode();
        h = h * 17 + this.stateValues.hashCode();
        h = h * 17 + this.hash.hashCode();
        h = h * 17 + Objects.hashCode(this.previousViewId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ModalViewResponse{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.closeButtonText != null) {
            builder.append(", ");
            builder.append("closeButtonText=").append(this.closeButtonText);
        }
        if (this.submitButtonText != null) {
            builder.append(", ");
            builder.append("submitButtonText=").append(this.submitButtonText);
        }
        if (this.clearOnClose != null) {
            builder.append(", ");
            builder.append("clearOnClose=").append(this.clearOnClose);
        }
        if (this.notifyOnClose != null) {
            builder.append(", ");
            builder.append("notifyOnClose=").append(this.notifyOnClose);
        }
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        if (this.privateMetadata != null) {
            builder.append(", ");
            builder.append("privateMetadata=").append(this.privateMetadata);
        }
        if (this.callbackId != null) {
            builder.append(", ");
            builder.append("callbackId=").append(this.callbackId);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        builder.append(", ");
        builder.append("appId=").append(this.appId);
        builder.append(", ");
        builder.append("botId=").append(this.botId);
        builder.append(", ");
        builder.append("currentViewId=").append(this.currentViewId);
        builder.append(", ");
        builder.append("rootViewId=").append(this.rootViewId);
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        builder.append(", ");
        builder.append("stateValues=").append(this.stateValues);
        builder.append(", ");
        builder.append("hash=").append(this.hash);
        if (this.previousViewId != null) {
            builder.append(", ");
            builder.append("previousViewId=").append(this.previousViewId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ModalViewResponse fromJson(Json json) {
        Builder builder = ModalViewResponse.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.closeButtonText != null) {
            builder.setCloseButtonText(json.closeButtonText);
        }
        if (json.submitButtonText != null) {
            builder.setSubmitButtonText(json.submitButtonText);
        }
        if (json.clearOnClose != null) {
            builder.setClearOnClose(json.clearOnClose);
        }
        if (json.notifyOnClose != null) {
            builder.setNotifyOnClose(json.notifyOnClose);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.privateMetadata != null) {
            builder.setPrivateMetadata(json.privateMetadata);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.appId != null) {
            builder.setAppId(json.appId);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.currentViewId != null) {
            builder.setCurrentViewId(json.currentViewId);
        }
        if (json.rootViewId != null) {
            builder.setRootViewId(json.rootViewId);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.stateValues != null) {
            builder.setStateValues(json.stateValues);
        }
        if (json.hash != null) {
            builder.setHash(json.hash);
        }
        if (json.previousViewId != null) {
            builder.setPreviousViewId(json.previousViewId);
        }
        return builder.build();
    }

    public static ModalViewResponse copyOf(ModalViewResponseIF instance) {
        if (instance instanceof ModalViewResponse) {
            return (ModalViewResponse)instance;
        }
        return ModalViewResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_APP_ID = 2L;
        private static final long INIT_BIT_BOT_ID = 4L;
        private static final long INIT_BIT_CURRENT_VIEW_ID = 8L;
        private static final long INIT_BIT_ROOT_VIEW_ID = 16L;
        private static final long INIT_BIT_TEAM_ID = 32L;
        private static final long INIT_BIT_STATE_VALUES = 64L;
        private static final long INIT_BIT_HASH = 128L;
        private long initBits = 255L;
        @Nullable
        private Text title;
        @Nullable
        private Text closeButtonText;
        @Nullable
        private Text submitButtonText;
        @Nullable
        private Boolean clearOnClose;
        @Nullable
        private Boolean notifyOnClose;
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String privateMetadata;
        @Nullable
        private String callbackId;
        @Nullable
        private String externalId;
        @Nullable
        private String appId;
        @Nullable
        private String botId;
        @Nullable
        private String currentViewId;
        @Nullable
        private String rootViewId;
        @Nullable
        private String teamId;
        @Nullable
        private StateBlock stateValues;
        @Nullable
        private String hash;
        @Nullable
        private String previousViewId;

        private Builder() {
        }

        public final Builder from(ModalViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewResponseBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModalViewResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewPayloadBase instance;
            if (object instanceof ModalViewPayloadBase) {
                Optional<Text> closeButtonTextOptional;
                Optional<Boolean> notifyOnCloseOptional;
                instance = (ModalViewPayloadBase)object;
                Optional<Text> submitButtonTextOptional = instance.getSubmitButtonText();
                if (submitButtonTextOptional.isPresent()) {
                    this.setSubmitButtonText(submitButtonTextOptional);
                }
                if ((notifyOnCloseOptional = instance.getNotifyOnClose()).isPresent()) {
                    this.setNotifyOnClose(notifyOnCloseOptional);
                }
                if ((closeButtonTextOptional = instance.getCloseButtonText()).isPresent()) {
                    this.setCloseButtonText(closeButtonTextOptional);
                }
                this.setTitle(instance.getTitle());
                Optional<Boolean> clearOnCloseOptional = instance.getClearOnClose();
                if (clearOnCloseOptional.isPresent()) {
                    this.setClearOnClose(clearOnCloseOptional);
                }
            }
            if (object instanceof ViewPayloadBase) {
                Optional<String> callbackIdOptional;
                Optional<String> privateMetadataOptional;
                instance = (ViewPayloadBase)object;
                Optional<String> externalIdOptional = instance.getExternalId();
                if (externalIdOptional.isPresent()) {
                    this.setExternalId(externalIdOptional);
                }
                if ((privateMetadataOptional = instance.getPrivateMetadata()).isPresent()) {
                    this.setPrivateMetadata(privateMetadataOptional);
                }
                if ((callbackIdOptional = instance.getCallbackId()).isPresent()) {
                    this.setCallbackId(callbackIdOptional);
                }
                this.addAllBlocks(instance.getBlocks());
            }
            if (object instanceof ViewResponseBase) {
                instance = (ViewResponseBase)object;
                this.setAppId(instance.getAppId());
                this.setTeamId(instance.getTeamId());
                this.setStateValues(instance.getStateValues());
                this.setBotId(instance.getBotId());
                Optional<String> previousViewIdOptional = instance.getPreviousViewId();
                if (previousViewIdOptional.isPresent()) {
                    this.setPreviousViewId(previousViewIdOptional);
                }
                this.setCurrentViewId(instance.getCurrentViewId());
                this.setHash(instance.getHash());
                this.setRootViewId(instance.getRootViewId());
            }
        }

        public final Builder setTitle(Text title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCloseButtonText(@Nullable Text closeButtonText) {
            this.closeButtonText = closeButtonText;
            return this;
        }

        public final Builder setCloseButtonText(Optional<Text> closeButtonText) {
            this.closeButtonText = closeButtonText.orElse(null);
            return this;
        }

        public final Builder setSubmitButtonText(@Nullable Text submitButtonText) {
            this.submitButtonText = submitButtonText;
            return this;
        }

        public final Builder setSubmitButtonText(Optional<Text> submitButtonText) {
            this.submitButtonText = submitButtonText.orElse(null);
            return this;
        }

        public final Builder setClearOnClose(@Nullable Boolean clearOnClose) {
            this.clearOnClose = clearOnClose;
            return this;
        }

        public final Builder setClearOnClose(Optional<Boolean> clearOnClose) {
            this.clearOnClose = clearOnClose.orElse(null);
            return this;
        }

        public final Builder setNotifyOnClose(@Nullable Boolean notifyOnClose) {
            this.notifyOnClose = notifyOnClose;
            return this;
        }

        public final Builder setNotifyOnClose(Optional<Boolean> notifyOnClose) {
            this.notifyOnClose = notifyOnClose.orElse(null);
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
            this.privateMetadata = privateMetadata;
            return this;
        }

        public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public final Builder setAppId(String appId) {
            this.appId = Objects.requireNonNull(appId, "appId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setBotId(String botId) {
            this.botId = Objects.requireNonNull(botId, "botId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setCurrentViewId(String currentViewId) {
            this.currentViewId = Objects.requireNonNull(currentViewId, "currentViewId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setRootViewId(String rootViewId) {
            this.rootViewId = Objects.requireNonNull(rootViewId, "rootViewId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setStateValues(StateBlock stateValues) {
            this.stateValues = Objects.requireNonNull(stateValues, "stateValues");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setHash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setPreviousViewId(@Nullable String previousViewId) {
            this.previousViewId = previousViewId;
            return this;
        }

        public final Builder setPreviousViewId(Optional<String> previousViewId) {
            this.previousViewId = previousViewId.orElse(null);
            return this;
        }

        public ModalViewResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ModalViewResponse(this.title, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, ModalViewResponse.createUnmodifiableList(true, this.blocks), this.privateMetadata, this.callbackId, this.externalId, this.appId, this.botId, this.currentViewId, this.rootViewId, this.teamId, this.stateValues, this.hash, this.previousViewId);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean appIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean botIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean currentViewIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean rootViewIdIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean stateValuesIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean hashIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.appIdIsSet()) {
                attributes.add("appId");
            }
            if (!this.botIdIsSet()) {
                attributes.add("botId");
            }
            if (!this.currentViewIdIsSet()) {
                attributes.add("currentViewId");
            }
            if (!this.rootViewIdIsSet()) {
                attributes.add("rootViewId");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            if (!this.stateValuesIsSet()) {
                attributes.add("stateValues");
            }
            if (!this.hashIsSet()) {
                attributes.add("hash");
            }
            return "Cannot build ModalViewResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ModalViewResponseIF {
        @Nullable
        Text title;
        Optional<Text> closeButtonText = Optional.empty();
        Optional<Text> submitButtonText = Optional.empty();
        Optional<Boolean> clearOnClose = Optional.empty();
        Optional<Boolean> notifyOnClose = Optional.empty();
        List<Block> blocks = Collections.emptyList();
        Optional<String> privateMetadata = Optional.empty();
        Optional<String> callbackId = Optional.empty();
        Optional<String> externalId = Optional.empty();
        @Nullable
        String appId;
        @Nullable
        String botId;
        @Nullable
        String currentViewId;
        @Nullable
        String rootViewId;
        @Nullable
        String teamId;
        @Nullable
        StateBlock stateValues;
        @Nullable
        String hash;
        Optional<String> previousViewId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(Text title) {
            this.title = title;
        }

        @JsonProperty(value="close")
        public void setCloseButtonText(Optional<Text> closeButtonText) {
            this.closeButtonText = closeButtonText;
        }

        @JsonProperty(value="submit")
        public void setSubmitButtonText(Optional<Text> submitButtonText) {
            this.submitButtonText = submitButtonText;
        }

        @JsonProperty
        public void setClearOnClose(Optional<Boolean> clearOnClose) {
            this.clearOnClose = clearOnClose;
        }

        @JsonProperty
        public void setNotifyOnClose(Optional<Boolean> notifyOnClose) {
            this.notifyOnClose = notifyOnClose;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @JsonProperty
        public void setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setAppId(String appId) {
            this.appId = appId;
        }

        @JsonProperty
        public void setBotId(String botId) {
            this.botId = botId;
        }

        @JsonProperty(value="id")
        public void setCurrentViewId(String currentViewId) {
            this.currentViewId = currentViewId;
        }

        @JsonProperty
        public void setRootViewId(String rootViewId) {
            this.rootViewId = rootViewId;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="state")
        @JsonDeserialize(using=StateBlockDeserializer.class)
        @JsonSerialize(using=StateBlockSerializer.class)
        public void setStateValues(StateBlock stateValues) {
            this.stateValues = stateValues;
        }

        @JsonProperty
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty
        public void setPreviousViewId(Optional<String> previousViewId) {
            this.previousViewId = previousViewId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getCloseButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getSubmitButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getClearOnClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getNotifyOnClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPrivateMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAppId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCurrentViewId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRootViewId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StateBlock getStateValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPreviousViewId() {
            throw new UnsupportedOperationException();
        }
    }
}

