/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.users.UsersProfileResponseIF;
import com.hubspot.slack.client.models.users.UserProfile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsersProfileResponse
implements UsersProfileResponseIF {
    private final UserProfile userProfile;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private UsersProfileResponse(UserProfile userProfile, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.userProfile = userProfile;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty(value="profile")
    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final UsersProfileResponse withUserProfile(UserProfile userProfile) {
        if (this.userProfile == userProfile) {
            return this;
        }
        UserProfile newValue = Objects.requireNonNull(userProfile, "userProfile");
        return new UsersProfileResponse(newValue, this.ok, this.responseMetadata);
    }

    public final UsersProfileResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new UsersProfileResponse(this.userProfile, ok, this.responseMetadata);
    }

    public final UsersProfileResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new UsersProfileResponse(this.userProfile, this.ok, newValue);
    }

    public final UsersProfileResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new UsersProfileResponse(this.userProfile, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersProfileResponse && this.equalTo((UsersProfileResponse)another);
    }

    private boolean equalTo(UsersProfileResponse another) {
        return this.userProfile.equals(another.userProfile) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.userProfile.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersProfileResponse{");
        builder.append("userProfile=").append(this.userProfile);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsersProfileResponse fromJson(Json json) {
        Builder builder = UsersProfileResponse.builder();
        if (json.userProfile != null) {
            builder.setUserProfile(json.userProfile);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static UsersProfileResponse copyOf(UsersProfileResponseIF instance) {
        if (instance instanceof UsersProfileResponse) {
            return (UsersProfileResponse)instance;
        }
        return UsersProfileResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_PROFILE = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        @Nullable
        private UserProfile userProfile;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UsersProfileResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof UsersProfileResponseIF) {
                instance = (UsersProfileResponseIF)object;
                this.setUserProfile(instance.getUserProfile());
            }
        }

        public final Builder setUserProfile(UserProfile userProfile) {
            this.userProfile = Objects.requireNonNull(userProfile, "userProfile");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public UsersProfileResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsersProfileResponse(this.userProfile, this.ok, this.responseMetadata);
        }

        private boolean userProfileIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userProfileIsSet()) {
                attributes.add("userProfile");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build UsersProfileResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UsersProfileResponseIF {
        @Nullable
        UserProfile userProfile;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty(value="profile")
        public void setUserProfile(UserProfile userProfile) {
            this.userProfile = userProfile;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public UserProfile getUserProfile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

