/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.users.UsersListResponseIF;
import com.hubspot.slack.client.models.users.SlackUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsersListResponse
implements UsersListResponseIF {
    private final List<SlackUser> members;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private UsersListResponse(List<SlackUser> members, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.members = members;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public List<SlackUser> getMembers() {
        return this.members;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final UsersListResponse withMembers(SlackUser ... elements) {
        List<SlackUser> newValue = UsersListResponse.createUnmodifiableList(false, UsersListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new UsersListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final UsersListResponse withMembers(Iterable<? extends SlackUser> elements) {
        if (this.members == elements) {
            return this;
        }
        List<SlackUser> newValue = UsersListResponse.createUnmodifiableList(false, UsersListResponse.createSafeList(elements, true, false));
        return new UsersListResponse(newValue, this.ok, this.responseMetadata);
    }

    public final UsersListResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new UsersListResponse(this.members, ok, this.responseMetadata);
    }

    public final UsersListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new UsersListResponse(this.members, this.ok, newValue);
    }

    public final UsersListResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new UsersListResponse(this.members, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersListResponse && this.equalTo((UsersListResponse)another);
    }

    private boolean equalTo(UsersListResponse another) {
        return this.members.equals(another.members) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.members.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersListResponse{");
        builder.append("members=").append(this.members);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsersListResponse fromJson(Json json) {
        Builder builder = UsersListResponse.builder();
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static UsersListResponse copyOf(UsersListResponseIF instance) {
        if (instance instanceof UsersListResponse) {
            return (UsersListResponse)instance;
        }
        return UsersListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private List<SlackUser> members = new ArrayList<SlackUser>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(UsersListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof UsersListResponseIF) {
                instance = (UsersListResponseIF)object;
                this.addAllMembers(instance.getMembers());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder addMembers(SlackUser element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(SlackUser ... elements) {
            for (SlackUser element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        public final Builder setMembers(Iterable<? extends SlackUser> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends SlackUser> elements) {
            for (SlackUser slackUser : elements) {
                this.members.add(Objects.requireNonNull(slackUser, "members element"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public UsersListResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsersListResponse(UsersListResponse.createUnmodifiableList(true, this.members), this.ok, this.responseMetadata);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build UsersListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UsersListResponseIF {
        List<SlackUser> members = Collections.emptyList();
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setMembers(List<SlackUser> members) {
            this.members = members;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public List<SlackUser> getMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

