/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupUpdateResponseIF;
import com.hubspot.slack.client.models.usergroups.SlackUsergroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsergroupUpdateResponse
implements UsergroupUpdateResponseIF {
    private final SlackUsergroup usergroup;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private UsergroupUpdateResponse(SlackUsergroup usergroup, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.usergroup = usergroup;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public SlackUsergroup getUsergroup() {
        return this.usergroup;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final UsergroupUpdateResponse withUsergroup(SlackUsergroup usergroup) {
        if (this.usergroup == usergroup) {
            return this;
        }
        SlackUsergroup newValue = Objects.requireNonNull(usergroup, "usergroup");
        return new UsergroupUpdateResponse(newValue, this.ok, this.responseMetadata);
    }

    public final UsergroupUpdateResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new UsergroupUpdateResponse(this.usergroup, ok, this.responseMetadata);
    }

    public final UsergroupUpdateResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new UsergroupUpdateResponse(this.usergroup, this.ok, newValue);
    }

    public final UsergroupUpdateResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new UsergroupUpdateResponse(this.usergroup, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupUpdateResponse && this.equalTo((UsergroupUpdateResponse)another);
    }

    private boolean equalTo(UsergroupUpdateResponse another) {
        return this.usergroup.equals(another.usergroup) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.usergroup.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupUpdateResponse{");
        builder.append("usergroup=").append(this.usergroup);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsergroupUpdateResponse fromJson(Json json) {
        Builder builder = UsergroupUpdateResponse.builder();
        if (json.usergroup != null) {
            builder.setUsergroup(json.usergroup);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static UsergroupUpdateResponse copyOf(UsergroupUpdateResponseIF instance) {
        if (instance instanceof UsergroupUpdateResponse) {
            return (UsergroupUpdateResponse)instance;
        }
        return UsergroupUpdateResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERGROUP = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackUsergroup usergroup;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UsergroupUpdateResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof UsergroupUpdateResponseIF) {
                instance = (UsergroupUpdateResponseIF)object;
                this.setUsergroup(instance.getUsergroup());
            }
        }

        public final Builder setUsergroup(SlackUsergroup usergroup) {
            this.usergroup = Objects.requireNonNull(usergroup, "usergroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public UsergroupUpdateResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsergroupUpdateResponse(this.usergroup, this.ok, this.responseMetadata);
        }

        private boolean usergroupIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.usergroupIsSet()) {
                attributes.add("usergroup");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build UsergroupUpdateResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UsergroupUpdateResponseIF {
        @Nullable
        SlackUsergroup usergroup;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setUsergroup(SlackUsergroup usergroup) {
            this.usergroup = usergroup;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public SlackUsergroup getUsergroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

