/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsHistoryResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationsHistoryResponse
implements ConversationsHistoryResponseIF {
    private final List<LiteMessage> messages;
    private final boolean hasMore;
    private final int pinCount;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ConversationsHistoryResponse(List<LiteMessage> messages, boolean hasMore, int pinCount, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.messages = messages;
        this.hasMore = hasMore;
        this.pinCount = pinCount;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public List<LiteMessage> getMessages() {
        return this.messages;
    }

    @Override
    @JsonProperty(value="has_more")
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    @JsonProperty
    public int getPinCount() {
        return this.pinCount;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ConversationsHistoryResponse withMessages(LiteMessage ... elements) {
        List<LiteMessage> newValue = ConversationsHistoryResponse.createUnmodifiableList(false, ConversationsHistoryResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationsHistoryResponse(newValue, this.hasMore, this.pinCount, this.ok, this.responseMetadata);
    }

    public final ConversationsHistoryResponse withMessages(Iterable<? extends LiteMessage> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<LiteMessage> newValue = ConversationsHistoryResponse.createUnmodifiableList(false, ConversationsHistoryResponse.createSafeList(elements, true, false));
        return new ConversationsHistoryResponse(newValue, this.hasMore, this.pinCount, this.ok, this.responseMetadata);
    }

    public final ConversationsHistoryResponse withHasMore(boolean hasMore) {
        if (this.hasMore == hasMore) {
            return this;
        }
        return new ConversationsHistoryResponse(this.messages, hasMore, this.pinCount, this.ok, this.responseMetadata);
    }

    public final ConversationsHistoryResponse withPinCount(int pinCount) {
        if (this.pinCount == pinCount) {
            return this;
        }
        return new ConversationsHistoryResponse(this.messages, this.hasMore, pinCount, this.ok, this.responseMetadata);
    }

    public final ConversationsHistoryResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ConversationsHistoryResponse(this.messages, this.hasMore, this.pinCount, ok, this.responseMetadata);
    }

    public final ConversationsHistoryResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ConversationsHistoryResponse(this.messages, this.hasMore, this.pinCount, this.ok, newValue);
    }

    public final ConversationsHistoryResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ConversationsHistoryResponse(this.messages, this.hasMore, this.pinCount, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsHistoryResponse && this.equalTo((ConversationsHistoryResponse)another);
    }

    private boolean equalTo(ConversationsHistoryResponse another) {
        return this.messages.equals(another.messages) && this.hasMore == another.hasMore && this.pinCount == another.pinCount && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.messages.hashCode();
        h = h * 17 + Boolean.hashCode(this.hasMore);
        h = h * 17 + this.pinCount;
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsHistoryResponse{");
        builder.append("messages=").append(this.messages);
        builder.append(", ");
        builder.append("hasMore=").append(this.hasMore);
        builder.append(", ");
        builder.append("pinCount=").append(this.pinCount);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationsHistoryResponse fromJson(Json json) {
        Builder builder = ConversationsHistoryResponse.builder();
        if (json.messages != null) {
            builder.addAllMessages(json.messages);
        }
        if (json.hasMoreIsSet) {
            builder.setHasMore(json.hasMore);
        }
        if (json.pinCountIsSet) {
            builder.setPinCount(json.pinCount);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ConversationsHistoryResponse copyOf(ConversationsHistoryResponseIF instance) {
        if (instance instanceof ConversationsHistoryResponse) {
            return (ConversationsHistoryResponse)instance;
        }
        return ConversationsHistoryResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HAS_MORE = 1L;
        private static final long INIT_BIT_PIN_COUNT = 2L;
        private static final long INIT_BIT_OK = 4L;
        private long initBits = 7L;
        private List<LiteMessage> messages = new ArrayList<LiteMessage>();
        private boolean hasMore;
        private int pinCount;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(ConversationsHistoryResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof ConversationsHistoryResponseIF) {
                instance = (ConversationsHistoryResponseIF)object;
                this.setHasMore(instance.hasMore());
                this.setPinCount(instance.getPinCount());
                this.addAllMessages(instance.getMessages());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder addMessages(LiteMessage element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(LiteMessage ... elements) {
            for (LiteMessage element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder setMessages(Iterable<? extends LiteMessage> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends LiteMessage> elements) {
            for (LiteMessage liteMessage : elements) {
                this.messages.add(Objects.requireNonNull(liteMessage, "messages element"));
            }
            return this;
        }

        public final Builder setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPinCount(int pinCount) {
            this.pinCount = pinCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ConversationsHistoryResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationsHistoryResponse(ConversationsHistoryResponse.createUnmodifiableList(true, this.messages), this.hasMore, this.pinCount, this.ok, this.responseMetadata);
        }

        private boolean hasMoreIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean pinCountIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.hasMoreIsSet()) {
                attributes.add("hasMore");
            }
            if (!this.pinCountIsSet()) {
                attributes.add("pinCount");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ConversationsHistoryResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationsHistoryResponseIF {
        List<LiteMessage> messages = Collections.emptyList();
        boolean hasMore;
        boolean hasMoreIsSet;
        int pinCount;
        boolean pinCountIsSet;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setMessages(List<LiteMessage> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="has_more")
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.hasMoreIsSet = true;
        }

        @JsonProperty
        public void setPinCount(int pinCount) {
            this.pinCount = pinCount;
            this.pinCountIsSet = true;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public List<LiteMessage> getMessages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPinCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

