/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationMemberResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationMemberResponse
implements ConversationMemberResponseIF {
    private final List<String> memberIds;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ConversationMemberResponse(List<String> memberIds, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.memberIds = memberIds;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty(value="members")
    public List<String> getMemberIds() {
        return this.memberIds;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ConversationMemberResponse withMemberIds(String ... elements) {
        List<String> newValue = ConversationMemberResponse.createUnmodifiableList(false, ConversationMemberResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationMemberResponse(newValue, this.ok, this.responseMetadata);
    }

    public final ConversationMemberResponse withMemberIds(Iterable<String> elements) {
        if (this.memberIds == elements) {
            return this;
        }
        List<String> newValue = ConversationMemberResponse.createUnmodifiableList(false, ConversationMemberResponse.createSafeList(elements, true, false));
        return new ConversationMemberResponse(newValue, this.ok, this.responseMetadata);
    }

    public final ConversationMemberResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ConversationMemberResponse(this.memberIds, ok, this.responseMetadata);
    }

    public final ConversationMemberResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ConversationMemberResponse(this.memberIds, this.ok, newValue);
    }

    public final ConversationMemberResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ConversationMemberResponse(this.memberIds, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationMemberResponse && this.equalTo((ConversationMemberResponse)another);
    }

    private boolean equalTo(ConversationMemberResponse another) {
        return this.memberIds.equals(another.memberIds) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.memberIds.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationMemberResponse{");
        builder.append("memberIds=").append(this.memberIds);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationMemberResponse fromJson(Json json) {
        Builder builder = ConversationMemberResponse.builder();
        if (json.memberIds != null) {
            builder.addAllMemberIds(json.memberIds);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ConversationMemberResponse copyOf(ConversationMemberResponseIF instance) {
        if (instance instanceof ConversationMemberResponse) {
            return (ConversationMemberResponse)instance;
        }
        return ConversationMemberResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private List<String> memberIds = new ArrayList<String>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConversationMemberResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ConversationMemberResponseIF) {
                instance = (ConversationMemberResponseIF)object;
                this.addAllMemberIds(instance.getMemberIds());
            }
        }

        public final Builder addMemberIds(String element) {
            this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
            return this;
        }

        public final Builder addMemberIds(String ... elements) {
            for (String element : elements) {
                this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
            }
            return this;
        }

        public final Builder setMemberIds(Iterable<String> elements) {
            this.memberIds.clear();
            return this.addAllMemberIds(elements);
        }

        public final Builder addAllMemberIds(Iterable<String> elements) {
            for (String element : elements) {
                this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ConversationMemberResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationMemberResponse(ConversationMemberResponse.createUnmodifiableList(true, this.memberIds), this.ok, this.responseMetadata);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ConversationMemberResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationMemberResponseIF {
        List<String> memberIds = Collections.emptyList();
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty(value="members")
        public void setMemberIds(List<String> memberIds) {
            this.memberIds = memberIds;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public List<String> getMemberIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

