/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.auth.AuthRevokeResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class AuthRevokeResponse
implements AuthRevokeResponseIF {
    private final boolean revoked;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private AuthRevokeResponse(boolean revoked, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.revoked = revoked;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public boolean isRevoked() {
        return this.revoked;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final AuthRevokeResponse withRevoked(boolean revoked) {
        if (this.revoked == revoked) {
            return this;
        }
        return new AuthRevokeResponse(revoked, this.ok, this.responseMetadata);
    }

    public final AuthRevokeResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new AuthRevokeResponse(this.revoked, ok, this.responseMetadata);
    }

    public final AuthRevokeResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new AuthRevokeResponse(this.revoked, this.ok, newValue);
    }

    public final AuthRevokeResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new AuthRevokeResponse(this.revoked, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuthRevokeResponse && this.equalTo((AuthRevokeResponse)another);
    }

    private boolean equalTo(AuthRevokeResponse another) {
        return this.revoked == another.revoked && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Boolean.hashCode(this.revoked);
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AuthRevokeResponse{");
        builder.append("revoked=").append(this.revoked);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static AuthRevokeResponse fromJson(Json json) {
        Builder builder = AuthRevokeResponse.builder();
        if (json.revokedIsSet) {
            builder.setRevoked(json.revoked);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static AuthRevokeResponse copyOf(AuthRevokeResponseIF instance) {
        if (instance instanceof AuthRevokeResponse) {
            return (AuthRevokeResponse)instance;
        }
        return AuthRevokeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REVOKED = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        private boolean revoked;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(AuthRevokeResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof AuthRevokeResponseIF) {
                instance = (AuthRevokeResponseIF)object;
                this.setRevoked(instance.isRevoked());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder setRevoked(boolean revoked) {
            this.revoked = revoked;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public AuthRevokeResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new AuthRevokeResponse(this.revoked, this.ok, this.responseMetadata);
        }

        private boolean revokedIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.revokedIsSet()) {
                attributes.add("revoked");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build AuthRevokeResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements AuthRevokeResponseIF {
        boolean revoked;
        boolean revokedIsSet;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setRevoked(boolean revoked) {
            this.revoked = revoked;
            this.revokedIsSet = true;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public boolean isRevoked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

