/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import com.hubspot.slack.client.models.interaction.views.ViewRadioButtonGroupIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewRadioButtonGroup
implements ViewRadioButtonGroupIF {
    @Nullable
    private final Option selectedOption;
    private final ViewInputType type;

    private ViewRadioButtonGroup(@Nullable Option selectedOption, ViewInputType type) {
        this.selectedOption = selectedOption;
        this.type = type;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
    public Optional<Option> getSelectedOption() {
        return Optional.ofNullable(this.selectedOption);
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    public final ViewRadioButtonGroup withSelectedOption(@Nullable Option value) {
        Option newValue = value;
        if (this.selectedOption == newValue) {
            return this;
        }
        return new ViewRadioButtonGroup(newValue, this.type);
    }

    public final ViewRadioButtonGroup withSelectedOption(Optional<Option> optional) {
        Option value = optional.orElse(null);
        if (this.selectedOption == value) {
            return this;
        }
        return new ViewRadioButtonGroup(value, this.type);
    }

    public final ViewRadioButtonGroup withType(ViewInputType type) {
        if (this.type == type) {
            return this;
        }
        ViewInputType newValue = Objects.requireNonNull(type, "type");
        return new ViewRadioButtonGroup(this.selectedOption, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewRadioButtonGroup && this.equalTo((ViewRadioButtonGroup)another);
    }

    private boolean equalTo(ViewRadioButtonGroup another) {
        return Objects.equals(this.selectedOption, another.selectedOption) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.selectedOption);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewRadioButtonGroup{");
        if (this.selectedOption != null) {
            builder.append("selectedOption=").append(this.selectedOption);
        }
        if (builder.length() > 21) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ViewRadioButtonGroup fromJson(Json json) {
        Builder builder = ViewRadioButtonGroup.builder();
        if (json.selectedOption != null) {
            builder.setSelectedOption(json.selectedOption);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static ViewRadioButtonGroup copyOf(ViewRadioButtonGroupIF instance) {
        if (instance instanceof ViewRadioButtonGroup) {
            return (ViewRadioButtonGroup)instance;
        }
        return ViewRadioButtonGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private Option selectedOption;
        @Nullable
        private ViewInputType type;

        private Builder() {
        }

        public final Builder from(ViewRadioButtonGroupIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewInput instance;
            Optional<Option> selectedOptionOptional;
            if (object instanceof ViewRadioButtonGroupIF && (selectedOptionOptional = (instance = (ViewRadioButtonGroupIF)object).getSelectedOption()).isPresent()) {
                this.setSelectedOption(selectedOptionOptional);
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setSelectedOption(@Nullable Option selectedOption) {
            this.selectedOption = selectedOption;
            return this;
        }

        public final Builder setSelectedOption(Optional<Option> selectedOption) {
            this.selectedOption = selectedOption.orElse(null);
            return this;
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ViewRadioButtonGroup build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewRadioButtonGroup(this.selectedOption, this.type);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewRadioButtonGroup, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewRadioButtonGroupIF {
        Optional<Option> selectedOption = Optional.empty();
        @Nullable
        ViewInputType type;

        Json() {
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
        public void setSelectedOption(Optional<Option> selectedOption) {
            this.selectedOption = selectedOption;
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @Override
        public Optional<Option> getSelectedOption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

