/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.UsersSelectInputIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsersSelectInput
implements UsersSelectInputIF {
    @Nullable
    private final String selectedUser;
    private final ViewInputType type;

    private UsersSelectInput(@Nullable String selectedUser, ViewInputType type) {
        this.selectedUser = selectedUser;
        this.type = type;
    }

    @Override
    @JsonProperty
    public Optional<String> getSelectedUser() {
        return Optional.ofNullable(this.selectedUser);
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    public final UsersSelectInput withSelectedUser(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.selectedUser, newValue)) {
            return this;
        }
        return new UsersSelectInput(newValue, this.type);
    }

    public final UsersSelectInput withSelectedUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.selectedUser, value)) {
            return this;
        }
        return new UsersSelectInput(value, this.type);
    }

    public final UsersSelectInput withType(ViewInputType type) {
        if (this.type == type) {
            return this;
        }
        ViewInputType newValue = Objects.requireNonNull(type, "type");
        return new UsersSelectInput(this.selectedUser, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersSelectInput && this.equalTo((UsersSelectInput)another);
    }

    private boolean equalTo(UsersSelectInput another) {
        return Objects.equals(this.selectedUser, another.selectedUser) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.selectedUser);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersSelectInput{");
        if (this.selectedUser != null) {
            builder.append("selectedUser=").append(this.selectedUser);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsersSelectInput fromJson(Json json) {
        Builder builder = UsersSelectInput.builder();
        if (json.selectedUser != null) {
            builder.setSelectedUser(json.selectedUser);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static UsersSelectInput copyOf(UsersSelectInputIF instance) {
        if (instance instanceof UsersSelectInput) {
            return (UsersSelectInput)instance;
        }
        return UsersSelectInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String selectedUser;
        @Nullable
        private ViewInputType type;

        private Builder() {
        }

        public final Builder from(UsersSelectInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewInput instance;
            Optional<String> selectedUserOptional;
            if (object instanceof UsersSelectInputIF && (selectedUserOptional = (instance = (UsersSelectInputIF)object).getSelectedUser()).isPresent()) {
                this.setSelectedUser(selectedUserOptional);
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setSelectedUser(@Nullable String selectedUser) {
            this.selectedUser = selectedUser;
            return this;
        }

        public final Builder setSelectedUser(Optional<String> selectedUser) {
            this.selectedUser = selectedUser.orElse(null);
            return this;
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UsersSelectInput build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new UsersSelectInput(this.selectedUser, this.type);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build UsersSelectInput, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UsersSelectInputIF {
        Optional<String> selectedUser = Optional.empty();
        @Nullable
        ViewInputType type;

        Json() {
        }

        @JsonProperty
        public void setSelectedUser(Optional<String> selectedUser) {
            this.selectedUser = selectedUser;
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @Override
        public Optional<String> getSelectedUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

