/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.interaction.ViewInteractionPayload;
import com.hubspot.slack.client.models.interaction.ViewSubmissionIF;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewSubmission
implements ViewSubmissionIF {
    private final ViewInteractionPayload view;
    private final InteractiveCallbackType type;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;

    private ViewSubmission(ViewInteractionPayload view, InteractiveCallbackType type, String token, SlackTeam team, SlackUserLite user) {
        this.view = view;
        this.type = type;
        this.token = token;
        this.team = team;
        this.user = user;
    }

    @Override
    @JsonProperty
    public ViewInteractionPayload getView() {
        return this.view;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    public final ViewSubmission withView(ViewInteractionPayload view) {
        if (this.view == view) {
            return this;
        }
        ViewInteractionPayload newValue = Objects.requireNonNull(view, "view");
        return new ViewSubmission(newValue, this.type, this.token, this.team, this.user);
    }

    public final ViewSubmission withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new ViewSubmission(this.view, newValue, this.token, this.team, this.user);
    }

    public final ViewSubmission withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new ViewSubmission(this.view, this.type, newValue, this.team, this.user);
    }

    public final ViewSubmission withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new ViewSubmission(this.view, this.type, this.token, newValue, this.user);
    }

    public final ViewSubmission withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new ViewSubmission(this.view, this.type, this.token, this.team, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewSubmission && this.equalTo((ViewSubmission)another);
    }

    private boolean equalTo(ViewSubmission another) {
        return this.view.equals(another.view) && this.type.equals((Object)another.type) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.view.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "ViewSubmission{view=" + this.view + ", type=" + (Object)((Object)this.type) + ", token=" + this.token + ", team=" + this.team + ", user=" + this.user + "}";
    }

    @Deprecated
    @JsonCreator
    static ViewSubmission fromJson(Json json) {
        Builder builder = ViewSubmission.builder();
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        return builder.build();
    }

    public static ViewSubmission copyOf(ViewSubmissionIF instance) {
        if (instance instanceof ViewSubmission) {
            return (ViewSubmission)instance;
        }
        return ViewSubmission.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VIEW = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_TOKEN = 4L;
        private static final long INIT_BIT_TEAM = 8L;
        private static final long INIT_BIT_USER = 16L;
        private long initBits = 31L;
        @Nullable
        private ViewInteractionPayload view;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;

        private Builder() {
        }

        public final Builder from(ViewSubmissionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof ViewSubmissionIF) {
                instance = (ViewSubmissionIF)object;
                this.setView(instance.getView());
            }
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
        }

        public final Builder setView(ViewInteractionPayload view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ViewSubmission build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewSubmission(this.view, this.type, this.token, this.team, this.user);
        }

        private boolean viewIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            return "Cannot build ViewSubmission, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewSubmissionIF {
        @Nullable
        ViewInteractionPayload view;
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;

        Json() {
        }

        @JsonProperty
        public void setView(ViewInteractionPayload view) {
            this.view = view;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @Override
        public ViewInteractionPayload getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }
    }
}

