/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.ViewResponseActionIF;
import com.hubspot.slack.client.models.views.ModalViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewResponseAction
implements ViewResponseActionIF {
    private final String responseAction;
    @Nullable
    private final ModalViewPayload view;
    private final Map<String, String> errors;

    private ViewResponseAction(String responseAction, @Nullable ModalViewPayload view, Map<String, String> errors) {
        this.responseAction = responseAction;
        this.view = view;
        this.errors = errors;
    }

    @Override
    @JsonProperty
    public String getResponseAction() {
        return this.responseAction;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<ModalViewPayload> getView() {
        return Optional.ofNullable(this.view);
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getErrors() {
        return this.errors;
    }

    public final ViewResponseAction withResponseAction(String responseAction) {
        if (this.responseAction.equals(responseAction)) {
            return this;
        }
        String newValue = Objects.requireNonNull(responseAction, "responseAction");
        return new ViewResponseAction(newValue, this.view, this.errors);
    }

    public final ViewResponseAction withView(@Nullable ModalViewPayload value) {
        ModalViewPayload newValue = value;
        if (this.view == newValue) {
            return this;
        }
        return new ViewResponseAction(this.responseAction, newValue, this.errors);
    }

    public final ViewResponseAction withView(Optional<ModalViewPayload> optional) {
        ModalViewPayload value = optional.orElse(null);
        if (this.view == value) {
            return this;
        }
        return new ViewResponseAction(this.responseAction, value, this.errors);
    }

    public final ViewResponseAction withErrors(Map<String, ? extends String> errors) {
        if (this.errors == errors) {
            return this;
        }
        Map<String, String> newValue = ViewResponseAction.createUnmodifiableMap(true, false, errors);
        return new ViewResponseAction(this.responseAction, this.view, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewResponseAction && this.equalTo((ViewResponseAction)another);
    }

    private boolean equalTo(ViewResponseAction another) {
        return this.responseAction.equals(another.responseAction) && Objects.equals(this.view, another.view) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.responseAction.hashCode();
        h = h * 17 + Objects.hashCode(this.view);
        h = h * 17 + this.errors.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewResponseAction{");
        builder.append("responseAction=").append(this.responseAction);
        if (this.view != null) {
            builder.append(", ");
            builder.append("view=").append(this.view);
        }
        builder.append(", ");
        builder.append("errors=").append(this.errors);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ViewResponseAction fromJson(Json json) {
        Builder builder = ViewResponseAction.builder();
        if (json.responseAction != null) {
            builder.setResponseAction(json.responseAction);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.errors != null) {
            builder.putAllErrors(json.errors);
        }
        return builder.build();
    }

    public static ViewResponseAction copyOf(ViewResponseActionIF instance) {
        if (instance instanceof ViewResponseAction) {
            return (ViewResponseAction)instance;
        }
        return ViewResponseAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE_ACTION = 1L;
        private long initBits = 1L;
        @Nullable
        private String responseAction;
        @Nullable
        private ModalViewPayload view;
        private Map<String, String> errors = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(ViewResponseActionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setResponseAction(instance.getResponseAction());
            Optional<ModalViewPayload> viewOptional = instance.getView();
            if (viewOptional.isPresent()) {
                this.setView(viewOptional);
            }
            this.putAllErrors(instance.getErrors());
            return this;
        }

        public final Builder setResponseAction(String responseAction) {
            this.responseAction = Objects.requireNonNull(responseAction, "responseAction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setView(@Nullable ModalViewPayload view) {
            this.view = view;
            return this;
        }

        public final Builder setView(Optional<ModalViewPayload> view) {
            this.view = view.orElse(null);
            return this;
        }

        public final Builder putErrors(String key, String value) {
            this.errors.put(Objects.requireNonNull(key, "errors key"), Objects.requireNonNull(value, "errors value"));
            return this;
        }

        public final Builder putErrors(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.errors.put(Objects.requireNonNull(k, "errors key"), Objects.requireNonNull(v, "errors value"));
            return this;
        }

        public final Builder setErrors(Map<String, ? extends String> errors) {
            this.errors.clear();
            return this.putAllErrors(errors);
        }

        public final Builder putAllErrors(Map<String, ? extends String> errors) {
            for (Map.Entry<String, ? extends String> entry : errors.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.errors.put(Objects.requireNonNull(k, "errors key"), Objects.requireNonNull(v, "errors value"));
            }
            return this;
        }

        public ViewResponseAction build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewResponseAction(this.responseAction, this.view, ViewResponseAction.createUnmodifiableMap(false, false, this.errors));
        }

        private boolean responseActionIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.responseActionIsSet()) {
                attributes.add("responseAction");
            }
            return "Cannot build ViewResponseAction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewResponseActionIF {
        @Nullable
        String responseAction;
        Optional<ModalViewPayload> view = Optional.empty();
        @Nullable
        Map<String, String> errors;

        Json() {
        }

        @JsonProperty
        public void setResponseAction(String responseAction) {
            this.responseAction = responseAction;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setView(Optional<ModalViewPayload> view) {
            this.view = view;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setErrors(Map<String, String> errors) {
            this.errors = errors;
        }

        @Override
        public String getResponseAction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ModalViewPayload> getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getErrors() {
            throw new UnsupportedOperationException();
        }
    }
}

