/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.Container;
import com.hubspot.slack.client.models.interaction.ContainerType;
import com.hubspot.slack.client.models.interaction.ViewContainerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ViewContainer
implements ViewContainerIF {
    private final String viewId;
    private final ContainerType type;

    private ViewContainer(String viewId, ContainerType type) {
        this.viewId = viewId;
        this.type = type;
    }

    @Override
    @JsonProperty
    public String getViewId() {
        return this.viewId;
    }

    @Override
    @JsonProperty
    public ContainerType getType() {
        return this.type;
    }

    public final ViewContainer withViewId(String viewId) {
        if (this.viewId.equals(viewId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(viewId, "viewId");
        return new ViewContainer(newValue, this.type);
    }

    public final ViewContainer withType(ContainerType type) {
        if (this.type == type) {
            return this;
        }
        ContainerType newValue = Objects.requireNonNull(type, "type");
        return new ViewContainer(this.viewId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewContainer && this.equalTo((ViewContainer)another);
    }

    private boolean equalTo(ViewContainer another) {
        return this.viewId.equals(another.viewId) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.viewId.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ViewContainer{viewId=" + this.viewId + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static ViewContainer fromJson(Json json) {
        Builder builder = ViewContainer.builder();
        if (json.viewId != null) {
            builder.setViewId(json.viewId);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static ViewContainer copyOf(ViewContainerIF instance) {
        if (instance instanceof ViewContainer) {
            return (ViewContainer)instance;
        }
        return ViewContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VIEW_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String viewId;
        @Nullable
        private ContainerType type;

        private Builder() {
        }

        public final Builder from(ViewContainerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Container instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Container instance;
            if (object instanceof ViewContainerIF) {
                instance = (ViewContainerIF)object;
                this.setViewId(instance.getViewId());
            }
            if (object instanceof Container) {
                instance = (Container)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setViewId(String viewId) {
            this.viewId = Objects.requireNonNull(viewId, "viewId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setType(ContainerType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ViewContainer build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ViewContainer(this.viewId, this.type);
        }

        private boolean viewIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.viewIdIsSet()) {
                attributes.add("viewId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewContainer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ViewContainerIF {
        @Nullable
        String viewId;
        @Nullable
        ContainerType type;

        Json() {
        }

        @JsonProperty
        public void setViewId(String viewId) {
            this.viewId = viewId;
        }

        @JsonProperty
        public void setType(ContainerType type) {
            this.type = type;
        }

        @Override
        public String getViewId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContainerType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

