/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.ShortcutIF;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Shortcut
implements ShortcutIF {
    private final String triggerId;
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;

    private Shortcut(String triggerId, InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackUserLite user) {
        this.triggerId = triggerId;
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.user = user;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    public final Shortcut withTriggerId(String triggerId) {
        if (this.triggerId.equals(triggerId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(triggerId, "triggerId");
        return new Shortcut(newValue, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user);
    }

    public final Shortcut withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new Shortcut(this.triggerId, newValue, this.callbackId, this.actionTs, this.token, this.team, this.user);
    }

    public final Shortcut withCallbackId(String callbackId) {
        if (this.callbackId.equals(callbackId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(callbackId, "callbackId");
        return new Shortcut(this.triggerId, this.type, newValue, this.actionTs, this.token, this.team, this.user);
    }

    public final Shortcut withActionTs(String actionTs) {
        if (this.actionTs.equals(actionTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionTs, "actionTs");
        return new Shortcut(this.triggerId, this.type, this.callbackId, newValue, this.token, this.team, this.user);
    }

    public final Shortcut withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, newValue, this.team, this.user);
    }

    public final Shortcut withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, this.token, newValue, this.user);
    }

    public final Shortcut withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Shortcut && this.equalTo((Shortcut)another);
    }

    private boolean equalTo(Shortcut another) {
        return this.triggerId.equals(another.triggerId) && this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.triggerId.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.callbackId.hashCode();
        h = h * 17 + this.actionTs.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "Shortcut{triggerId=" + this.triggerId + ", type=" + (Object)((Object)this.type) + ", callbackId=" + this.callbackId + ", actionTs=" + this.actionTs + ", token=" + this.token + ", team=" + this.team + ", user=" + this.user + "}";
    }

    @Deprecated
    @JsonCreator
    static Shortcut fromJson(Json json) {
        Builder builder = Shortcut.builder();
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        return builder.build();
    }

    public static Shortcut copyOf(ShortcutIF instance) {
        if (instance instanceof Shortcut) {
            return (Shortcut)instance;
        }
        return Shortcut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRIGGER_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_CALLBACK_ID = 4L;
        private static final long INIT_BIT_ACTION_TS = 8L;
        private static final long INIT_BIT_TOKEN = 16L;
        private static final long INIT_BIT_TEAM = 32L;
        private static final long INIT_BIT_USER = 64L;
        private long initBits = 127L;
        @Nullable
        private String triggerId;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;

        private Builder() {
        }

        public final Builder from(ShortcutIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof ShortcutIF) {
                instance = (ShortcutIF)object;
                this.setTriggerId(instance.getTriggerId());
            }
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setCallbackId(instance.getCallbackId());
                this.setActionTs(instance.getActionTs());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public Shortcut build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user);
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            return "Cannot build Shortcut, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ShortcutIF {
        @Nullable
        String triggerId;
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;

        Json() {
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }
    }
}

