/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.actions.Action;
import com.hubspot.slack.client.models.interaction.InteractiveActionIF;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class InteractiveAction
implements InteractiveActionIF {
    private final List<Action> actions;
    private final String messageTs;
    private final int attachmentId;
    private final boolean appUnfurl;
    @Nullable
    private final LiteMessage originalMessage;
    private final String responseUrl;
    private final String triggerId;
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final SlackChannel channel;

    private InteractiveAction(List<Action> actions, String messageTs, int attachmentId, boolean appUnfurl, @Nullable LiteMessage originalMessage, String responseUrl, String triggerId, InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackUserLite user, SlackChannel channel) {
        this.actions = actions;
        this.messageTs = messageTs;
        this.attachmentId = attachmentId;
        this.appUnfurl = appUnfurl;
        this.originalMessage = originalMessage;
        this.responseUrl = responseUrl;
        this.triggerId = triggerId;
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.user = user;
        this.channel = channel;
    }

    @Override
    @JsonProperty
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    @JsonProperty
    public String getMessageTs() {
        return this.messageTs;
    }

    @Override
    @JsonProperty
    public int getAttachmentId() {
        return this.attachmentId;
    }

    @Override
    @JsonProperty(value="is_app_unfurl")
    public boolean isAppUnfurl() {
        return this.appUnfurl;
    }

    @Override
    @JsonProperty
    public Optional<LiteMessage> getOriginalMessage() {
        return Optional.ofNullable(this.originalMessage);
    }

    @Override
    @JsonProperty
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    public final InteractiveAction withActions(Action ... elements) {
        List<Action> newValue = InteractiveAction.createUnmodifiableList(false, InteractiveAction.createSafeList(Arrays.asList(elements), true, false));
        return new InteractiveAction(newValue, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withActions(Iterable<? extends Action> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<Action> newValue = InteractiveAction.createUnmodifiableList(false, InteractiveAction.createSafeList(elements, true, false));
        return new InteractiveAction(newValue, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withMessageTs(String messageTs) {
        if (this.messageTs.equals(messageTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(messageTs, "messageTs");
        return new InteractiveAction(this.actions, newValue, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withAttachmentId(int attachmentId) {
        if (this.attachmentId == attachmentId) {
            return this;
        }
        return new InteractiveAction(this.actions, this.messageTs, attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withAppUnfurl(boolean appUnfurl) {
        if (this.appUnfurl == appUnfurl) {
            return this;
        }
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withOriginalMessage(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.originalMessage == newValue) {
            return this;
        }
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, newValue, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withOriginalMessage(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.originalMessage == value) {
            return this;
        }
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, value, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withResponseUrl(String responseUrl) {
        if (this.responseUrl.equals(responseUrl)) {
            return this;
        }
        String newValue = Objects.requireNonNull(responseUrl, "responseUrl");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, newValue, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withTriggerId(String triggerId) {
        if (this.triggerId.equals(triggerId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(triggerId, "triggerId");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, newValue, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, newValue, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withCallbackId(String callbackId) {
        if (this.callbackId.equals(callbackId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(callbackId, "callbackId");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, newValue, this.actionTs, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withActionTs(String actionTs) {
        if (this.actionTs.equals(actionTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionTs, "actionTs");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, newValue, this.token, this.team, this.user, this.channel);
    }

    public final InteractiveAction withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, newValue, this.team, this.user, this.channel);
    }

    public final InteractiveAction withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, newValue, this.user, this.channel);
    }

    public final InteractiveAction withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, newValue, this.channel);
    }

    public final InteractiveAction withChannel(SlackChannel channel) {
        if (this.channel == channel) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(channel, "channel");
        return new InteractiveAction(this.actions, this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractiveAction && this.equalTo((InteractiveAction)another);
    }

    private boolean equalTo(InteractiveAction another) {
        return this.actions.equals(another.actions) && this.messageTs.equals(another.messageTs) && this.attachmentId == another.attachmentId && this.appUnfurl == another.appUnfurl && Objects.equals(this.originalMessage, another.originalMessage) && this.responseUrl.equals(another.responseUrl) && this.triggerId.equals(another.triggerId) && this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.actions.hashCode();
        h = h * 17 + this.messageTs.hashCode();
        h = h * 17 + this.attachmentId;
        h = h * 17 + Boolean.hashCode(this.appUnfurl);
        h = h * 17 + Objects.hashCode(this.originalMessage);
        h = h * 17 + this.responseUrl.hashCode();
        h = h * 17 + this.triggerId.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.callbackId.hashCode();
        h = h * 17 + this.actionTs.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.channel.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("InteractiveAction{");
        builder.append("actions=").append(this.actions);
        builder.append(", ");
        builder.append("messageTs=").append(this.messageTs);
        builder.append(", ");
        builder.append("attachmentId=").append(this.attachmentId);
        builder.append(", ");
        builder.append("appUnfurl=").append(this.appUnfurl);
        if (this.originalMessage != null) {
            builder.append(", ");
            builder.append("originalMessage=").append(this.originalMessage);
        }
        builder.append(", ");
        builder.append("responseUrl=").append(this.responseUrl);
        builder.append(", ");
        builder.append("triggerId=").append(this.triggerId);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("callbackId=").append(this.callbackId);
        builder.append(", ");
        builder.append("actionTs=").append(this.actionTs);
        builder.append(", ");
        builder.append("token=").append(this.token);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static InteractiveAction fromJson(Json json) {
        Builder builder = InteractiveAction.builder();
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.attachmentIdIsSet) {
            builder.setAttachmentId(json.attachmentId);
        }
        if (json.appUnfurlIsSet) {
            builder.setAppUnfurl(json.appUnfurl);
        }
        if (json.originalMessage != null) {
            builder.setOriginalMessage(json.originalMessage);
        }
        if (json.responseUrl != null) {
            builder.setResponseUrl(json.responseUrl);
        }
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static InteractiveAction copyOf(InteractiveActionIF instance) {
        if (instance instanceof InteractiveAction) {
            return (InteractiveAction)instance;
        }
        return InteractiveAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE_TS = 1L;
        private static final long INIT_BIT_ATTACHMENT_ID = 2L;
        private static final long INIT_BIT_APP_UNFURL = 4L;
        private static final long INIT_BIT_RESPONSE_URL = 8L;
        private static final long INIT_BIT_TRIGGER_ID = 16L;
        private static final long INIT_BIT_TYPE = 32L;
        private static final long INIT_BIT_CALLBACK_ID = 64L;
        private static final long INIT_BIT_ACTION_TS = 128L;
        private static final long INIT_BIT_TOKEN = 256L;
        private static final long INIT_BIT_TEAM = 512L;
        private static final long INIT_BIT_USER = 1024L;
        private static final long INIT_BIT_CHANNEL = 2048L;
        private long initBits = 4095L;
        private List<Action> actions = new ArrayList<Action>();
        @Nullable
        private String messageTs;
        private int attachmentId;
        private boolean appUnfurl;
        @Nullable
        private LiteMessage originalMessage;
        @Nullable
        private String responseUrl;
        @Nullable
        private String triggerId;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private SlackChannel channel;

        private Builder() {
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InteractiveActionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setCallbackId(instance.getCallbackId());
                this.setChannel(instance.getChannel());
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setActionTs(instance.getActionTs());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
            if (object instanceof InteractiveActionIF) {
                instance = (InteractiveActionIF)object;
                this.setResponseUrl(instance.getResponseUrl());
                this.setAppUnfurl(instance.isAppUnfurl());
                this.setTriggerId(instance.getTriggerId());
                this.setAttachmentId(instance.getAttachmentId());
                Optional<LiteMessage> originalMessageOptional = instance.getOriginalMessage();
                if (originalMessageOptional.isPresent()) {
                    this.setOriginalMessage(originalMessageOptional);
                }
                this.setMessageTs(instance.getMessageTs());
                this.addAllActions(instance.getActions());
            }
        }

        public final Builder addActions(Action element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        public final Builder addActions(Action ... elements) {
            for (Action element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        public final Builder setActions(Iterable<? extends Action> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final Builder addAllActions(Iterable<? extends Action> elements) {
            for (Action action : elements) {
                this.actions.add(Objects.requireNonNull(action, "actions element"));
            }
            return this;
        }

        public final Builder setMessageTs(String messageTs) {
            this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setAttachmentId(int attachmentId) {
            this.attachmentId = attachmentId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setAppUnfurl(boolean appUnfurl) {
            this.appUnfurl = appUnfurl;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setOriginalMessage(@Nullable LiteMessage originalMessage) {
            this.originalMessage = originalMessage;
            return this;
        }

        public final Builder setOriginalMessage(Optional<LiteMessage> originalMessage) {
            this.originalMessage = originalMessage.orElse(null);
            return this;
        }

        public final Builder setResponseUrl(String responseUrl) {
            this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public InteractiveAction build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new InteractiveAction(InteractiveAction.createUnmodifiableList(true, this.actions), this.messageTs, this.attachmentId, this.appUnfurl, this.originalMessage, this.responseUrl, this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel);
        }

        private boolean messageTsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean attachmentIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean appUnfurlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean responseUrlIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x400L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x800L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.messageTsIsSet()) {
                attributes.add("messageTs");
            }
            if (!this.attachmentIdIsSet()) {
                attributes.add("attachmentId");
            }
            if (!this.appUnfurlIsSet()) {
                attributes.add("appUnfurl");
            }
            if (!this.responseUrlIsSet()) {
                attributes.add("responseUrl");
            }
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build InteractiveAction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements InteractiveActionIF {
        List<Action> actions = Collections.emptyList();
        @Nullable
        String messageTs;
        int attachmentId;
        boolean attachmentIdIsSet;
        boolean appUnfurl;
        boolean appUnfurlIsSet;
        Optional<LiteMessage> originalMessage = Optional.empty();
        @Nullable
        String responseUrl;
        @Nullable
        String triggerId;
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        SlackChannel channel;

        Json() {
        }

        @JsonProperty
        public void setActions(List<Action> actions) {
            this.actions = actions;
        }

        @JsonProperty
        public void setMessageTs(String messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setAttachmentId(int attachmentId) {
            this.attachmentId = attachmentId;
            this.attachmentIdIsSet = true;
        }

        @JsonProperty(value="is_app_unfurl")
        public void setAppUnfurl(boolean appUnfurl) {
            this.appUnfurl = appUnfurl;
            this.appUnfurlIsSet = true;
        }

        @JsonProperty
        public void setOriginalMessage(Optional<LiteMessage> originalMessage) {
            this.originalMessage = originalMessage;
        }

        @JsonProperty
        public void setResponseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @Override
        public List<Action> getActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getAttachmentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAppUnfurl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getOriginalMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResponseUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }
    }
}

