/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.interaction.BlockActionsIF;
import com.hubspot.slack.client.models.interaction.BlockElementAction;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.response.views.ViewResponseBase;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class BlockActions
implements BlockActionsIF {
    private final String triggerId;
    @Nullable
    private final String responseUrl;
    @Nullable
    private final LiteMessage message;
    @Nullable
    private final ViewResponseBase view;
    private final List<BlockElementAction> elementActions;
    private final InteractiveCallbackType type;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;

    private BlockActions(String triggerId, @Nullable String responseUrl, @Nullable LiteMessage message, @Nullable ViewResponseBase view, List<BlockElementAction> elementActions, InteractiveCallbackType type, String token, SlackTeam team, SlackUserLite user) {
        this.triggerId = triggerId;
        this.responseUrl = responseUrl;
        this.message = message;
        this.view = view;
        this.elementActions = elementActions;
        this.type = type;
        this.token = token;
        this.team = team;
        this.user = user;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public Optional<String> getResponseUrl() {
        return Optional.ofNullable(this.responseUrl);
    }

    @Override
    @JsonProperty
    public Optional<LiteMessage> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Override
    @JsonProperty
    public Optional<ViewResponseBase> getView() {
        return Optional.ofNullable(this.view);
    }

    @Override
    @JsonProperty(value="actions")
    public List<BlockElementAction> getElementActions() {
        return this.elementActions;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    public final BlockActions withTriggerId(String triggerId) {
        if (this.triggerId.equals(triggerId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(triggerId, "triggerId");
        return new BlockActions(newValue, this.responseUrl, this.message, this.view, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withResponseUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.responseUrl, newValue)) {
            return this;
        }
        return new BlockActions(this.triggerId, newValue, this.message, this.view, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withResponseUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.responseUrl, value)) {
            return this;
        }
        return new BlockActions(this.triggerId, value, this.message, this.view, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withMessage(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.message == newValue) {
            return this;
        }
        return new BlockActions(this.triggerId, this.responseUrl, newValue, this.view, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withMessage(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.message == value) {
            return this;
        }
        return new BlockActions(this.triggerId, this.responseUrl, value, this.view, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withView(@Nullable ViewResponseBase value) {
        ViewResponseBase newValue = value;
        if (this.view == newValue) {
            return this;
        }
        return new BlockActions(this.triggerId, this.responseUrl, this.message, newValue, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withView(Optional<ViewResponseBase> optional) {
        ViewResponseBase value = optional.orElse(null);
        if (this.view == value) {
            return this;
        }
        return new BlockActions(this.triggerId, this.responseUrl, this.message, value, this.elementActions, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withElementActions(BlockElementAction ... elements) {
        List<BlockElementAction> newValue = BlockActions.createUnmodifiableList(false, BlockActions.createSafeList(Arrays.asList(elements), true, false));
        return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, newValue, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withElementActions(Iterable<? extends BlockElementAction> elements) {
        if (this.elementActions == elements) {
            return this;
        }
        List<BlockElementAction> newValue = BlockActions.createUnmodifiableList(false, BlockActions.createSafeList(elements, true, false));
        return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, newValue, this.type, this.token, this.team, this.user);
    }

    public final BlockActions withType(InteractiveCallbackType type) {
        if (this.type == type) {
            return this;
        }
        InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
        return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, this.elementActions, newValue, this.token, this.team, this.user);
    }

    public final BlockActions withToken(String token) {
        if (this.token.equals(token)) {
            return this;
        }
        String newValue = Objects.requireNonNull(token, "token");
        return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, this.elementActions, this.type, newValue, this.team, this.user);
    }

    public final BlockActions withTeam(SlackTeam team) {
        if (this.team == team) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(team, "team");
        return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, this.elementActions, this.type, this.token, newValue, this.user);
    }

    public final BlockActions withUser(SlackUserLite user) {
        if (this.user == user) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(user, "user");
        return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, this.elementActions, this.type, this.token, this.team, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BlockActions && this.equalTo((BlockActions)another);
    }

    private boolean equalTo(BlockActions another) {
        return this.triggerId.equals(another.triggerId) && Objects.equals(this.responseUrl, another.responseUrl) && Objects.equals(this.message, another.message) && Objects.equals(this.view, another.view) && this.elementActions.equals(another.elementActions) && this.type.equals((Object)another.type) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.triggerId.hashCode();
        h = h * 17 + Objects.hashCode(this.responseUrl);
        h = h * 17 + Objects.hashCode(this.message);
        h = h * 17 + Objects.hashCode(this.view);
        h = h * 17 + this.elementActions.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.user.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BlockActions{");
        builder.append("triggerId=").append(this.triggerId);
        if (this.responseUrl != null) {
            builder.append(", ");
            builder.append("responseUrl=").append(this.responseUrl);
        }
        if (this.message != null) {
            builder.append(", ");
            builder.append("message=").append(this.message);
        }
        if (this.view != null) {
            builder.append(", ");
            builder.append("view=").append(this.view);
        }
        builder.append(", ");
        builder.append("elementActions=").append(this.elementActions);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("token=").append(this.token);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("user=").append(this.user);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static BlockActions fromJson(Json json) {
        Builder builder = BlockActions.builder();
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.responseUrl != null) {
            builder.setResponseUrl(json.responseUrl);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.elementActions != null) {
            builder.addAllElementActions(json.elementActions);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        return builder.build();
    }

    public static BlockActions copyOf(BlockActionsIF instance) {
        if (instance instanceof BlockActions) {
            return (BlockActions)instance;
        }
        return BlockActions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRIGGER_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_TOKEN = 4L;
        private static final long INIT_BIT_TEAM = 8L;
        private static final long INIT_BIT_USER = 16L;
        private long initBits = 31L;
        @Nullable
        private String triggerId;
        @Nullable
        private String responseUrl;
        @Nullable
        private LiteMessage message;
        @Nullable
        private ViewResponseBase view;
        private List<BlockElementAction> elementActions = new ArrayList<BlockElementAction>();
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;

        private Builder() {
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BlockActionsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackInteractiveCallback instance;
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                this.setTeam(instance.getTeam());
                this.setType(instance.getType());
                this.setUser(instance.getUser());
                this.setToken(instance.getToken());
            }
            if (object instanceof BlockActionsIF) {
                Optional<LiteMessage> messageOptional;
                instance = (BlockActionsIF)object;
                Optional<String> responseUrlOptional = instance.getResponseUrl();
                if (responseUrlOptional.isPresent()) {
                    this.setResponseUrl(responseUrlOptional);
                }
                this.addAllElementActions(instance.getElementActions());
                Optional<ViewResponseBase> viewOptional = instance.getView();
                if (viewOptional.isPresent()) {
                    this.setView(viewOptional);
                }
                if ((messageOptional = instance.getMessage()).isPresent()) {
                    this.setMessage(messageOptional);
                }
                this.setTriggerId(instance.getTriggerId());
            }
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseUrl(@Nullable String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        public final Builder setResponseUrl(Optional<String> responseUrl) {
            this.responseUrl = responseUrl.orElse(null);
            return this;
        }

        public final Builder setMessage(@Nullable LiteMessage message) {
            this.message = message;
            return this;
        }

        public final Builder setMessage(Optional<LiteMessage> message) {
            this.message = message.orElse(null);
            return this;
        }

        public final Builder setView(@Nullable ViewResponseBase view) {
            this.view = view;
            return this;
        }

        public final Builder setView(Optional<ViewResponseBase> view) {
            this.view = view.orElse(null);
            return this;
        }

        public final Builder addElementActions(BlockElementAction element) {
            this.elementActions.add(Objects.requireNonNull(element, "elementActions element"));
            return this;
        }

        public final Builder addElementActions(BlockElementAction ... elements) {
            for (BlockElementAction element : elements) {
                this.elementActions.add(Objects.requireNonNull(element, "elementActions element"));
            }
            return this;
        }

        public final Builder setElementActions(Iterable<? extends BlockElementAction> elements) {
            this.elementActions.clear();
            return this.addAllElementActions(elements);
        }

        public final Builder addAllElementActions(Iterable<? extends BlockElementAction> elements) {
            for (BlockElementAction blockElementAction : elements) {
                this.elementActions.add(Objects.requireNonNull(blockElementAction, "elementActions element"));
            }
            return this;
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public BlockActions build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new BlockActions(this.triggerId, this.responseUrl, this.message, this.view, BlockActions.createUnmodifiableList(true, this.elementActions), this.type, this.token, this.team, this.user);
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            return "Cannot build BlockActions, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BlockActionsIF {
        @Nullable
        String triggerId;
        Optional<String> responseUrl = Optional.empty();
        Optional<LiteMessage> message = Optional.empty();
        Optional<ViewResponseBase> view = Optional.empty();
        List<BlockElementAction> elementActions = Collections.emptyList();
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;

        Json() {
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setResponseUrl(Optional<String> responseUrl) {
            this.responseUrl = responseUrl;
        }

        @JsonProperty
        public void setMessage(Optional<LiteMessage> message) {
            this.message = message;
        }

        @JsonProperty
        public void setView(Optional<ViewResponseBase> view) {
            this.view = view;
        }

        @JsonProperty(value="actions")
        public void setElementActions(List<BlockElementAction> elementActions) {
            this.elementActions = elementActions;
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getResponseUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ViewResponseBase> getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BlockElementAction> getElementActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }
    }
}

