/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelMetadata;
import com.hubspot.slack.client.models.Message;
import com.hubspot.slack.client.models.group.SlackGroupIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackGroup
implements SlackGroupIF {
    private final String id;
    private final String name;
    private final long createdEpochSeconds;
    private final String creatorId;
    private final boolean archived;
    private final boolean mpim;
    private final List<String> memberIds;
    private final ChannelMetadata topic;
    private final ChannelMetadata purpose;
    @Nullable
    private final Message latest;

    private SlackGroup(String id, String name, long createdEpochSeconds, String creatorId, boolean archived, boolean mpim, List<String> memberIds, ChannelMetadata topic, ChannelMetadata purpose, @Nullable Message latest) {
        this.id = id;
        this.name = name;
        this.createdEpochSeconds = createdEpochSeconds;
        this.creatorId = creatorId;
        this.archived = archived;
        this.mpim = mpim;
        this.memberIds = memberIds;
        this.topic = topic;
        this.purpose = purpose;
        this.latest = latest;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="created")
    public long getCreatedEpochSeconds() {
        return this.createdEpochSeconds;
    }

    @Override
    @JsonProperty(value="creator")
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    @JsonProperty(value="is_archived")
    public boolean isArchived() {
        return this.archived;
    }

    @Override
    @JsonProperty(value="is_mpim")
    public boolean isMpim() {
        return this.mpim;
    }

    @Override
    @JsonProperty(value="members")
    public List<String> getMemberIds() {
        return this.memberIds;
    }

    @Override
    @JsonProperty
    public ChannelMetadata getTopic() {
        return this.topic;
    }

    @Override
    @JsonProperty
    public ChannelMetadata getPurpose() {
        return this.purpose;
    }

    @Override
    @JsonProperty
    public Optional<Message> getLatest() {
        return Optional.ofNullable(this.latest);
    }

    public final SlackGroup withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackGroup(newValue, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return new SlackGroup(this.id, newValue, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withCreatedEpochSeconds(long createdEpochSeconds) {
        if (this.createdEpochSeconds == createdEpochSeconds) {
            return this;
        }
        return new SlackGroup(this.id, this.name, createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withCreatorId(String creatorId) {
        if (this.creatorId.equals(creatorId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(creatorId, "creatorId");
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, newValue, this.archived, this.mpim, this.memberIds, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withArchived(boolean archived) {
        if (this.archived == archived) {
            return this;
        }
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, archived, this.mpim, this.memberIds, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withMpim(boolean mpim) {
        if (this.mpim == mpim) {
            return this;
        }
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, mpim, this.memberIds, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withMemberIds(String ... elements) {
        List<String> newValue = SlackGroup.createUnmodifiableList(false, SlackGroup.createSafeList(Arrays.asList(elements), true, false));
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, newValue, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withMemberIds(Iterable<String> elements) {
        if (this.memberIds == elements) {
            return this;
        }
        List<String> newValue = SlackGroup.createUnmodifiableList(false, SlackGroup.createSafeList(elements, true, false));
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, newValue, this.topic, this.purpose, this.latest);
    }

    public final SlackGroup withTopic(ChannelMetadata topic) {
        if (this.topic == topic) {
            return this;
        }
        ChannelMetadata newValue = Objects.requireNonNull(topic, "topic");
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, newValue, this.purpose, this.latest);
    }

    public final SlackGroup withPurpose(ChannelMetadata purpose) {
        if (this.purpose == purpose) {
            return this;
        }
        ChannelMetadata newValue = Objects.requireNonNull(purpose, "purpose");
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, this.topic, newValue, this.latest);
    }

    public final SlackGroup withLatest(@Nullable Message value) {
        Message newValue = value;
        if (this.latest == newValue) {
            return this;
        }
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, this.topic, this.purpose, newValue);
    }

    public final SlackGroup withLatest(Optional<Message> optional) {
        Message value = optional.orElse(null);
        if (this.latest == value) {
            return this;
        }
        return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, this.memberIds, this.topic, this.purpose, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackGroup && this.equalTo((SlackGroup)another);
    }

    private boolean equalTo(SlackGroup another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.createdEpochSeconds == another.createdEpochSeconds && this.creatorId.equals(another.creatorId) && this.archived == another.archived && this.mpim == another.mpim && this.memberIds.equals(another.memberIds) && this.topic.equals(another.topic) && this.purpose.equals(another.purpose) && Objects.equals(this.latest, another.latest);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Long.hashCode(this.createdEpochSeconds);
        h = h * 17 + this.creatorId.hashCode();
        h = h * 17 + Boolean.hashCode(this.archived);
        h = h * 17 + Boolean.hashCode(this.mpim);
        h = h * 17 + this.memberIds.hashCode();
        h = h * 17 + this.topic.hashCode();
        h = h * 17 + this.purpose.hashCode();
        h = h * 17 + Objects.hashCode(this.latest);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackGroup{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("createdEpochSeconds=").append(this.createdEpochSeconds);
        builder.append(", ");
        builder.append("creatorId=").append(this.creatorId);
        builder.append(", ");
        builder.append("archived=").append(this.archived);
        builder.append(", ");
        builder.append("mpim=").append(this.mpim);
        builder.append(", ");
        builder.append("memberIds=").append(this.memberIds);
        builder.append(", ");
        builder.append("topic=").append(this.topic);
        builder.append(", ");
        builder.append("purpose=").append(this.purpose);
        if (this.latest != null) {
            builder.append(", ");
            builder.append("latest=").append(this.latest);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackGroup fromJson(Json json) {
        Builder builder = SlackGroup.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.createdEpochSecondsIsSet) {
            builder.setCreatedEpochSeconds(json.createdEpochSeconds);
        }
        if (json.creatorId != null) {
            builder.setCreatorId(json.creatorId);
        }
        if (json.archivedIsSet) {
            builder.setArchived(json.archived);
        }
        if (json.mpimIsSet) {
            builder.setMpim(json.mpim);
        }
        if (json.memberIds != null) {
            builder.addAllMemberIds(json.memberIds);
        }
        if (json.topic != null) {
            builder.setTopic(json.topic);
        }
        if (json.purpose != null) {
            builder.setPurpose(json.purpose);
        }
        if (json.latest != null) {
            builder.setLatest(json.latest);
        }
        return builder.build();
    }

    public static SlackGroup copyOf(SlackGroupIF instance) {
        if (instance instanceof SlackGroup) {
            return (SlackGroup)instance;
        }
        return SlackGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 4L;
        private static final long INIT_BIT_CREATOR_ID = 8L;
        private static final long INIT_BIT_ARCHIVED = 16L;
        private static final long INIT_BIT_MPIM = 32L;
        private static final long INIT_BIT_TOPIC = 64L;
        private static final long INIT_BIT_PURPOSE = 128L;
        private long initBits = 255L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private long createdEpochSeconds;
        @Nullable
        private String creatorId;
        private boolean archived;
        private boolean mpim;
        private List<String> memberIds = new ArrayList<String>();
        @Nullable
        private ChannelMetadata topic;
        @Nullable
        private ChannelMetadata purpose;
        @Nullable
        private Message latest;

        private Builder() {
        }

        public final Builder from(SlackGroupIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setName(instance.getName());
            this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
            this.setCreatorId(instance.getCreatorId());
            this.setArchived(instance.isArchived());
            this.setMpim(instance.isMpim());
            this.addAllMemberIds(instance.getMemberIds());
            this.setTopic(instance.getTopic());
            this.setPurpose(instance.getPurpose());
            Optional<Message> latestOptional = instance.getLatest();
            if (latestOptional.isPresent()) {
                this.setLatest(latestOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setCreatorId(String creatorId) {
            this.creatorId = Objects.requireNonNull(creatorId, "creatorId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setArchived(boolean archived) {
            this.archived = archived;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setMpim(boolean mpim) {
            this.mpim = mpim;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addMemberIds(String element) {
            this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
            return this;
        }

        public final Builder addMemberIds(String ... elements) {
            for (String element : elements) {
                this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
            }
            return this;
        }

        public final Builder setMemberIds(Iterable<String> elements) {
            this.memberIds.clear();
            return this.addAllMemberIds(elements);
        }

        public final Builder addAllMemberIds(Iterable<String> elements) {
            for (String element : elements) {
                this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
            }
            return this;
        }

        public final Builder setTopic(ChannelMetadata topic) {
            this.topic = Objects.requireNonNull(topic, "topic");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setPurpose(ChannelMetadata purpose) {
            this.purpose = Objects.requireNonNull(purpose, "purpose");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setLatest(@Nullable Message latest) {
            this.latest = latest;
            return this;
        }

        public final Builder setLatest(Optional<Message> latest) {
            this.latest = latest.orElse(null);
            return this;
        }

        public SlackGroup build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackGroup(this.id, this.name, this.createdEpochSeconds, this.creatorId, this.archived, this.mpim, SlackGroup.createUnmodifiableList(true, this.memberIds), this.topic, this.purpose, this.latest);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean createdEpochSecondsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean creatorIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean archivedIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean mpimIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean topicIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean purposeIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.createdEpochSecondsIsSet()) {
                attributes.add("createdEpochSeconds");
            }
            if (!this.creatorIdIsSet()) {
                attributes.add("creatorId");
            }
            if (!this.archivedIsSet()) {
                attributes.add("archived");
            }
            if (!this.mpimIsSet()) {
                attributes.add("mpim");
            }
            if (!this.topicIsSet()) {
                attributes.add("topic");
            }
            if (!this.purposeIsSet()) {
                attributes.add("purpose");
            }
            return "Cannot build SlackGroup, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackGroupIF {
        @Nullable
        String id;
        @Nullable
        String name;
        long createdEpochSeconds;
        boolean createdEpochSecondsIsSet;
        @Nullable
        String creatorId;
        boolean archived;
        boolean archivedIsSet;
        boolean mpim;
        boolean mpimIsSet;
        List<String> memberIds = Collections.emptyList();
        @Nullable
        ChannelMetadata topic;
        @Nullable
        ChannelMetadata purpose;
        Optional<Message> latest = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="created")
        public void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsIsSet = true;
        }

        @JsonProperty(value="creator")
        public void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @JsonProperty(value="is_archived")
        public void setArchived(boolean archived) {
            this.archived = archived;
            this.archivedIsSet = true;
        }

        @JsonProperty(value="is_mpim")
        public void setMpim(boolean mpim) {
            this.mpim = mpim;
            this.mpimIsSet = true;
        }

        @JsonProperty(value="members")
        public void setMemberIds(List<String> memberIds) {
            this.memberIds = memberIds;
        }

        @JsonProperty
        public void setTopic(ChannelMetadata topic) {
            this.topic = topic;
        }

        @JsonProperty
        public void setPurpose(ChannelMetadata purpose) {
            this.purpose = purpose;
        }

        @JsonProperty
        public void setLatest(Optional<Message> latest) {
            this.latest = latest;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMpim() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getMemberIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelMetadata getTopic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelMetadata getPurpose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Message> getLatest() {
            throw new UnsupportedOperationException();
        }
    }
}

