/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.files.SlackFileType;
import com.hubspot.slack.client.models.files.SlackImageFile;
import com.hubspot.slack.client.models.files.SlackJpgFileIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackJpgFile
implements SlackJpgFileIF {
    private final SlackFileType filetype;
    @Nullable
    private final String thumb64Url;
    @Nullable
    private final String thumb80Url;
    @Nullable
    private final String thumb160Url;
    @Nullable
    private final String thumb360Url;
    @Nullable
    private final Integer thumb360Width;
    @Nullable
    private final Integer thumb360Height;
    @Nullable
    private final String thumb480Url;
    @Nullable
    private final Integer thumb480Width;
    @Nullable
    private final Integer thumb480Height;
    @Nullable
    private final Integer imageExifRotation;
    @Nullable
    private final Integer originalWidth;
    @Nullable
    private final Integer originalHeight;
    private final boolean hasRichPreview;
    private final String id;
    private final long createdEpochSeconds;
    private final long timestampEpochSeconds;
    private final String name;
    private final String title;
    private final String mimetype;
    private final String prettyType;
    private final String userId;
    private final boolean editable;
    private final long size;
    private final String mode;
    private final boolean external;
    private final boolean isPublic;
    private final boolean publicUrlShared;
    private final boolean displayAsBot;
    private final String username;
    private final String urlPrivate;
    @Nullable
    private final String urlPrivateDownload;
    private final String permalink;
    @Nullable
    private final String permalinkPublic;
    private final int commentsCount;
    @Nullable
    private final Boolean starred;
    private final List<String> channelIds;
    private final List<String> groupIds;
    private final List<String> imIds;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackJpgFile(Builder builder) {
        this.thumb64Url = builder.thumb64Url;
        this.thumb80Url = builder.thumb80Url;
        this.thumb160Url = builder.thumb160Url;
        this.thumb360Url = builder.thumb360Url;
        this.thumb360Width = builder.thumb360Width;
        this.thumb360Height = builder.thumb360Height;
        this.thumb480Url = builder.thumb480Url;
        this.thumb480Width = builder.thumb480Width;
        this.thumb480Height = builder.thumb480Height;
        this.imageExifRotation = builder.imageExifRotation;
        this.originalWidth = builder.originalWidth;
        this.originalHeight = builder.originalHeight;
        this.hasRichPreview = builder.hasRichPreview;
        this.id = builder.id;
        this.createdEpochSeconds = builder.createdEpochSeconds;
        this.timestampEpochSeconds = builder.timestampEpochSeconds;
        this.name = builder.name;
        this.title = builder.title;
        this.mimetype = builder.mimetype;
        this.prettyType = builder.prettyType;
        this.userId = builder.userId;
        this.editable = builder.editable;
        this.size = builder.size;
        this.mode = builder.mode;
        this.external = builder.external;
        this.isPublic = builder.isPublic;
        this.publicUrlShared = builder.publicUrlShared;
        this.displayAsBot = builder.displayAsBot;
        this.username = builder.username;
        this.urlPrivate = builder.urlPrivate;
        this.urlPrivateDownload = builder.urlPrivateDownload;
        this.permalink = builder.permalink;
        this.permalinkPublic = builder.permalinkPublic;
        this.starred = builder.starred;
        this.channelIds = SlackJpgFile.createUnmodifiableList(true, builder.channelIds);
        this.groupIds = SlackJpgFile.createUnmodifiableList(true, builder.groupIds);
        this.imIds = SlackJpgFile.createUnmodifiableList(true, builder.imIds);
        if (builder.filetype != null) {
            this.initShim.setFiletype(builder.filetype);
        }
        if (builder.commentsCountIsSet()) {
            this.initShim.setCommentsCount(builder.commentsCount);
        }
        this.filetype = this.initShim.getFiletype();
        this.commentsCount = this.initShim.getCommentsCount();
        this.initShim = null;
    }

    private SlackJpgFile(SlackFileType filetype, @Nullable String thumb64Url, @Nullable String thumb80Url, @Nullable String thumb160Url, @Nullable String thumb360Url, @Nullable Integer thumb360Width, @Nullable Integer thumb360Height, @Nullable String thumb480Url, @Nullable Integer thumb480Width, @Nullable Integer thumb480Height, @Nullable Integer imageExifRotation, @Nullable Integer originalWidth, @Nullable Integer originalHeight, boolean hasRichPreview, String id, long createdEpochSeconds, long timestampEpochSeconds, String name, String title, String mimetype, String prettyType, String userId, boolean editable, long size, String mode, boolean external, boolean isPublic, boolean publicUrlShared, boolean displayAsBot, String username, String urlPrivate, @Nullable String urlPrivateDownload, String permalink, @Nullable String permalinkPublic, int commentsCount, @Nullable Boolean starred, List<String> channelIds, List<String> groupIds, List<String> imIds) {
        this.filetype = filetype;
        this.thumb64Url = thumb64Url;
        this.thumb80Url = thumb80Url;
        this.thumb160Url = thumb160Url;
        this.thumb360Url = thumb360Url;
        this.thumb360Width = thumb360Width;
        this.thumb360Height = thumb360Height;
        this.thumb480Url = thumb480Url;
        this.thumb480Width = thumb480Width;
        this.thumb480Height = thumb480Height;
        this.imageExifRotation = imageExifRotation;
        this.originalWidth = originalWidth;
        this.originalHeight = originalHeight;
        this.hasRichPreview = hasRichPreview;
        this.id = id;
        this.createdEpochSeconds = createdEpochSeconds;
        this.timestampEpochSeconds = timestampEpochSeconds;
        this.name = name;
        this.title = title;
        this.mimetype = mimetype;
        this.prettyType = prettyType;
        this.userId = userId;
        this.editable = editable;
        this.size = size;
        this.mode = mode;
        this.external = external;
        this.isPublic = isPublic;
        this.publicUrlShared = publicUrlShared;
        this.displayAsBot = displayAsBot;
        this.username = username;
        this.urlPrivate = urlPrivate;
        this.urlPrivateDownload = urlPrivateDownload;
        this.permalink = permalink;
        this.permalinkPublic = permalinkPublic;
        this.commentsCount = commentsCount;
        this.starred = starred;
        this.channelIds = channelIds;
        this.groupIds = groupIds;
        this.imIds = imIds;
        this.initShim = null;
    }

    private SlackFileType getFiletypeInitialize() {
        return SlackJpgFileIF.super.getFiletype();
    }

    private int getCommentsCountInitialize() {
        return SlackJpgFileIF.super.getCommentsCount();
    }

    @Override
    @JsonProperty
    public SlackFileType getFiletype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFiletype() : this.filetype;
    }

    @Override
    @JsonProperty(value="thumb_64")
    public Optional<String> getThumb64Url() {
        return Optional.ofNullable(this.thumb64Url);
    }

    @Override
    @JsonProperty(value="thumb_80")
    public Optional<String> getThumb80Url() {
        return Optional.ofNullable(this.thumb80Url);
    }

    @Override
    @JsonProperty(value="thumb_160")
    public Optional<String> getThumb160Url() {
        return Optional.ofNullable(this.thumb160Url);
    }

    @Override
    @JsonProperty(value="thumb_360")
    public Optional<String> getThumb360Url() {
        return Optional.ofNullable(this.thumb360Url);
    }

    @Override
    @JsonProperty(value="thumb_360_w")
    public Optional<Integer> getThumb360Width() {
        return Optional.ofNullable(this.thumb360Width);
    }

    @Override
    @JsonProperty(value="thumb_360_h")
    public Optional<Integer> getThumb360Height() {
        return Optional.ofNullable(this.thumb360Height);
    }

    @Override
    @JsonProperty(value="thumb_480")
    public Optional<String> getThumb480Url() {
        return Optional.ofNullable(this.thumb480Url);
    }

    @Override
    @JsonProperty(value="thumb_480_w")
    public Optional<Integer> getThumb480Width() {
        return Optional.ofNullable(this.thumb480Width);
    }

    @Override
    @JsonProperty(value="thumb_480_h")
    public Optional<Integer> getThumb480Height() {
        return Optional.ofNullable(this.thumb480Height);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getImageExifRotation() {
        return Optional.ofNullable(this.imageExifRotation);
    }

    @Override
    @JsonProperty(value="original_w")
    public Optional<Integer> getOriginalWidth() {
        return Optional.ofNullable(this.originalWidth);
    }

    @Override
    @JsonProperty(value="original_h")
    public Optional<Integer> getOriginalHeight() {
        return Optional.ofNullable(this.originalHeight);
    }

    @Override
    @JsonProperty(value="has_rich_preview")
    public boolean hasRichPreview() {
        return this.hasRichPreview;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created")
    public long getCreatedEpochSeconds() {
        return this.createdEpochSeconds;
    }

    @Override
    @JsonProperty(value="timestamp")
    public long getTimestampEpochSeconds() {
        return this.timestampEpochSeconds;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    @JsonProperty
    public String getPrettyType() {
        return this.prettyType;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @Override
    @JsonProperty
    public String getMode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="is_external")
    public boolean isExternal() {
        return this.external;
    }

    @Override
    @JsonProperty(value="is_public")
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    @JsonProperty
    public boolean isPublicUrlShared() {
        return this.publicUrlShared;
    }

    @Override
    @JsonProperty
    public boolean getDisplayAsBot() {
        return this.displayAsBot;
    }

    @Override
    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty
    public String getUrlPrivate() {
        return this.urlPrivate;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrlPrivateDownload() {
        return Optional.ofNullable(this.urlPrivateDownload);
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        return this.permalink;
    }

    @Override
    @JsonProperty
    public Optional<String> getPermalinkPublic() {
        return Optional.ofNullable(this.permalinkPublic);
    }

    @Override
    @JsonProperty
    public int getCommentsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommentsCount() : this.commentsCount;
    }

    @Override
    @JsonProperty(value="is_starred")
    public Optional<Boolean> isStarred() {
        return Optional.ofNullable(this.starred);
    }

    @Override
    @JsonProperty(value="channels")
    public List<String> getChannelIds() {
        return this.channelIds;
    }

    @Override
    @JsonProperty(value="groups")
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    @JsonProperty(value="ims")
    public List<String> getImIds() {
        return this.imIds;
    }

    public final SlackJpgFile withFiletype(SlackFileType filetype) {
        if (this.filetype == filetype) {
            return this;
        }
        SlackFileType newValue = Objects.requireNonNull(filetype, "filetype");
        return new SlackJpgFile(newValue, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb64Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb64Url, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, newValue, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb64Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb64Url, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, value, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb80Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb80Url, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, newValue, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb80Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb80Url, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, value, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb160Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb160Url, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, newValue, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb160Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb160Url, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, value, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb360Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb360Url, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, newValue, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb360Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb360Url, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, value, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb360Width(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb360Width, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, newValue, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb360Width(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb360Width, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, value, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb360Height(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb360Height, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, newValue, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb360Height(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb360Height, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, value, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb480Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb480Url, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, newValue, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb480Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb480Url, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, value, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb480Width(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb480Width, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, newValue, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb480Width(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb480Width, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, value, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb480Height(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb480Height, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, newValue, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withThumb480Height(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb480Height, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, value, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withImageExifRotation(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.imageExifRotation, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, newValue, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withImageExifRotation(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.imageExifRotation, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, value, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withOriginalWidth(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.originalWidth, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, newValue, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withOriginalWidth(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.originalWidth, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, value, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withOriginalHeight(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.originalHeight, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, newValue, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withOriginalHeight(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.originalHeight, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, value, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withHasRichPreview(boolean hasRichPreview) {
        if (this.hasRichPreview == hasRichPreview) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, newValue, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withCreatedEpochSeconds(long createdEpochSeconds) {
        if (this.createdEpochSeconds == createdEpochSeconds) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withTimestampEpochSeconds(long timestampEpochSeconds) {
        if (this.timestampEpochSeconds == timestampEpochSeconds) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Objects.requireNonNull(name, "name");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, newValue, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withTitle(String title) {
        if (this.title.equals(title)) {
            return this;
        }
        String newValue = Objects.requireNonNull(title, "title");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, newValue, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withMimetype(String mimetype) {
        if (this.mimetype.equals(mimetype)) {
            return this;
        }
        String newValue = Objects.requireNonNull(mimetype, "mimetype");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, newValue, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withPrettyType(String prettyType) {
        if (this.prettyType.equals(prettyType)) {
            return this;
        }
        String newValue = Objects.requireNonNull(prettyType, "prettyType");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, newValue, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, newValue, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withEditable(boolean editable) {
        if (this.editable == editable) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withSize(long size) {
        if (this.size == size) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withMode(String mode) {
        if (this.mode.equals(mode)) {
            return this;
        }
        String newValue = Objects.requireNonNull(mode, "mode");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, newValue, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withExternal(boolean external) {
        if (this.external == external) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withIsPublic(boolean isPublic) {
        if (this.isPublic == isPublic) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withPublicUrlShared(boolean publicUrlShared) {
        if (this.publicUrlShared == publicUrlShared) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withDisplayAsBot(boolean displayAsBot) {
        if (this.displayAsBot == displayAsBot) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withUsername(String username) {
        if (this.username.equals(username)) {
            return this;
        }
        String newValue = Objects.requireNonNull(username, "username");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, newValue, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withUrlPrivate(String urlPrivate) {
        if (this.urlPrivate.equals(urlPrivate)) {
            return this;
        }
        String newValue = Objects.requireNonNull(urlPrivate, "urlPrivate");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, newValue, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withUrlPrivateDownload(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.urlPrivateDownload, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, newValue, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withUrlPrivateDownload(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.urlPrivateDownload, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, value, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withPermalink(String permalink) {
        if (this.permalink.equals(permalink)) {
            return this;
        }
        String newValue = Objects.requireNonNull(permalink, "permalink");
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, newValue, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withPermalinkPublic(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.permalinkPublic, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, newValue, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withPermalinkPublic(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.permalinkPublic, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, value, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withCommentsCount(int commentsCount) {
        if (this.commentsCount == commentsCount) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withStarred(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.starred, newValue)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, newValue, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withStarred(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.starred, value)) {
            return this;
        }
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, value, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withChannelIds(String ... elements) {
        List<String> newValue = SlackJpgFile.createUnmodifiableList(false, SlackJpgFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withChannelIds(Iterable<String> elements) {
        if (this.channelIds == elements) {
            return this;
        }
        List<String> newValue = SlackJpgFile.createUnmodifiableList(false, SlackJpgFile.createSafeList(elements, true, false));
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackJpgFile withGroupIds(String ... elements) {
        List<String> newValue = SlackJpgFile.createUnmodifiableList(false, SlackJpgFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackJpgFile withGroupIds(Iterable<String> elements) {
        if (this.groupIds == elements) {
            return this;
        }
        List<String> newValue = SlackJpgFile.createUnmodifiableList(false, SlackJpgFile.createSafeList(elements, true, false));
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackJpgFile withImIds(String ... elements) {
        List<String> newValue = SlackJpgFile.createUnmodifiableList(false, SlackJpgFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public final SlackJpgFile withImIds(Iterable<String> elements) {
        if (this.imIds == elements) {
            return this;
        }
        List<String> newValue = SlackJpgFile.createUnmodifiableList(false, SlackJpgFile.createSafeList(elements, true, false));
        return new SlackJpgFile(this.filetype, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackJpgFile && this.equalTo((SlackJpgFile)another);
    }

    private boolean equalTo(SlackJpgFile another) {
        return this.filetype.equals((Object)another.filetype) && Objects.equals(this.thumb64Url, another.thumb64Url) && Objects.equals(this.thumb80Url, another.thumb80Url) && Objects.equals(this.thumb160Url, another.thumb160Url) && Objects.equals(this.thumb360Url, another.thumb360Url) && Objects.equals(this.thumb360Width, another.thumb360Width) && Objects.equals(this.thumb360Height, another.thumb360Height) && Objects.equals(this.thumb480Url, another.thumb480Url) && Objects.equals(this.thumb480Width, another.thumb480Width) && Objects.equals(this.thumb480Height, another.thumb480Height) && Objects.equals(this.imageExifRotation, another.imageExifRotation) && Objects.equals(this.originalWidth, another.originalWidth) && Objects.equals(this.originalHeight, another.originalHeight) && this.hasRichPreview == another.hasRichPreview && this.id.equals(another.id) && this.createdEpochSeconds == another.createdEpochSeconds && this.timestampEpochSeconds == another.timestampEpochSeconds && this.name.equals(another.name) && this.title.equals(another.title) && this.mimetype.equals(another.mimetype) && this.prettyType.equals(another.prettyType) && this.userId.equals(another.userId) && this.editable == another.editable && this.size == another.size && this.mode.equals(another.mode) && this.external == another.external && this.isPublic == another.isPublic && this.publicUrlShared == another.publicUrlShared && this.displayAsBot == another.displayAsBot && this.username.equals(another.username) && this.urlPrivate.equals(another.urlPrivate) && Objects.equals(this.urlPrivateDownload, another.urlPrivateDownload) && this.permalink.equals(another.permalink) && Objects.equals(this.permalinkPublic, another.permalinkPublic) && this.commentsCount == another.commentsCount && Objects.equals(this.starred, another.starred) && this.channelIds.equals(another.channelIds) && this.groupIds.equals(another.groupIds) && this.imIds.equals(another.imIds);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.filetype.hashCode();
        h = h * 17 + Objects.hashCode(this.thumb64Url);
        h = h * 17 + Objects.hashCode(this.thumb80Url);
        h = h * 17 + Objects.hashCode(this.thumb160Url);
        h = h * 17 + Objects.hashCode(this.thumb360Url);
        h = h * 17 + Objects.hashCode(this.thumb360Width);
        h = h * 17 + Objects.hashCode(this.thumb360Height);
        h = h * 17 + Objects.hashCode(this.thumb480Url);
        h = h * 17 + Objects.hashCode(this.thumb480Width);
        h = h * 17 + Objects.hashCode(this.thumb480Height);
        h = h * 17 + Objects.hashCode(this.imageExifRotation);
        h = h * 17 + Objects.hashCode(this.originalWidth);
        h = h * 17 + Objects.hashCode(this.originalHeight);
        h = h * 17 + Boolean.hashCode(this.hasRichPreview);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Long.hashCode(this.createdEpochSeconds);
        h = h * 17 + Long.hashCode(this.timestampEpochSeconds);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.mimetype.hashCode();
        h = h * 17 + this.prettyType.hashCode();
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + Boolean.hashCode(this.editable);
        h = h * 17 + Long.hashCode(this.size);
        h = h * 17 + this.mode.hashCode();
        h = h * 17 + Boolean.hashCode(this.external);
        h = h * 17 + Boolean.hashCode(this.isPublic);
        h = h * 17 + Boolean.hashCode(this.publicUrlShared);
        h = h * 17 + Boolean.hashCode(this.displayAsBot);
        h = h * 17 + this.username.hashCode();
        h = h * 17 + this.urlPrivate.hashCode();
        h = h * 17 + Objects.hashCode(this.urlPrivateDownload);
        h = h * 17 + this.permalink.hashCode();
        h = h * 17 + Objects.hashCode(this.permalinkPublic);
        h = h * 17 + this.commentsCount;
        h = h * 17 + Objects.hashCode(this.starred);
        h = h * 17 + this.channelIds.hashCode();
        h = h * 17 + this.groupIds.hashCode();
        h = h * 17 + this.imIds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackJpgFile{");
        builder.append("filetype=").append((Object)this.filetype);
        if (this.thumb64Url != null) {
            builder.append(", ");
            builder.append("thumb64Url=").append(this.thumb64Url);
        }
        if (this.thumb80Url != null) {
            builder.append(", ");
            builder.append("thumb80Url=").append(this.thumb80Url);
        }
        if (this.thumb160Url != null) {
            builder.append(", ");
            builder.append("thumb160Url=").append(this.thumb160Url);
        }
        if (this.thumb360Url != null) {
            builder.append(", ");
            builder.append("thumb360Url=").append(this.thumb360Url);
        }
        if (this.thumb360Width != null) {
            builder.append(", ");
            builder.append("thumb360Width=").append(this.thumb360Width);
        }
        if (this.thumb360Height != null) {
            builder.append(", ");
            builder.append("thumb360Height=").append(this.thumb360Height);
        }
        if (this.thumb480Url != null) {
            builder.append(", ");
            builder.append("thumb480Url=").append(this.thumb480Url);
        }
        if (this.thumb480Width != null) {
            builder.append(", ");
            builder.append("thumb480Width=").append(this.thumb480Width);
        }
        if (this.thumb480Height != null) {
            builder.append(", ");
            builder.append("thumb480Height=").append(this.thumb480Height);
        }
        if (this.imageExifRotation != null) {
            builder.append(", ");
            builder.append("imageExifRotation=").append(this.imageExifRotation);
        }
        if (this.originalWidth != null) {
            builder.append(", ");
            builder.append("originalWidth=").append(this.originalWidth);
        }
        if (this.originalHeight != null) {
            builder.append(", ");
            builder.append("originalHeight=").append(this.originalHeight);
        }
        builder.append(", ");
        builder.append("hasRichPreview=").append(this.hasRichPreview);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("createdEpochSeconds=").append(this.createdEpochSeconds);
        builder.append(", ");
        builder.append("timestampEpochSeconds=").append(this.timestampEpochSeconds);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("mimetype=").append(this.mimetype);
        builder.append(", ");
        builder.append("prettyType=").append(this.prettyType);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("editable=").append(this.editable);
        builder.append(", ");
        builder.append("size=").append(this.size);
        builder.append(", ");
        builder.append("mode=").append(this.mode);
        builder.append(", ");
        builder.append("external=").append(this.external);
        builder.append(", ");
        builder.append("isPublic=").append(this.isPublic);
        builder.append(", ");
        builder.append("publicUrlShared=").append(this.publicUrlShared);
        builder.append(", ");
        builder.append("displayAsBot=").append(this.displayAsBot);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("urlPrivate=").append(this.urlPrivate);
        if (this.urlPrivateDownload != null) {
            builder.append(", ");
            builder.append("urlPrivateDownload=").append(this.urlPrivateDownload);
        }
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        if (this.permalinkPublic != null) {
            builder.append(", ");
            builder.append("permalinkPublic=").append(this.permalinkPublic);
        }
        builder.append(", ");
        builder.append("commentsCount=").append(this.commentsCount);
        if (this.starred != null) {
            builder.append(", ");
            builder.append("starred=").append(this.starred);
        }
        builder.append(", ");
        builder.append("channelIds=").append(this.channelIds);
        builder.append(", ");
        builder.append("groupIds=").append(this.groupIds);
        builder.append(", ");
        builder.append("imIds=").append(this.imIds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackJpgFile fromJson(Json json) {
        Builder builder = SlackJpgFile.builder();
        if (json.filetype != null) {
            builder.setFiletype(json.filetype);
        }
        if (json.thumb64Url != null) {
            builder.setThumb64Url(json.thumb64Url);
        }
        if (json.thumb80Url != null) {
            builder.setThumb80Url(json.thumb80Url);
        }
        if (json.thumb160Url != null) {
            builder.setThumb160Url(json.thumb160Url);
        }
        if (json.thumb360Url != null) {
            builder.setThumb360Url(json.thumb360Url);
        }
        if (json.thumb360Width != null) {
            builder.setThumb360Width(json.thumb360Width);
        }
        if (json.thumb360Height != null) {
            builder.setThumb360Height(json.thumb360Height);
        }
        if (json.thumb480Url != null) {
            builder.setThumb480Url(json.thumb480Url);
        }
        if (json.thumb480Width != null) {
            builder.setThumb480Width(json.thumb480Width);
        }
        if (json.thumb480Height != null) {
            builder.setThumb480Height(json.thumb480Height);
        }
        if (json.imageExifRotation != null) {
            builder.setImageExifRotation(json.imageExifRotation);
        }
        if (json.originalWidth != null) {
            builder.setOriginalWidth(json.originalWidth);
        }
        if (json.originalHeight != null) {
            builder.setOriginalHeight(json.originalHeight);
        }
        if (json.hasRichPreviewIsSet) {
            builder.setHasRichPreview(json.hasRichPreview);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.createdEpochSecondsIsSet) {
            builder.setCreatedEpochSeconds(json.createdEpochSeconds);
        }
        if (json.timestampEpochSecondsIsSet) {
            builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.mimetype != null) {
            builder.setMimetype(json.mimetype);
        }
        if (json.prettyType != null) {
            builder.setPrettyType(json.prettyType);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.editableIsSet) {
            builder.setEditable(json.editable);
        }
        if (json.sizeIsSet) {
            builder.setSize(json.size);
        }
        if (json.mode != null) {
            builder.setMode(json.mode);
        }
        if (json.externalIsSet) {
            builder.setExternal(json.external);
        }
        if (json.isPublicIsSet) {
            builder.setIsPublic(json.isPublic);
        }
        if (json.publicUrlSharedIsSet) {
            builder.setPublicUrlShared(json.publicUrlShared);
        }
        if (json.displayAsBotIsSet) {
            builder.setDisplayAsBot(json.displayAsBot);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.urlPrivate != null) {
            builder.setUrlPrivate(json.urlPrivate);
        }
        if (json.urlPrivateDownload != null) {
            builder.setUrlPrivateDownload(json.urlPrivateDownload);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.permalinkPublic != null) {
            builder.setPermalinkPublic(json.permalinkPublic);
        }
        if (json.commentsCountIsSet) {
            builder.setCommentsCount(json.commentsCount);
        }
        if (json.starred != null) {
            builder.setStarred(json.starred);
        }
        if (json.channelIds != null) {
            builder.addAllChannelIds(json.channelIds);
        }
        if (json.groupIds != null) {
            builder.addAllGroupIds(json.groupIds);
        }
        if (json.imIds != null) {
            builder.addAllImIds(json.imIds);
        }
        return builder.build();
    }

    public static SlackJpgFile copyOf(SlackJpgFileIF instance) {
        if (instance instanceof SlackJpgFile) {
            return (SlackJpgFile)instance;
        }
        return SlackJpgFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HAS_RICH_PREVIEW = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 4L;
        private static final long INIT_BIT_TIMESTAMP_EPOCH_SECONDS = 8L;
        private static final long INIT_BIT_NAME = 16L;
        private static final long INIT_BIT_TITLE = 32L;
        private static final long INIT_BIT_MIMETYPE = 64L;
        private static final long INIT_BIT_PRETTY_TYPE = 128L;
        private static final long INIT_BIT_USER_ID = 256L;
        private static final long INIT_BIT_EDITABLE = 512L;
        private static final long INIT_BIT_SIZE = 1024L;
        private static final long INIT_BIT_MODE = 2048L;
        private static final long INIT_BIT_EXTERNAL = 4096L;
        private static final long INIT_BIT_IS_PUBLIC = 8192L;
        private static final long INIT_BIT_PUBLIC_URL_SHARED = 16384L;
        private static final long INIT_BIT_DISPLAY_AS_BOT = 32768L;
        private static final long INIT_BIT_USERNAME = 65536L;
        private static final long INIT_BIT_URL_PRIVATE = 131072L;
        private static final long INIT_BIT_PERMALINK = 262144L;
        private static final long OPT_BIT_COMMENTS_COUNT = 1L;
        private long initBits = 524287L;
        private long optBits;
        @Nullable
        private SlackFileType filetype;
        @Nullable
        private String thumb64Url;
        @Nullable
        private String thumb80Url;
        @Nullable
        private String thumb160Url;
        @Nullable
        private String thumb360Url;
        @Nullable
        private Integer thumb360Width;
        @Nullable
        private Integer thumb360Height;
        @Nullable
        private String thumb480Url;
        @Nullable
        private Integer thumb480Width;
        @Nullable
        private Integer thumb480Height;
        @Nullable
        private Integer imageExifRotation;
        @Nullable
        private Integer originalWidth;
        @Nullable
        private Integer originalHeight;
        private boolean hasRichPreview;
        @Nullable
        private String id;
        private long createdEpochSeconds;
        private long timestampEpochSeconds;
        @Nullable
        private String name;
        @Nullable
        private String title;
        @Nullable
        private String mimetype;
        @Nullable
        private String prettyType;
        @Nullable
        private String userId;
        private boolean editable;
        private long size;
        @Nullable
        private String mode;
        private boolean external;
        private boolean isPublic;
        private boolean publicUrlShared;
        private boolean displayAsBot;
        @Nullable
        private String username;
        @Nullable
        private String urlPrivate;
        @Nullable
        private String urlPrivateDownload;
        @Nullable
        private String permalink;
        @Nullable
        private String permalinkPublic;
        private int commentsCount;
        @Nullable
        private Boolean starred;
        private List<String> channelIds = new ArrayList<String>();
        private List<String> groupIds = new ArrayList<String>();
        private List<String> imIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(SlackJpgFileIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackImageFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackFile instance;
            long bits = 0L;
            if (object instanceof SlackJpgFileIF) {
                instance = (SlackJpgFileIF)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackFile) {
                instance = (SlackFile)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                this.setTitle(instance.getTitle());
                this.setDisplayAsBot(instance.getDisplayAsBot());
                this.addAllImIds(instance.getImIds());
                Optional<String> urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                if (urlPrivateDownloadOptional.isPresent()) {
                    this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                }
                this.setMode(instance.getMode());
                Optional<Boolean> starredOptional = instance.isStarred();
                if (starredOptional.isPresent()) {
                    this.setStarred(starredOptional);
                }
                this.setUrlPrivate(instance.getUrlPrivate());
                this.setPrettyType(instance.getPrettyType());
                this.addAllGroupIds(instance.getGroupIds());
                this.setPublicUrlShared(instance.isPublicUrlShared());
                this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                this.setIsPublic(instance.isPublic());
                this.setId(instance.getId());
                this.addAllChannelIds(instance.getChannelIds());
                this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                this.setEditable(instance.isEditable());
                this.setUserId(instance.getUserId());
                this.setExternal(instance.isExternal());
                this.setSize(instance.getSize());
                this.setCommentsCount(instance.getCommentsCount());
                this.setName(instance.getName());
                this.setMimetype(instance.getMimetype());
                Optional<String> permalinkPublicOptional = instance.getPermalinkPublic();
                if (permalinkPublicOptional.isPresent()) {
                    this.setPermalinkPublic(permalinkPublicOptional);
                }
                this.setPermalink(instance.getPermalink());
                this.setUsername(instance.getUsername());
            }
            if (object instanceof SlackImageFile) {
                Optional<Integer> thumb360WidthOptional;
                Optional<Integer> thumb480WidthOptional;
                Optional<String> thumb160UrlOptional;
                Optional<String> thumb480UrlOptional;
                Optional<String> thumb360UrlOptional;
                Optional<Integer> originalWidthOptional;
                Optional<Integer> imageExifRotationOptional;
                Optional<Integer> thumb360HeightOptional;
                Optional<String> thumb64UrlOptional;
                Optional<Integer> thumb480HeightOptional;
                instance = (SlackImageFile)object;
                Optional<Integer> originalHeightOptional = instance.getOriginalHeight();
                if (originalHeightOptional.isPresent()) {
                    this.setOriginalHeight(originalHeightOptional);
                }
                if ((thumb480HeightOptional = instance.getThumb480Height()).isPresent()) {
                    this.setThumb480Height(thumb480HeightOptional);
                }
                if ((thumb64UrlOptional = instance.getThumb64Url()).isPresent()) {
                    this.setThumb64Url(thumb64UrlOptional);
                }
                if ((thumb360HeightOptional = instance.getThumb360Height()).isPresent()) {
                    this.setThumb360Height(thumb360HeightOptional);
                }
                this.setHasRichPreview(instance.hasRichPreview());
                Optional<String> thumb80UrlOptional = instance.getThumb80Url();
                if (thumb80UrlOptional.isPresent()) {
                    this.setThumb80Url(thumb80UrlOptional);
                }
                if ((imageExifRotationOptional = instance.getImageExifRotation()).isPresent()) {
                    this.setImageExifRotation(imageExifRotationOptional);
                }
                if ((originalWidthOptional = instance.getOriginalWidth()).isPresent()) {
                    this.setOriginalWidth(originalWidthOptional);
                }
                if ((thumb360UrlOptional = instance.getThumb360Url()).isPresent()) {
                    this.setThumb360Url(thumb360UrlOptional);
                }
                if ((thumb480UrlOptional = instance.getThumb480Url()).isPresent()) {
                    this.setThumb480Url(thumb480UrlOptional);
                }
                if ((thumb160UrlOptional = instance.getThumb160Url()).isPresent()) {
                    this.setThumb160Url(thumb160UrlOptional);
                }
                if ((thumb480WidthOptional = instance.getThumb480Width()).isPresent()) {
                    this.setThumb480Width(thumb480WidthOptional);
                }
                if ((thumb360WidthOptional = instance.getThumb360Width()).isPresent()) {
                    this.setThumb360Width(thumb360WidthOptional);
                }
            }
        }

        public final Builder setFiletype(SlackFileType filetype) {
            this.filetype = Objects.requireNonNull(filetype, "filetype");
            return this;
        }

        public final Builder setThumb64Url(@Nullable String thumb64Url) {
            this.thumb64Url = thumb64Url;
            return this;
        }

        public final Builder setThumb64Url(Optional<String> thumb64Url) {
            this.thumb64Url = thumb64Url.orElse(null);
            return this;
        }

        public final Builder setThumb80Url(@Nullable String thumb80Url) {
            this.thumb80Url = thumb80Url;
            return this;
        }

        public final Builder setThumb80Url(Optional<String> thumb80Url) {
            this.thumb80Url = thumb80Url.orElse(null);
            return this;
        }

        public final Builder setThumb160Url(@Nullable String thumb160Url) {
            this.thumb160Url = thumb160Url;
            return this;
        }

        public final Builder setThumb160Url(Optional<String> thumb160Url) {
            this.thumb160Url = thumb160Url.orElse(null);
            return this;
        }

        public final Builder setThumb360Url(@Nullable String thumb360Url) {
            this.thumb360Url = thumb360Url;
            return this;
        }

        public final Builder setThumb360Url(Optional<String> thumb360Url) {
            this.thumb360Url = thumb360Url.orElse(null);
            return this;
        }

        public final Builder setThumb360Width(@Nullable Integer thumb360Width) {
            this.thumb360Width = thumb360Width;
            return this;
        }

        public final Builder setThumb360Width(Optional<Integer> thumb360Width) {
            this.thumb360Width = thumb360Width.orElse(null);
            return this;
        }

        public final Builder setThumb360Height(@Nullable Integer thumb360Height) {
            this.thumb360Height = thumb360Height;
            return this;
        }

        public final Builder setThumb360Height(Optional<Integer> thumb360Height) {
            this.thumb360Height = thumb360Height.orElse(null);
            return this;
        }

        public final Builder setThumb480Url(@Nullable String thumb480Url) {
            this.thumb480Url = thumb480Url;
            return this;
        }

        public final Builder setThumb480Url(Optional<String> thumb480Url) {
            this.thumb480Url = thumb480Url.orElse(null);
            return this;
        }

        public final Builder setThumb480Width(@Nullable Integer thumb480Width) {
            this.thumb480Width = thumb480Width;
            return this;
        }

        public final Builder setThumb480Width(Optional<Integer> thumb480Width) {
            this.thumb480Width = thumb480Width.orElse(null);
            return this;
        }

        public final Builder setThumb480Height(@Nullable Integer thumb480Height) {
            this.thumb480Height = thumb480Height;
            return this;
        }

        public final Builder setThumb480Height(Optional<Integer> thumb480Height) {
            this.thumb480Height = thumb480Height.orElse(null);
            return this;
        }

        public final Builder setImageExifRotation(@Nullable Integer imageExifRotation) {
            this.imageExifRotation = imageExifRotation;
            return this;
        }

        public final Builder setImageExifRotation(Optional<Integer> imageExifRotation) {
            this.imageExifRotation = imageExifRotation.orElse(null);
            return this;
        }

        public final Builder setOriginalWidth(@Nullable Integer originalWidth) {
            this.originalWidth = originalWidth;
            return this;
        }

        public final Builder setOriginalWidth(Optional<Integer> originalWidth) {
            this.originalWidth = originalWidth.orElse(null);
            return this;
        }

        public final Builder setOriginalHeight(@Nullable Integer originalHeight) {
            this.originalHeight = originalHeight;
            return this;
        }

        public final Builder setOriginalHeight(Optional<Integer> originalHeight) {
            this.originalHeight = originalHeight.orElse(null);
            return this;
        }

        public final Builder setHasRichPreview(boolean hasRichPreview) {
            this.hasRichPreview = hasRichPreview;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setMimetype(String mimetype) {
            this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setPrettyType(String prettyType) {
            this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setEditable(boolean editable) {
            this.editable = editable;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder setSize(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder setMode(String mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder setExternal(boolean external) {
            this.external = external;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        public final Builder setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public final Builder setUsername(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public final Builder setUrlPrivate(String urlPrivate) {
            this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
            return this;
        }

        public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload.orElse(null);
            return this;
        }

        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
            return this;
        }

        public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic.orElse(null);
            return this;
        }

        public final Builder setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setStarred(@Nullable Boolean starred) {
            this.starred = starred;
            return this;
        }

        public final Builder setStarred(Optional<Boolean> starred) {
            this.starred = starred.orElse(null);
            return this;
        }

        public final Builder addChannelIds(String element) {
            this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            return this;
        }

        public final Builder addChannelIds(String ... elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder setChannelIds(Iterable<String> elements) {
            this.channelIds.clear();
            return this.addAllChannelIds(elements);
        }

        public final Builder addAllChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder addGroupIds(String element) {
            this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            return this;
        }

        public final Builder addGroupIds(String ... elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder setGroupIds(Iterable<String> elements) {
            this.groupIds.clear();
            return this.addAllGroupIds(elements);
        }

        public final Builder addAllGroupIds(Iterable<String> elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder addImIds(String element) {
            this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            return this;
        }

        public final Builder addImIds(String ... elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public final Builder setImIds(Iterable<String> elements) {
            this.imIds.clear();
            return this.addAllImIds(elements);
        }

        public final Builder addAllImIds(Iterable<String> elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public SlackJpgFile build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackJpgFile(this);
        }

        private boolean commentsCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean hasRichPreviewIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean createdEpochSecondsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean timestampEpochSecondsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean mimetypeIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean prettyTypeIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean editableIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private boolean sizeIsSet() {
            return (this.initBits & 0x400L) == 0L;
        }

        private boolean modeIsSet() {
            return (this.initBits & 0x800L) == 0L;
        }

        private boolean externalIsSet() {
            return (this.initBits & 0x1000L) == 0L;
        }

        private boolean isPublicIsSet() {
            return (this.initBits & 0x2000L) == 0L;
        }

        private boolean publicUrlSharedIsSet() {
            return (this.initBits & 0x4000L) == 0L;
        }

        private boolean displayAsBotIsSet() {
            return (this.initBits & 0x8000L) == 0L;
        }

        private boolean usernameIsSet() {
            return (this.initBits & 0x10000L) == 0L;
        }

        private boolean urlPrivateIsSet() {
            return (this.initBits & 0x20000L) == 0L;
        }

        private boolean permalinkIsSet() {
            return (this.initBits & 0x40000L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.hasRichPreviewIsSet()) {
                attributes.add("hasRichPreview");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.createdEpochSecondsIsSet()) {
                attributes.add("createdEpochSeconds");
            }
            if (!this.timestampEpochSecondsIsSet()) {
                attributes.add("timestampEpochSeconds");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.mimetypeIsSet()) {
                attributes.add("mimetype");
            }
            if (!this.prettyTypeIsSet()) {
                attributes.add("prettyType");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.editableIsSet()) {
                attributes.add("editable");
            }
            if (!this.sizeIsSet()) {
                attributes.add("size");
            }
            if (!this.modeIsSet()) {
                attributes.add("mode");
            }
            if (!this.externalIsSet()) {
                attributes.add("external");
            }
            if (!this.isPublicIsSet()) {
                attributes.add("isPublic");
            }
            if (!this.publicUrlSharedIsSet()) {
                attributes.add("publicUrlShared");
            }
            if (!this.displayAsBotIsSet()) {
                attributes.add("displayAsBot");
            }
            if (!this.usernameIsSet()) {
                attributes.add("username");
            }
            if (!this.urlPrivateIsSet()) {
                attributes.add("urlPrivate");
            }
            if (!this.permalinkIsSet()) {
                attributes.add("permalink");
            }
            return "Cannot build SlackJpgFile, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackJpgFileIF {
        @Nullable
        SlackFileType filetype;
        Optional<String> thumb64Url = Optional.empty();
        Optional<String> thumb80Url = Optional.empty();
        Optional<String> thumb160Url = Optional.empty();
        Optional<String> thumb360Url = Optional.empty();
        Optional<Integer> thumb360Width = Optional.empty();
        Optional<Integer> thumb360Height = Optional.empty();
        Optional<String> thumb480Url = Optional.empty();
        Optional<Integer> thumb480Width = Optional.empty();
        Optional<Integer> thumb480Height = Optional.empty();
        Optional<Integer> imageExifRotation = Optional.empty();
        Optional<Integer> originalWidth = Optional.empty();
        Optional<Integer> originalHeight = Optional.empty();
        boolean hasRichPreview;
        boolean hasRichPreviewIsSet;
        @Nullable
        String id;
        long createdEpochSeconds;
        boolean createdEpochSecondsIsSet;
        long timestampEpochSeconds;
        boolean timestampEpochSecondsIsSet;
        @Nullable
        String name;
        @Nullable
        String title;
        @Nullable
        String mimetype;
        @Nullable
        String prettyType;
        @Nullable
        String userId;
        boolean editable;
        boolean editableIsSet;
        long size;
        boolean sizeIsSet;
        @Nullable
        String mode;
        boolean external;
        boolean externalIsSet;
        boolean isPublic;
        boolean isPublicIsSet;
        boolean publicUrlShared;
        boolean publicUrlSharedIsSet;
        boolean displayAsBot;
        boolean displayAsBotIsSet;
        @Nullable
        String username;
        @Nullable
        String urlPrivate;
        Optional<String> urlPrivateDownload = Optional.empty();
        @Nullable
        String permalink;
        Optional<String> permalinkPublic = Optional.empty();
        int commentsCount;
        boolean commentsCountIsSet;
        Optional<Boolean> starred = Optional.empty();
        List<String> channelIds = Collections.emptyList();
        List<String> groupIds = Collections.emptyList();
        List<String> imIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
        }

        @JsonProperty(value="thumb_64")
        public void setThumb64Url(Optional<String> thumb64Url) {
            this.thumb64Url = thumb64Url;
        }

        @JsonProperty(value="thumb_80")
        public void setThumb80Url(Optional<String> thumb80Url) {
            this.thumb80Url = thumb80Url;
        }

        @JsonProperty(value="thumb_160")
        public void setThumb160Url(Optional<String> thumb160Url) {
            this.thumb160Url = thumb160Url;
        }

        @JsonProperty(value="thumb_360")
        public void setThumb360Url(Optional<String> thumb360Url) {
            this.thumb360Url = thumb360Url;
        }

        @JsonProperty(value="thumb_360_w")
        public void setThumb360Width(Optional<Integer> thumb360Width) {
            this.thumb360Width = thumb360Width;
        }

        @JsonProperty(value="thumb_360_h")
        public void setThumb360Height(Optional<Integer> thumb360Height) {
            this.thumb360Height = thumb360Height;
        }

        @JsonProperty(value="thumb_480")
        public void setThumb480Url(Optional<String> thumb480Url) {
            this.thumb480Url = thumb480Url;
        }

        @JsonProperty(value="thumb_480_w")
        public void setThumb480Width(Optional<Integer> thumb480Width) {
            this.thumb480Width = thumb480Width;
        }

        @JsonProperty(value="thumb_480_h")
        public void setThumb480Height(Optional<Integer> thumb480Height) {
            this.thumb480Height = thumb480Height;
        }

        @JsonProperty
        public void setImageExifRotation(Optional<Integer> imageExifRotation) {
            this.imageExifRotation = imageExifRotation;
        }

        @JsonProperty(value="original_w")
        public void setOriginalWidth(Optional<Integer> originalWidth) {
            this.originalWidth = originalWidth;
        }

        @JsonProperty(value="original_h")
        public void setOriginalHeight(Optional<Integer> originalHeight) {
            this.originalHeight = originalHeight;
        }

        @JsonProperty(value="has_rich_preview")
        public void setHasRichPreview(boolean hasRichPreview) {
            this.hasRichPreview = hasRichPreview;
            this.hasRichPreviewIsSet = true;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="created")
        public void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsIsSet = true;
        }

        @JsonProperty(value="timestamp")
        public void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        @JsonProperty
        public void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setEditable(boolean editable) {
            this.editable = editable;
            this.editableIsSet = true;
        }

        @JsonProperty
        public void setSize(long size) {
            this.size = size;
            this.sizeIsSet = true;
        }

        @JsonProperty
        public void setMode(String mode) {
            this.mode = mode;
        }

        @JsonProperty(value="is_external")
        public void setExternal(boolean external) {
            this.external = external;
            this.externalIsSet = true;
        }

        @JsonProperty(value="is_public")
        public void setIsPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicIsSet = true;
        }

        @JsonProperty
        public void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedIsSet = true;
        }

        @JsonProperty
        public void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotIsSet = true;
        }

        @JsonProperty
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty
        public void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
        }

        @JsonProperty
        public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
        }

        @JsonProperty
        public void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountIsSet = true;
        }

        @JsonProperty(value="is_starred")
        public void setStarred(Optional<Boolean> starred) {
            this.starred = starred;
        }

        @JsonProperty(value="channels")
        public void setChannelIds(List<String> channelIds) {
            this.channelIds = channelIds;
        }

        @JsonProperty(value="groups")
        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        @JsonProperty(value="ims")
        public void setImIds(List<String> imIds) {
            this.imIds = imIds;
        }

        @Override
        public SlackFileType getFiletype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb64Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb80Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb160Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb360Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb360Width() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb360Height() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb480Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb480Width() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb480Height() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getImageExifRotation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getOriginalWidth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getOriginalHeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasRichPreview() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTimestampEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMimetype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrettyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEditable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublicUrlShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDisplayAsBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrlPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrlPrivateDownload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPermalinkPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCommentsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isStarred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getImIds() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private SlackFileType filetype;
        private int filetypeStage;
        private int commentsCount;
        private int commentsCountStage;

        private InitShim() {
        }

        SlackFileType getFiletype() {
            if (this.filetypeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.filetypeStage == 0) {
                this.filetypeStage = -1;
                this.filetype = Objects.requireNonNull(SlackJpgFile.this.getFiletypeInitialize(), "filetype");
                this.filetypeStage = 1;
            }
            return this.filetype;
        }

        void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
            this.filetypeStage = 1;
        }

        int getCommentsCount() {
            if (this.commentsCountStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.commentsCountStage == 0) {
                this.commentsCountStage = -1;
                this.commentsCount = SlackJpgFile.this.getCommentsCountInitialize();
                this.commentsCountStage = 1;
            }
            return this.commentsCount;
        }

        void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filetypeStage == -1) {
                attributes.add("filetype");
            }
            if (this.commentsCountStage == -1) {
                attributes.add("commentsCount");
            }
            return "Cannot build SlackJpgFile, attribute initializers form cycle" + attributes;
        }
    }
}

