/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.bot;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.bot.SlackAppHomeOpenedEventIF;
import com.hubspot.slack.client.models.response.views.HomeTabViewResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackAppHomeOpenedEvent
implements SlackAppHomeOpenedEventIF {
    @Nullable
    private final String tab;
    @Nullable
    private final HomeTabViewResponse view;
    private final String userId;
    private final String channelId;
    private final SlackEventType type;

    private SlackAppHomeOpenedEvent(@Nullable String tab, @Nullable HomeTabViewResponse view, String userId, String channelId, SlackEventType type) {
        this.tab = tab;
        this.view = view;
        this.userId = userId;
        this.channelId = channelId;
        this.type = type;
    }

    @Override
    @JsonProperty
    public Optional<String> getTab() {
        return Optional.ofNullable(this.tab);
    }

    @Override
    @JsonProperty
    public Optional<HomeTabViewResponse> getView() {
        return Optional.ofNullable(this.view);
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackAppHomeOpenedEvent withTab(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.tab, newValue)) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(newValue, this.view, this.userId, this.channelId, this.type);
    }

    public final SlackAppHomeOpenedEvent withTab(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tab, value)) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(value, this.view, this.userId, this.channelId, this.type);
    }

    public final SlackAppHomeOpenedEvent withView(@Nullable HomeTabViewResponse value) {
        HomeTabViewResponse newValue = value;
        if (this.view == newValue) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.tab, newValue, this.userId, this.channelId, this.type);
    }

    public final SlackAppHomeOpenedEvent withView(Optional<HomeTabViewResponse> optional) {
        HomeTabViewResponse value = optional.orElse(null);
        if (this.view == value) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.tab, value, this.userId, this.channelId, this.type);
    }

    public final SlackAppHomeOpenedEvent withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackAppHomeOpenedEvent(this.tab, this.view, newValue, this.channelId, this.type);
    }

    public final SlackAppHomeOpenedEvent withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackAppHomeOpenedEvent(this.tab, this.view, this.userId, newValue, this.type);
    }

    public final SlackAppHomeOpenedEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackAppHomeOpenedEvent(this.tab, this.view, this.userId, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackAppHomeOpenedEvent && this.equalTo((SlackAppHomeOpenedEvent)another);
    }

    private boolean equalTo(SlackAppHomeOpenedEvent another) {
        return Objects.equals(this.tab, another.tab) && Objects.equals(this.view, another.view) && this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.tab);
        h = h * 17 + Objects.hashCode(this.view);
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackAppHomeOpenedEvent{");
        if (this.tab != null) {
            builder.append("tab=").append(this.tab);
        }
        if (this.view != null) {
            if (builder.length() > 24) {
                builder.append(", ");
            }
            builder.append("view=").append(this.view);
        }
        if (builder.length() > 24) {
            builder.append(", ");
        }
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackAppHomeOpenedEvent fromJson(Json json) {
        Builder builder = SlackAppHomeOpenedEvent.builder();
        if (json.tab != null) {
            builder.setTab(json.tab);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackAppHomeOpenedEvent copyOf(SlackAppHomeOpenedEventIF instance) {
        if (instance instanceof SlackAppHomeOpenedEvent) {
            return (SlackAppHomeOpenedEvent)instance;
        }
        return SlackAppHomeOpenedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String tab;
        @Nullable
        private HomeTabViewResponse view;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackAppHomeOpenedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof SlackAppHomeOpenedEventIF) {
                Optional<String> tabOptional;
                instance = (SlackAppHomeOpenedEventIF)object;
                Optional<HomeTabViewResponse> viewOptional = instance.getView();
                if (viewOptional.isPresent()) {
                    this.setView(viewOptional);
                }
                if ((tabOptional = instance.getTab()).isPresent()) {
                    this.setTab(tabOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
                this.setChannelId(instance.getChannelId());
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setTab(@Nullable String tab) {
            this.tab = tab;
            return this;
        }

        public final Builder setTab(Optional<String> tab) {
            this.tab = tab.orElse(null);
            return this;
        }

        public final Builder setView(@Nullable HomeTabViewResponse view) {
            this.view = view;
            return this;
        }

        public final Builder setView(Optional<HomeTabViewResponse> view) {
            this.view = view.orElse(null);
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackAppHomeOpenedEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackAppHomeOpenedEvent(this.tab, this.view, this.userId, this.channelId, this.type);
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackAppHomeOpenedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackAppHomeOpenedEventIF {
        Optional<String> tab = Optional.empty();
        Optional<HomeTabViewResponse> view = Optional.empty();
        @Nullable
        String userId;
        @Nullable
        String channelId;
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty
        public void setTab(Optional<String> tab) {
            this.tab = tab;
        }

        @JsonProperty
        public void setView(Optional<HomeTabViewResponse> view) {
            this.view = view;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public Optional<String> getTab() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<HomeTabViewResponse> getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

