/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.app;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.app.SlackTokensRevokedEventIF;
import com.hubspot.slack.client.models.events.app.TokensRevoked;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackTokensRevokedEvent
implements SlackTokensRevokedEventIF {
    private final TokensRevoked tokens;
    private final SlackEventType type;

    private SlackTokensRevokedEvent(TokensRevoked tokens, SlackEventType type) {
        this.tokens = tokens;
        this.type = type;
    }

    @Override
    @JsonProperty
    public TokensRevoked getTokens() {
        return this.tokens;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    public final SlackTokensRevokedEvent withTokens(TokensRevoked tokens) {
        if (this.tokens == tokens) {
            return this;
        }
        TokensRevoked newValue = Objects.requireNonNull(tokens, "tokens");
        return new SlackTokensRevokedEvent(newValue, this.type);
    }

    public final SlackTokensRevokedEvent withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackTokensRevokedEvent(this.tokens, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackTokensRevokedEvent && this.equalTo((SlackTokensRevokedEvent)another);
    }

    private boolean equalTo(SlackTokensRevokedEvent another) {
        return this.tokens.equals(another.tokens) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.tokens.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "SlackTokensRevokedEvent{tokens=" + this.tokens + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackTokensRevokedEvent fromJson(Json json) {
        Builder builder = SlackTokensRevokedEvent.builder();
        if (json.tokens != null) {
            builder.setTokens(json.tokens);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static SlackTokensRevokedEvent copyOf(SlackTokensRevokedEventIF instance) {
        if (instance instanceof SlackTokensRevokedEvent) {
            return (SlackTokensRevokedEvent)instance;
        }
        return SlackTokensRevokedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKENS = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private TokensRevoked tokens;
        @Nullable
        private SlackEventType type;

        private Builder() {
        }

        public final Builder from(SlackTokensRevokedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackEvent instance;
            if (object instanceof SlackTokensRevokedEventIF) {
                instance = (SlackTokensRevokedEventIF)object;
                this.setTokens(instance.getTokens());
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
            }
        }

        public final Builder setTokens(TokensRevoked tokens) {
            this.tokens = Objects.requireNonNull(tokens, "tokens");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackTokensRevokedEvent build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackTokensRevokedEvent(this.tokens, this.type);
        }

        private boolean tokensIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tokensIsSet()) {
                attributes.add("tokens");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build SlackTokensRevokedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackTokensRevokedEventIF {
        @Nullable
        TokensRevoked tokens;
        @Nullable
        SlackEventType type;

        Json() {
        }

        @JsonProperty
        public void setTokens(TokensRevoked tokens) {
            this.tokens = tokens;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @Override
        public TokensRevoked getTokens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

