/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import java.util.List;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface SlackFormOptionGroupIF {
    public String getLabel();

    public List<SlackFormOption> getOptions();

    @Value.Check
    default public void validate() {
        String label = this.getLabel();
        int numOptionGroups = this.getOptions().size();
        if (Strings.isNullOrEmpty((String)label)) {
            throw new IllegalStateException("Must provide a label");
        }
        if (label.length() > 75) {
            throw new IllegalStateException("Label cannot exceed 75 chars - '" + label + "'");
        }
        if (numOptionGroups > 100) {
            throw new IllegalStateException("Cannot have more than 100 option groups. Has " + numOptionGroups);
        }
    }
}

