/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public interface SlackDialogIF {
    public String getTitle();

    public String getCallbackId();

    public List<SlackDialogFormElement> getElements();

    public Optional<String> getState();

    public Optional<String> getSubmitLabel();

    public Optional<Boolean> getNotifyOnCancel();

    @Value.Check
    default public void validate() {
        if (Strings.isNullOrEmpty((String)this.getTitle())) {
            throw new IllegalStateException("Title must be present");
        }
        if (this.getTitle().length() > 24) {
            throw new IllegalStateException("Title cannot exceed 24 chars, got " + this.getTitle());
        }
        if (Strings.isNullOrEmpty((String)this.getCallbackId())) {
            throw new IllegalStateException("Callback id must be present");
        }
        if (this.getCallbackId().length() > 255) {
            throw new IllegalStateException("Callback id cannot exceed 255 chars, got " + this.getCallbackId());
        }
        if (this.getElements().isEmpty()) {
            throw new IllegalStateException("At least one form element required");
        }
        if (this.getElements().size() > 10) {
            throw new IllegalStateException("At most 10 form elements allowed, got " + this.getElements().size());
        }
        this.getState().ifPresent(state -> {
            if (state.length() > 3000) {
                throw new IllegalStateException("State cannot exceed 3000 chars, got " + state.length());
            }
        });
        this.getSubmitLabel().ifPresent(submitLabel -> {
            if (submitLabel.length() > 24) {
                throw new IllegalStateException("Submit label cannot exceed 24 chars, got " + submitLabel.length());
            }
        });
    }
}

