/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.elements.RadioButtonGroupIF;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class RadioButtonGroup
implements RadioButtonGroupIF {
    private final String type;
    private final String actionId;
    private final List<Option> options;
    @Nullable
    private final Option initialOption;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private RadioButtonGroup(String actionId, Iterable<? extends Option> options) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.options = RadioButtonGroup.createUnmodifiableList(false, RadioButtonGroup.createSafeList(options, true, false));
        this.initialOption = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(RadioButtonGroupIF.super.getType(), "type");
    }

    private RadioButtonGroup(String actionId, List<Option> options, @Nullable Option initialOption, @Nullable ConfirmationDialog confirmationDialog) {
        this.actionId = actionId;
        this.options = options;
        this.initialOption = initialOption;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(RadioButtonGroupIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    public Optional<Option> getInitialOption() {
        return Optional.ofNullable(this.initialOption);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final RadioButtonGroup withActionId(String actionId) {
        if (this.actionId.equals(actionId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionId, "actionId");
        return new RadioButtonGroup(newValue, this.options, this.initialOption, this.confirmationDialog);
    }

    public final RadioButtonGroup withOptions(Option ... elements) {
        List<Option> newValue = RadioButtonGroup.createUnmodifiableList(false, RadioButtonGroup.createSafeList(Arrays.asList(elements), true, false));
        return new RadioButtonGroup(this.actionId, newValue, this.initialOption, this.confirmationDialog);
    }

    public final RadioButtonGroup withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = RadioButtonGroup.createUnmodifiableList(false, RadioButtonGroup.createSafeList(elements, true, false));
        return new RadioButtonGroup(this.actionId, newValue, this.initialOption, this.confirmationDialog);
    }

    public final RadioButtonGroup withInitialOption(@Nullable Option value) {
        Option newValue = value;
        if (this.initialOption == newValue) {
            return this;
        }
        return new RadioButtonGroup(this.actionId, this.options, newValue, this.confirmationDialog);
    }

    public final RadioButtonGroup withInitialOption(Optional<Option> optional) {
        Option value = optional.orElse(null);
        if (this.initialOption == value) {
            return this;
        }
        return new RadioButtonGroup(this.actionId, this.options, value, this.confirmationDialog);
    }

    public final RadioButtonGroup withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new RadioButtonGroup(this.actionId, this.options, this.initialOption, newValue);
    }

    public final RadioButtonGroup withConfirmationDialog(Optional<ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new RadioButtonGroup(this.actionId, this.options, this.initialOption, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RadioButtonGroup && this.equalTo((RadioButtonGroup)another);
    }

    private boolean equalTo(RadioButtonGroup another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && this.options.equals(another.options) && Objects.equals(this.initialOption, another.initialOption) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.actionId.hashCode();
        h = h * 17 + this.options.hashCode();
        h = h * 17 + Objects.hashCode(this.initialOption);
        h = h * 17 + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RadioButtonGroup{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("options=").append(this.options);
        if (this.initialOption != null) {
            builder.append(", ");
            builder.append("initialOption=").append(this.initialOption);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static RadioButtonGroup fromJson(Json json) {
        Builder builder = RadioButtonGroup.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.initialOption != null) {
            builder.setInitialOption(json.initialOption);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static RadioButtonGroup of(String actionId, List<Option> options) {
        return RadioButtonGroup.of(actionId, options);
    }

    public static RadioButtonGroup of(String actionId, Iterable<? extends Option> options) {
        return new RadioButtonGroup(actionId, options);
    }

    public static RadioButtonGroup copyOf(RadioButtonGroupIF instance) {
        if (instance instanceof RadioButtonGroup) {
            return (RadioButtonGroup)instance;
        }
        return RadioButtonGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        private List<Option> options = new ArrayList<Option>();
        @Nullable
        private Option initialOption;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RadioButtonGroupIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof RadioButtonGroupIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                Optional<Option> initialOptionOptional;
                instance = (RadioButtonGroupIF)object;
                this.addAllOptions(instance.getOptions());
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((initialOptionOptional = instance.getInitialOption()).isPresent()) {
                    this.setInitialOption(initialOptionOptional);
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public final Builder setInitialOption(@Nullable Option initialOption) {
            this.initialOption = initialOption;
            return this;
        }

        public final Builder setInitialOption(Optional<Option> initialOption) {
            this.initialOption = initialOption.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public RadioButtonGroup build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new RadioButtonGroup(this.actionId, RadioButtonGroup.createUnmodifiableList(true, this.options), this.initialOption, this.confirmationDialog);
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build RadioButtonGroup, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RadioButtonGroupIF {
        @Nullable
        String actionId;
        List<Option> options = Collections.emptyList();
        Optional<Option> initialOption = Optional.empty();
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @JsonProperty
        public void setInitialOption(Optional<Option> initialOption) {
            this.initialOption = initialOption;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Option> getInitialOption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

