/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ConversationSelectMenuIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationSelectMenu
implements ConversationSelectMenuIF {
    private final String type;
    private final Text placeholder;
    private final String actionId;
    @Nullable
    private final String initialConversationId;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private ConversationSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialConversationId = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ConversationSelectMenuIF.super.getType(), "type");
    }

    private ConversationSelectMenu(Text placeholder, String actionId, @Nullable String initialConversationId, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialConversationId = initialConversationId;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ConversationSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="initial_conversation")
    public Optional<String> getInitialConversationId() {
        return Optional.ofNullable(this.initialConversationId);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final ConversationSelectMenu withPlaceholder(Text placeholder) {
        if (this.placeholder == placeholder) {
            return this;
        }
        Text newValue = Objects.requireNonNull(placeholder, "placeholder");
        return new ConversationSelectMenu(newValue, this.actionId, this.initialConversationId, this.confirmationDialog);
    }

    public final ConversationSelectMenu withActionId(String actionId) {
        if (this.actionId.equals(actionId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionId, "actionId");
        return new ConversationSelectMenu(this.placeholder, newValue, this.initialConversationId, this.confirmationDialog);
    }

    public final ConversationSelectMenu withInitialConversationId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialConversationId, newValue)) {
            return this;
        }
        return new ConversationSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final ConversationSelectMenu withInitialConversationId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialConversationId, value)) {
            return this;
        }
        return new ConversationSelectMenu(this.placeholder, this.actionId, value, this.confirmationDialog);
    }

    public final ConversationSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new ConversationSelectMenu(this.placeholder, this.actionId, this.initialConversationId, newValue);
    }

    public final ConversationSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new ConversationSelectMenu(this.placeholder, this.actionId, this.initialConversationId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationSelectMenu && this.equalTo((ConversationSelectMenu)another);
    }

    private boolean equalTo(ConversationSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && Objects.equals(this.initialConversationId, another.initialConversationId) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.placeholder.hashCode();
        h = h * 17 + this.actionId.hashCode();
        h = h * 17 + Objects.hashCode(this.initialConversationId);
        h = h * 17 + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.initialConversationId != null) {
            builder.append(", ");
            builder.append("initialConversationId=").append(this.initialConversationId);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationSelectMenu fromJson(Json json) {
        Builder builder = ConversationSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialConversationId != null) {
            builder.setInitialConversationId(json.initialConversationId);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static ConversationSelectMenu of(Text placeholder, String actionId) {
        return new ConversationSelectMenu(placeholder, actionId);
    }

    public static ConversationSelectMenu copyOf(ConversationSelectMenuIF instance) {
        if (instance instanceof ConversationSelectMenu) {
            return (ConversationSelectMenu)instance;
        }
        return ConversationSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        @Nullable
        private String initialConversationId;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(ConversationSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof ConversationSelectMenuIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                instance = (ConversationSelectMenuIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setPlaceholder(instance.getPlaceholder());
                Optional<String> initialConversationIdOptional = instance.getInitialConversationId();
                if (initialConversationIdOptional.isPresent()) {
                    this.setInitialConversationId(initialConversationIdOptional);
                }
            }
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setInitialConversationId(@Nullable String initialConversationId) {
            this.initialConversationId = initialConversationId;
            return this;
        }

        public final Builder setInitialConversationId(Optional<String> initialConversationId) {
            this.initialConversationId = initialConversationId.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public ConversationSelectMenu build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationSelectMenu(this.placeholder, this.actionId, this.initialConversationId, this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build ConversationSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        Optional<String> initialConversationId = Optional.empty();
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="initial_conversation")
        public void setInitialConversationId(Optional<String> initialConversationId) {
            this.initialConversationId = initialConversationId;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialConversationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

