/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.SectionIF;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Section
implements SectionIF {
    private final String type;
    @Nullable
    private final Text text;
    private final List<Text> fields;
    @Nullable
    private final BlockElement accessory;
    @Nullable
    private final String blockId;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private Section(@Nullable Text text) {
        this.text = text;
        this.initShim.setText(this.text);
        this.fields = Collections.emptyList();
        this.accessory = null;
        this.blockId = null;
        this.type = this.initShim.getType();
        this.initShim = null;
    }

    private Section(Builder builder) {
        this.fields = Section.createUnmodifiableList(true, builder.fields);
        this.accessory = builder.accessory;
        this.blockId = builder.blockId;
        if (builder.textIsSet()) {
            this.initShim.setText(builder.text);
        }
        this.text = this.initShim.getText();
        this.type = this.initShim.getType();
        this.initShim = null;
    }

    private Section(@Nullable Text text, List<Text> fields, @Nullable BlockElement accessory, @Nullable String blockId) {
        this.text = text;
        this.fields = fields;
        this.accessory = accessory;
        this.blockId = blockId;
        this.initShim.setText(this.text);
        this.type = this.initShim.getType();
        this.initShim = null;
    }

    private String getTypeInitialize() {
        return SectionIF.super.getType();
    }

    @Nullable
    private Text getTextInitialize() {
        return SectionIF.super.getText();
    }

    @Override
    @JsonProperty
    public String getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty
    @Nullable
    public Text getText() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getText() : this.text;
    }

    @Override
    @JsonProperty
    public List<Text> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty
    public Optional<BlockElement> getAccessory() {
        return Optional.ofNullable(this.accessory);
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Section withText(@Nullable Text text) {
        if (this.text == text) {
            return this;
        }
        return Section.validate(new Section(text, this.fields, this.accessory, this.blockId));
    }

    public final Section withFields(Text ... elements) {
        List<Text> newValue = Section.createUnmodifiableList(false, Section.createSafeList(Arrays.asList(elements), true, false));
        return Section.validate(new Section(this.text, newValue, this.accessory, this.blockId));
    }

    public final Section withFields(Iterable<? extends Text> elements) {
        if (this.fields == elements) {
            return this;
        }
        List<Text> newValue = Section.createUnmodifiableList(false, Section.createSafeList(elements, true, false));
        return Section.validate(new Section(this.text, newValue, this.accessory, this.blockId));
    }

    public final Section withAccessory(@Nullable BlockElement value) {
        BlockElement newValue = value;
        if (this.accessory == newValue) {
            return this;
        }
        return Section.validate(new Section(this.text, this.fields, newValue, this.blockId));
    }

    public final Section withAccessory(Optional<BlockElement> optional) {
        BlockElement value = optional.orElse(null);
        if (this.accessory == value) {
            return this;
        }
        return Section.validate(new Section(this.text, this.fields, value, this.blockId));
    }

    public final Section withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return Section.validate(new Section(this.text, this.fields, this.accessory, newValue));
    }

    public final Section withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return Section.validate(new Section(this.text, this.fields, this.accessory, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Section && this.equalTo((Section)another);
    }

    private boolean equalTo(Section another) {
        return this.type.equals(another.type) && Objects.equals(this.text, another.text) && this.fields.equals(another.fields) && Objects.equals(this.accessory, another.accessory) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.text);
        h = h * 17 + this.fields.hashCode();
        h = h * 17 + Objects.hashCode(this.accessory);
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Section{");
        builder.append("type=").append(this.type);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        builder.append(", ");
        builder.append("fields=").append(this.fields);
        if (this.accessory != null) {
            builder.append(", ");
            builder.append("accessory=").append(this.accessory);
        }
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Section fromJson(Json json) {
        Builder builder = Section.builder();
        if (json.textIsSet) {
            builder.setText(json.text);
        }
        if (json.fields != null) {
            builder.addAllFields(json.fields);
        }
        if (json.accessory != null) {
            builder.setAccessory(json.accessory);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Section of(@Nullable Text text) {
        return Section.validate(new Section(text));
    }

    private static Section validate(Section instance) {
        instance.check();
        return instance;
    }

    public static Section copyOf(SectionIF instance) {
        if (instance instanceof Section) {
            return (Section)instance;
        }
        return Section.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_TEXT = 1L;
        private long optBits;
        @Nullable
        private Text text;
        private List<Text> fields = new ArrayList<Text>();
        @Nullable
        private BlockElement accessory;
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SectionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
            if (object instanceof SectionIF) {
                Text textValue;
                instance = (SectionIF)object;
                this.addAllFields(instance.getFields());
                Optional<BlockElement> accessoryOptional = instance.getAccessory();
                if (accessoryOptional.isPresent()) {
                    this.setAccessory(accessoryOptional);
                }
                if ((textValue = instance.getText()) != null) {
                    this.setText(textValue);
                }
            }
        }

        public final Builder setText(@Nullable Text text) {
            this.text = text;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFields(Text element) {
            this.fields.add(Objects.requireNonNull(element, "fields element"));
            return this;
        }

        public final Builder addFields(Text ... elements) {
            for (Text element : elements) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
            }
            return this;
        }

        public final Builder setFields(Iterable<? extends Text> elements) {
            this.fields.clear();
            return this.addAllFields(elements);
        }

        public final Builder addAllFields(Iterable<? extends Text> elements) {
            for (Text text : elements) {
                this.fields.add(Objects.requireNonNull(text, "fields element"));
            }
            return this;
        }

        public final Builder setAccessory(@Nullable BlockElement accessory) {
            this.accessory = accessory;
            return this;
        }

        public final Builder setAccessory(Optional<BlockElement> accessory) {
            this.accessory = accessory.orElse(null);
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Section build() throws InvalidImmutableStateException {
            return Section.validate(new Section(this));
        }

        private boolean textIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SectionIF {
        @Nullable
        Text text;
        boolean textIsSet;
        List<Text> fields = Collections.emptyList();
        Optional<BlockElement> accessory = Optional.empty();
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(@Nullable Text text) {
            this.text = text;
            this.textIsSet = true;
        }

        @JsonProperty
        public void setFields(List<Text> fields) {
            this.fields = fields;
        }

        @JsonProperty
        public void setAccessory(Optional<BlockElement> accessory) {
            this.accessory = accessory;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Text> getFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BlockElement> getAccessory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private String type;
        private int typeStage;
        private Text text;
        private int textStage;

        private InitShim() {
        }

        String getType() {
            if (this.typeStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.typeStage == 0) {
                this.typeStage = -1;
                this.type = Objects.requireNonNull(Section.this.getTypeInitialize(), "type");
                this.typeStage = 1;
            }
            return this.type;
        }

        Text getText() {
            if (this.textStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.textStage == 0) {
                this.textStage = -1;
                this.text = Section.this.getTextInitialize();
                this.textStage = 1;
            }
            return this.text;
        }

        void setText(Text text) {
            this.text = text;
            this.textStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeStage == -1) {
                attributes.add("type");
            }
            if (this.textStage == -1) {
                attributes.add("text");
            }
            return "Cannot build Section, attribute initializers form cycle" + attributes;
        }
    }
}

