/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.HeaderIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Header
implements HeaderIF {
    private final String type;
    private final Text text;
    @Nullable
    private final String blockId;

    private Header(Text text) {
        this.text = Objects.requireNonNull(text, "text");
        this.blockId = null;
        this.type = Objects.requireNonNull(HeaderIF.super.getType(), "type");
    }

    private Header(Text text, @Nullable String blockId) {
        this.text = text;
        this.blockId = blockId;
        this.type = Objects.requireNonNull(HeaderIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    public final Header withText(Text text) {
        if (this.text == text) {
            return this;
        }
        Text newValue = Objects.requireNonNull(text, "text");
        return Header.validate(new Header(newValue, this.blockId));
    }

    public final Header withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return Header.validate(new Header(this.text, newValue));
    }

    public final Header withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return Header.validate(new Header(this.text, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Header && this.equalTo((Header)another);
    }

    private boolean equalTo(Header another) {
        return this.type.equals(another.type) && this.text.equals(another.text) && Objects.equals(this.blockId, another.blockId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.text.hashCode();
        h = h * 17 + Objects.hashCode(this.blockId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Header{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("text=").append(this.text);
        if (this.blockId != null) {
            builder.append(", ");
            builder.append("blockId=").append(this.blockId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Header fromJson(Json json) {
        Builder builder = Header.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Header of(Text text) {
        return Header.validate(new Header(text));
    }

    private static Header validate(Header instance) {
        instance.check();
        return instance;
    }

    public static Header copyOf(HeaderIF instance) {
        if (instance instanceof Header) {
            return (Header)instance;
        }
        return Header.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private Text text;
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HeaderIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Block instance;
            Optional<String> blockIdOptional;
            if (object instanceof Block && (blockIdOptional = (instance = (Block)object).getBlockId()).isPresent()) {
                this.setBlockId(blockIdOptional);
            }
            if (object instanceof HeaderIF) {
                instance = (HeaderIF)object;
                this.setText(instance.getText());
            }
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Header build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return Header.validate(new Header(this.text, this.blockId));
        }

        private boolean textIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build Header, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements HeaderIF {
        @Nullable
        Text text;
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }
    }
}

