/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.OptionIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Option
implements OptionIF {
    @Nullable
    private final String text;
    private final String value;

    private Option(@Nullable String text, String value) {
        this.text = text;
        this.value = value;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public final Option withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return new Option(newValue, this.value);
    }

    public final Option withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return new Option(value, this.value);
    }

    public final Option withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "value");
        return new Option(this.text, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Option && this.equalTo((Option)another);
    }

    private boolean equalTo(Option another) {
        return Objects.equals(this.text, another.text) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.text);
        h = h * 17 + this.value.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Option{");
        if (this.text != null) {
            builder.append("text=").append(this.text);
        }
        if (builder.length() > 7) {
            builder.append(", ");
        }
        builder.append("value=").append(this.value);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Option fromJson(Json json) {
        Builder builder = Option.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        return builder.build();
    }

    public static Option copyOf(OptionIF instance) {
        if (instance instanceof Option) {
            return (Option)instance;
        }
        return Option.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String text;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(OptionIF instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> textOptional = instance.getText();
            if (textOptional.isPresent()) {
                this.setText(textOptional);
            }
            this.setValue(instance.getValue());
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Option build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Option(this.text, this.value);
        }

        private boolean valueIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build Option, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OptionIF {
        Optional<String> text = Optional.empty();
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

