/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.MessageIF;
import com.hubspot.slack.client.models.SlackChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class Message
implements MessageIF {
    private final String type;
    private final String team;
    private final SlackChannel channel;
    @Nullable
    private final String user;
    private final String username;
    private final String timestamp;
    private final String text;
    @Nullable
    private final String permalink;
    private final List<Attachment> attachments;
    @Nullable
    private final LiteMessage previousPrevious;
    @Nullable
    private final LiteMessage previous;
    @Nullable
    private final LiteMessage next;
    @Nullable
    private final LiteMessage nextNext;
    private final String slackLink;

    private Message(String type, String team, SlackChannel channel, @Nullable String user, String username, String timestamp, String text, @Nullable String permalink, List<Attachment> attachments, @Nullable LiteMessage previousPrevious, @Nullable LiteMessage previous, @Nullable LiteMessage next, @Nullable LiteMessage nextNext) {
        this.type = type;
        this.team = team;
        this.channel = channel;
        this.user = user;
        this.username = username;
        this.timestamp = timestamp;
        this.text = text;
        this.permalink = permalink;
        this.attachments = attachments;
        this.previousPrevious = previousPrevious;
        this.previous = previous;
        this.next = next;
        this.nextNext = nextNext;
        this.slackLink = Objects.requireNonNull(MessageIF.super.getSlackLink(), "slackLink");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty(value="ts")
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public Optional<String> getPermalink() {
        return Optional.ofNullable(this.permalink);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty(value="previous_2")
    public Optional<LiteMessage> getPreviousPrevious() {
        return Optional.ofNullable(this.previousPrevious);
    }

    @Override
    @JsonProperty(value="previous")
    public Optional<LiteMessage> getPrevious() {
        return Optional.ofNullable(this.previous);
    }

    @Override
    @JsonProperty(value="next")
    public Optional<LiteMessage> getNext() {
        return Optional.ofNullable(this.next);
    }

    @Override
    @JsonProperty(value="next_2")
    public Optional<LiteMessage> getNextNext() {
        return Optional.ofNullable(this.nextNext);
    }

    @Override
    @JsonProperty
    public String getSlackLink() {
        return this.slackLink;
    }

    public final Message withType(String type) {
        if (this.type.equals(type)) {
            return this;
        }
        String newValue = Objects.requireNonNull(type, "type");
        return new Message(newValue, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withTeam(String team) {
        if (this.team.equals(team)) {
            return this;
        }
        String newValue = Objects.requireNonNull(team, "team");
        return new Message(this.type, newValue, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withChannel(SlackChannel channel) {
        if (this.channel == channel) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(channel, "channel");
        return new Message(this.type, this.team, newValue, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withUser(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.user, newValue)) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, newValue, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, value, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withUsername(String username) {
        if (this.username.equals(username)) {
            return this;
        }
        String newValue = Objects.requireNonNull(username, "username");
        return new Message(this.type, this.team, this.channel, this.user, newValue, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withTimestamp(String timestamp) {
        if (this.timestamp.equals(timestamp)) {
            return this;
        }
        String newValue = Objects.requireNonNull(timestamp, "timestamp");
        return new Message(this.type, this.team, this.channel, this.user, this.username, newValue, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withText(String text) {
        if (this.text.equals(text)) {
            return this;
        }
        String newValue = Objects.requireNonNull(text, "text");
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, newValue, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withPermalink(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.permalink, newValue)) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, newValue, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withPermalink(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.permalink, value)) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, value, this.attachments, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withAttachments(Attachment ... elements) {
        List<Attachment> newValue = Message.createUnmodifiableList(false, Message.createSafeList(Arrays.asList(elements), true, false));
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, newValue, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = Message.createUnmodifiableList(false, Message.createSafeList(elements, true, false));
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, newValue, this.previousPrevious, this.previous, this.next, this.nextNext);
    }

    public final Message withPreviousPrevious(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.previousPrevious == newValue) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, newValue, this.previous, this.next, this.nextNext);
    }

    public final Message withPreviousPrevious(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.previousPrevious == value) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, value, this.previous, this.next, this.nextNext);
    }

    public final Message withPrevious(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.previous == newValue) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, newValue, this.next, this.nextNext);
    }

    public final Message withPrevious(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.previous == value) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, value, this.next, this.nextNext);
    }

    public final Message withNext(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.next == newValue) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, newValue, this.nextNext);
    }

    public final Message withNext(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.next == value) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, value, this.nextNext);
    }

    public final Message withNextNext(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.nextNext == newValue) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, newValue);
    }

    public final Message withNextNext(Optional<LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.nextNext == value) {
            return this;
        }
        return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, this.attachments, this.previousPrevious, this.previous, this.next, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Message && this.equalTo((Message)another);
    }

    private boolean equalTo(Message another) {
        return this.type.equals(another.type) && this.team.equals(another.team) && this.channel.equals(another.channel) && Objects.equals(this.user, another.user) && this.username.equals(another.username) && this.timestamp.equals(another.timestamp) && this.text.equals(another.text) && Objects.equals(this.permalink, another.permalink) && this.attachments.equals(another.attachments) && Objects.equals(this.previousPrevious, another.previousPrevious) && Objects.equals(this.previous, another.previous) && Objects.equals(this.next, another.next) && Objects.equals(this.nextNext, another.nextNext) && this.slackLink.equals(another.slackLink);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.team.hashCode();
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + Objects.hashCode(this.user);
        h = h * 17 + this.username.hashCode();
        h = h * 17 + this.timestamp.hashCode();
        h = h * 17 + this.text.hashCode();
        h = h * 17 + Objects.hashCode(this.permalink);
        h = h * 17 + this.attachments.hashCode();
        h = h * 17 + Objects.hashCode(this.previousPrevious);
        h = h * 17 + Objects.hashCode(this.previous);
        h = h * 17 + Objects.hashCode(this.next);
        h = h * 17 + Objects.hashCode(this.nextNext);
        h = h * 17 + this.slackLink.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Message{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("timestamp=").append(this.timestamp);
        builder.append(", ");
        builder.append("text=").append(this.text);
        if (this.permalink != null) {
            builder.append(", ");
            builder.append("permalink=").append(this.permalink);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        if (this.previousPrevious != null) {
            builder.append(", ");
            builder.append("previousPrevious=").append(this.previousPrevious);
        }
        if (this.previous != null) {
            builder.append(", ");
            builder.append("previous=").append(this.previous);
        }
        if (this.next != null) {
            builder.append(", ");
            builder.append("next=").append(this.next);
        }
        if (this.nextNext != null) {
            builder.append(", ");
            builder.append("nextNext=").append(this.nextNext);
        }
        builder.append(", ");
        builder.append("slackLink=").append(this.slackLink);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static Message fromJson(Json json) {
        Builder builder = Message.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.timestamp != null) {
            builder.setTimestamp(json.timestamp);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.previousPrevious != null) {
            builder.setPreviousPrevious(json.previousPrevious);
        }
        if (json.previous != null) {
            builder.setPrevious(json.previous);
        }
        if (json.next != null) {
            builder.setNext(json.next);
        }
        if (json.nextNext != null) {
            builder.setNextNext(json.nextNext);
        }
        return builder.build();
    }

    public static Message copyOf(MessageIF instance) {
        if (instance instanceof Message) {
            return (Message)instance;
        }
        return Message.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEAM = 2L;
        private static final long INIT_BIT_CHANNEL = 4L;
        private static final long INIT_BIT_USERNAME = 8L;
        private static final long INIT_BIT_TIMESTAMP = 16L;
        private static final long INIT_BIT_TEXT = 32L;
        private long initBits = 63L;
        @Nullable
        private String type;
        @Nullable
        private String team;
        @Nullable
        private SlackChannel channel;
        @Nullable
        private String user;
        @Nullable
        private String username;
        @Nullable
        private String timestamp;
        @Nullable
        private String text;
        @Nullable
        private String permalink;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private LiteMessage previousPrevious;
        @Nullable
        private LiteMessage previous;
        @Nullable
        private LiteMessage next;
        @Nullable
        private LiteMessage nextNext;

        private Builder() {
        }

        public final Builder from(MessageIF instance) {
            Optional<LiteMessage> nextNextOptional;
            Optional<LiteMessage> nextOptional;
            Optional<LiteMessage> previousOptional;
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            this.setTeam(instance.getTeam());
            this.setChannel(instance.getChannel());
            Optional<String> userOptional = instance.getUser();
            if (userOptional.isPresent()) {
                this.setUser(userOptional);
            }
            this.setUsername(instance.getUsername());
            this.setTimestamp(instance.getTimestamp());
            this.setText(instance.getText());
            Optional<String> permalinkOptional = instance.getPermalink();
            if (permalinkOptional.isPresent()) {
                this.setPermalink(permalinkOptional);
            }
            this.addAllAttachments(instance.getAttachments());
            Optional<LiteMessage> previousPreviousOptional = instance.getPreviousPrevious();
            if (previousPreviousOptional.isPresent()) {
                this.setPreviousPrevious(previousPreviousOptional);
            }
            if ((previousOptional = instance.getPrevious()).isPresent()) {
                this.setPrevious(previousOptional);
            }
            if ((nextOptional = instance.getNext()).isPresent()) {
                this.setNext(nextOptional);
            }
            if ((nextNextOptional = instance.getNextNext()).isPresent()) {
                this.setNextNext(nextNextOptional);
            }
            return this;
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTeam(String team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder setUser(Optional<String> user) {
            this.user = user.orElse(null);
            return this;
        }

        public final Builder setUsername(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTimestamp(String timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setPermalink(@Nullable String permalink) {
            this.permalink = permalink;
            return this;
        }

        public final Builder setPermalink(Optional<String> permalink) {
            this.permalink = permalink.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder setPreviousPrevious(@Nullable LiteMessage previousPrevious) {
            this.previousPrevious = previousPrevious;
            return this;
        }

        public final Builder setPreviousPrevious(Optional<LiteMessage> previousPrevious) {
            this.previousPrevious = previousPrevious.orElse(null);
            return this;
        }

        public final Builder setPrevious(@Nullable LiteMessage previous) {
            this.previous = previous;
            return this;
        }

        public final Builder setPrevious(Optional<LiteMessage> previous) {
            this.previous = previous.orElse(null);
            return this;
        }

        public final Builder setNext(@Nullable LiteMessage next) {
            this.next = next;
            return this;
        }

        public final Builder setNext(Optional<LiteMessage> next) {
            this.next = next.orElse(null);
            return this;
        }

        public final Builder setNextNext(@Nullable LiteMessage nextNext) {
            this.nextNext = nextNext;
            return this;
        }

        public final Builder setNextNext(Optional<LiteMessage> nextNext) {
            this.nextNext = nextNext.orElse(null);
            return this;
        }

        public Message build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new Message(this.type, this.team, this.channel, this.user, this.username, this.timestamp, this.text, this.permalink, Message.createUnmodifiableList(true, this.attachments), this.previousPrevious, this.previous, this.next, this.nextNext);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean usernameIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean timestampIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.usernameIsSet()) {
                attributes.add("username");
            }
            if (!this.timestampIsSet()) {
                attributes.add("timestamp");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build Message, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageIF {
        @Nullable
        String type;
        @Nullable
        String team;
        @Nullable
        SlackChannel channel;
        Optional<String> user = Optional.empty();
        @Nullable
        String username;
        @Nullable
        String timestamp;
        @Nullable
        String text;
        Optional<String> permalink = Optional.empty();
        List<Attachment> attachments = Collections.emptyList();
        Optional<LiteMessage> previousPrevious = Optional.empty();
        Optional<LiteMessage> previous = Optional.empty();
        Optional<LiteMessage> next = Optional.empty();
        Optional<LiteMessage> nextNext = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setTeam(String team) {
            this.team = team;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setUser(Optional<String> user) {
            this.user = user;
        }

        @JsonProperty
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="ts")
        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setPermalink(Optional<String> permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="previous_2")
        public void setPreviousPrevious(Optional<LiteMessage> previousPrevious) {
            this.previousPrevious = previousPrevious;
        }

        @JsonProperty(value="previous")
        public void setPrevious(Optional<LiteMessage> previous) {
            this.previous = previous;
        }

        @JsonProperty(value="next")
        public void setNext(Optional<LiteMessage> next) {
            this.next = next;
        }

        @JsonProperty(value="next_2")
        public void setNextNext(Optional<LiteMessage> nextNext) {
            this.nextNext = nextNext;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getPreviousPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getNextNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSlackLink() {
            throw new UnsupportedOperationException();
        }
    }
}

