/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.views.OpenViewParamsIF;
import com.hubspot.slack.client.models.views.ModalViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class OpenViewParams
implements OpenViewParamsIF {
    private final String triggerId;
    private final ModalViewPayload view;

    private OpenViewParams(String triggerId, ModalViewPayload view) {
        this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
        this.view = Objects.requireNonNull(view, "view");
    }

    private OpenViewParams(OpenViewParams original, String triggerId, ModalViewPayload view) {
        this.triggerId = triggerId;
        this.view = view;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public ModalViewPayload getView() {
        return this.view;
    }

    public final OpenViewParams withTriggerId(String triggerId) {
        if (this.triggerId.equals(triggerId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(triggerId, "triggerId");
        return new OpenViewParams(this, newValue, this.view);
    }

    public final OpenViewParams withView(ModalViewPayload view) {
        if (this.view == view) {
            return this;
        }
        ModalViewPayload newValue = Objects.requireNonNull(view, "view");
        return new OpenViewParams(this, this.triggerId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OpenViewParams && this.equalTo((OpenViewParams)another);
    }

    private boolean equalTo(OpenViewParams another) {
        return this.triggerId.equals(another.triggerId) && this.view.equals(another.view);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.triggerId.hashCode();
        h = h * 17 + this.view.hashCode();
        return h;
    }

    public String toString() {
        return "OpenViewParams{triggerId=" + this.triggerId + ", view=" + this.view + "}";
    }

    @Deprecated
    @JsonCreator
    static OpenViewParams fromJson(Json json) {
        Builder builder = OpenViewParams.builder();
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        return builder.build();
    }

    public static OpenViewParams of(String triggerId, ModalViewPayload view) {
        return new OpenViewParams(triggerId, view);
    }

    public static OpenViewParams copyOf(OpenViewParamsIF instance) {
        if (instance instanceof OpenViewParams) {
            return (OpenViewParams)instance;
        }
        return OpenViewParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRIGGER_ID = 1L;
        private static final long INIT_BIT_VIEW = 2L;
        private long initBits = 3L;
        @Nullable
        private String triggerId;
        @Nullable
        private ModalViewPayload view;

        private Builder() {
        }

        public final Builder from(OpenViewParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTriggerId(instance.getTriggerId());
            this.setView(instance.getView());
            return this;
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setView(ModalViewPayload view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public OpenViewParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new OpenViewParams(null, this.triggerId, this.view);
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean viewIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            return "Cannot build OpenViewParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OpenViewParamsIF {
        @Nullable
        String triggerId;
        @Nullable
        ModalViewPayload view;

        Json() {
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setView(ModalViewPayload view) {
            this.view = view;
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModalViewPayload getView() {
            throw new UnsupportedOperationException();
        }
    }
}

