/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationSetTopicParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationSetTopicParams
implements ConversationSetTopicParamsIF {
    private final String topic;
    private final String channelId;

    private ConversationSetTopicParams(String topic, String channelId) {
        this.topic = topic;
        this.channelId = channelId;
    }

    @Override
    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final ConversationSetTopicParams withTopic(String topic) {
        if (this.topic.equals(topic)) {
            return this;
        }
        String newValue = Objects.requireNonNull(topic, "topic");
        return new ConversationSetTopicParams(newValue, this.channelId);
    }

    public final ConversationSetTopicParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new ConversationSetTopicParams(this.topic, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationSetTopicParams && this.equalTo((ConversationSetTopicParams)another);
    }

    private boolean equalTo(ConversationSetTopicParams another) {
        return this.topic.equals(another.topic) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.topic.hashCode();
        h = h * 17 + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "ConversationSetTopicParams{topic=" + this.topic + ", channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator
    static ConversationSetTopicParams fromJson(Json json) {
        Builder builder = ConversationSetTopicParams.builder();
        if (json.topic != null) {
            builder.setTopic(json.topic);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static ConversationSetTopicParams copyOf(ConversationSetTopicParamsIF instance) {
        if (instance instanceof ConversationSetTopicParams) {
            return (ConversationSetTopicParams)instance;
        }
        return ConversationSetTopicParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOPIC = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String topic;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(ConversationSetTopicParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTopic(instance.getTopic());
            this.setChannelId(instance.getChannelId());
            return this;
        }

        public final Builder setTopic(String topic) {
            this.topic = Objects.requireNonNull(topic, "topic");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConversationSetTopicParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationSetTopicParams(this.topic, this.channelId);
        }

        private boolean topicIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.topicIsSet()) {
                attributes.add("topic");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationSetTopicParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationSetTopicParamsIF {
        @Nullable
        String topic;
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty
        public void setTopic(String topic) {
            this.topic = topic;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public String getTopic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

