/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationSetPurposeParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationSetPurposeParams
implements ConversationSetPurposeParamsIF {
    private final String purpose;
    private final String channelId;

    private ConversationSetPurposeParams(String purpose, String channelId) {
        this.purpose = purpose;
        this.channelId = channelId;
    }

    @Override
    @JsonProperty
    public String getPurpose() {
        return this.purpose;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final ConversationSetPurposeParams withPurpose(String purpose) {
        if (this.purpose.equals(purpose)) {
            return this;
        }
        String newValue = Objects.requireNonNull(purpose, "purpose");
        return new ConversationSetPurposeParams(newValue, this.channelId);
    }

    public final ConversationSetPurposeParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new ConversationSetPurposeParams(this.purpose, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationSetPurposeParams && this.equalTo((ConversationSetPurposeParams)another);
    }

    private boolean equalTo(ConversationSetPurposeParams another) {
        return this.purpose.equals(another.purpose) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.purpose.hashCode();
        h = h * 17 + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "ConversationSetPurposeParams{purpose=" + this.purpose + ", channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator
    static ConversationSetPurposeParams fromJson(Json json) {
        Builder builder = ConversationSetPurposeParams.builder();
        if (json.purpose != null) {
            builder.setPurpose(json.purpose);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static ConversationSetPurposeParams copyOf(ConversationSetPurposeParamsIF instance) {
        if (instance instanceof ConversationSetPurposeParams) {
            return (ConversationSetPurposeParams)instance;
        }
        return ConversationSetPurposeParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PURPOSE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String purpose;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(ConversationSetPurposeParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPurpose(instance.getPurpose());
            this.setChannelId(instance.getChannelId());
            return this;
        }

        public final Builder setPurpose(String purpose) {
            this.purpose = Objects.requireNonNull(purpose, "purpose");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ConversationSetPurposeParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationSetPurposeParams(this.purpose, this.channelId);
        }

        private boolean purposeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.purposeIsSet()) {
                attributes.add("purpose");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationSetPurposeParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationSetPurposeParamsIF {
        @Nullable
        String purpose;
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty
        public void setPurpose(String purpose) {
            this.purpose = purpose;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public String getPurpose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

