/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public abstract class AbstractChatMessageParams
implements MessageParams {
    @Override
    @JsonProperty(value="channel")
    public abstract String getChannelId();

    @Override
    public abstract Optional<String> getText();

    public abstract Optional<String> getThreadTs();

    public abstract Optional<String> getUsername();

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Boolean> getAsUser();

    public abstract Optional<String> getIconEmoji();

    public abstract Optional<String> getIconUrl();

    public abstract Optional<Boolean> getLinkNames();

    public abstract Optional<Boolean> getUnfurlLinks();

    public abstract Optional<Boolean> getUnfurlMedia();

    public abstract Optional<Boolean> getReplyBroadcast();

    @Value.Check
    public void check() {
        Preconditions.checkState((this.getText().isPresent() && !Strings.isNullOrEmpty((String)this.getText().get()) || !this.getAttachments().isEmpty() || !this.getBlocks().isEmpty() ? 1 : 0) != 0, (Object)"Must include text if not providing attachments or blocks");
    }
}

